//#include <iostream>
//#include <vector>
//#include <algorithm>
//#include <numeric>
//#include <iterator>
//#include <fstream>
//#include <math.h>
//#include <map>
//#include <assert.h>

#include "./sizing.h"
#include "./define.h"


template<class T> // retun max element of a vector usually in-built > comp types int,float,double
T maxVector(const vector<T> &vec) {

        T init; init = vec[0];
        for(int i=0; i<vec.size(); i++)
        {
                if(vec[i] > init)
                        init = vec[i];
        }
return init;

}

template<class T>
T minVector(const vector<T> &vec) {

        T init; init = vec[0];
        for(int i=0; i<vec.size(); i++)
        {
                if(vec[i] < init)
                        init = vec[i];
        }

return init;
}



void createCapVector(vector<short int> &capVector)
{
	short int temp =0; // number of different unique caps there will be  

	switch(OPT_CONTEXT) {

	case 0:
		temp = NUM_SIZES;
		break;
	case 1:
		temp = NUM_SIZES;
		break;
	case 2:
		temp = 1;	// assumes cap is constant across Vts	
		break;
	case 3:
		temp = 1;
		break;
	case 4:
		temp = NUM_GATE_LENGTHS;
		break;
	case 5:
		temp = NUM_GATE_LENGTHS;
		break;
	case 6:
		temp = NSIZES;
		break;

	default:
		temp = NUM_SIZES;
	}

	short int max_fanout = 1; //default
	if(STAR_FANOUT > 2)
       	 max_fanout = STAR_FANOUT; // fanout of the star node
	else max_fanout = 2; // 2 corresponding to max fanout of a mesh

        for(int i=1; i<= max_fanout*temp;i++)
                capVector.push_back(i*INIT_CAP);
}


void buildCompositeCells(map<short int, COMP_CELL> &compCells, map<unsigned short int, LIB_CELL> &invLibs, map<unsigned short int, LIB_CELL> &nandLibs)
{
	short int xtemp =0;
        switch(OPT_CONTEXT) {

        case 0:
                xtemp = NUM_SIZES;
		break;
        case 1:
                xtemp = NUM_SIZES;
		break;
        case 2:
                xtemp = NUM_VTS;
		break;
	case 3:
		xtemp = NUM_VTS;
		break;
	case 4:
		xtemp = NUM_GATE_LENGTHS;
		break;
	case 5:
		xtemp = NUM_GATE_LENGTHS;
		break;
	case 6:
		xtemp = NVTS*NSIZES; // lowest size is HVT X1, highest size is LVT XMAX
		break;

        default:
                xtemp = NUM_SIZES;
        }


// same fan-in gates are treated homogenous since we only have invs and nands in a mesh
	for(int i=1; i <= MESH_WIDTH; i++)
	{
		int numParallelCells =0, numUnique = 0, numSizes =0;
		
		if(i <= (MESH_WIDTH+1)/2) numParallelCells = i;
		else numParallelCells = MESH_WIDTH+1-i;

		if(numParallelCells%2 == 0) // numParallelCells is even
			numUnique = numParallelCells/2 ;
		else // numParallelCells is odd
			numUnique = (numParallelCells+1)/2;

		//uniqueNum.push_back(numUnique); 
		numSizes = (short int) pow(xtemp, numUnique);

		compCells[i] = COMP_CELL(numParallelCells, numUnique, numSizes);
		
		for(short int j=0; j< numSizes; j++) { 
		
			compCells[i].sizeVectors.push_back( vector<short int>() );
			compCells[i].capVectors.push_back( vector<short int>() );

			short int rem = j;

			for(short int k = numUnique-1; k >= 0 ; k--) {

			bool flag = false;

				for( short int l = xtemp -1 ; l >=0 && flag == false; l--) {
					if(pow(xtemp,k)*l <= rem)
					{
						compCells[i].sizeVectors[j].push_back(l+1);
						rem = rem - (int) l*pow(xtemp,k);
						flag = true;
					}

				}

			}

			vector<short int> temp; temp = compCells[i].sizeVectors[j];

			if(numParallelCells%2 != 0) // if odd stage, remove extra mirror cell size
				temp.erase(temp.begin());

			std::reverse(compCells[i].sizeVectors[j].begin(), compCells[i].sizeVectors[j].end());
			//concat the reversed and mirror size vectors
			compCells[i].sizeVectors[j].insert(compCells[i].sizeVectors[j].end(), temp.begin(), temp.end());

			// Now add cap vectors and compute leakages		
			float tempLeakage =0;

			for(int k =0; k < compCells[i].sizeVectors[j].size(); k++)
			{
				if(numParallelCells <= 2 && i <= 2) // stages 1 & 2 contain only invs
				{
					compCells[i].capVectors[j].push_back(invLibs[(unsigned short int)compCells[i].sizeVectors[j][k]].getInputCap() );
					tempLeakage += invLibs[(unsigned short int)compCells[i].sizeVectors[j][k]].getLeakage();
				}
				if(numParallelCells > 2 && i <= (MESH_WIDTH+1)/2) { //stage 2 to mid of mesh
					if( k == 0 || k == compCells[i].sizeVectors[j].size()-1)
					{
						compCells[i].capVectors[j].push_back(invLibs[(unsigned short int)compCells[i].sizeVectors[j][k]].getInputCap() );
						tempLeakage += invLibs[(unsigned short int)compCells[i].sizeVectors[j][k]].getLeakage();
					} else {
						compCells[i].capVectors[j].push_back(nandLibs[(unsigned short int)compCells[i].sizeVectors[j][k]].getInputCap() );
						tempLeakage += nandLibs[(unsigned short int)compCells[i].sizeVectors[j][k]].getLeakage();
					}
				}

				if(i > (MESH_WIDTH+1)/2) // second half of mesh, contains only nands
				{
					compCells[i].capVectors[j].push_back(nandLibs[(unsigned short int)compCells[i].sizeVectors[j][k]].getInputCap() );
					tempLeakage += nandLibs[(unsigned short int)compCells[i].sizeVectors[j][k]].getLeakage();

				}
			}

			compCells[i].leakages.push_back(tempLeakage);

		} // for each size vector ends here

			
	} // for each stage of MESH ends here
	

	// Now add delay, power numbers to the composite cells for all possible loads


	for(int i = 1; i < MESH_WIDTH; i++)
	{
		for(int j = 0; j < compCells[i+1].capVectors.size(); j++)
		{
			vector<short int> loadCapVector = compCells[i+1].capVectors[j];

			for(int k = 0; k < compCells[i].sizeVectors.size() ; k++)
			{

				vector<short int> currStageSizeVector = compCells[i].sizeVectors[k];

//				map<int , int> currCellDelays; // <delay, junk index>, to automatically get the highest delay
				vector<short int> currCellDelays;

				//each cell has two load cells
				if(i < (MESH_WIDTH+1)/2) {

					for(int l=0; l < currStageSizeVector.size(); l++)
					{

						short int totalLoadCap = loadCapVector[l] + loadCapVector[l+1];
						//if(i <= 2) 
						//currCellDelays[ invLibs[(unsigned int)currStageSizeVector[l]].getDelay(totalLoadCap)  ] = l+1;
						//else {
							if(l == 0 || l == currStageSizeVector.size()-1)
								currCellDelays.push_back(invLibs[(unsigned short int)currStageSizeVector[l]].getDelay(totalLoadCap));
							else
								currCellDelays.push_back( nandLibs[(unsigned short int)currStageSizeVector[l]].getDelay(totalLoadCap));
						//}

					}

				} else {

					for(int l=0; l< currStageSizeVector.size(); l++)
					{
						short int totalLoadCap = 0;
						if(l-1 >= 0) totalLoadCap += loadCapVector[l-1];
						if(l < loadCapVector.size()) totalLoadCap += loadCapVector[l];

						if(i == (MESH_WIDTH+1)/2)
						{
							
							if(l == 0 || l == currStageSizeVector.size()-1)
								currCellDelays.push_back(invLibs[(unsigned short int)currStageSizeVector[l]].getDelay(totalLoadCap));
							else
								currCellDelays.push_back(nandLibs[(unsigned short int)currStageSizeVector[l]].getDelay(totalLoadCap));
						} else 
							currCellDelays.push_back(nandLibs[(unsigned short int)currStageSizeVector[l]].getDelay(totalLoadCap));
					}

				}

				
				//map<int,int>::const_iterator delayIter; delayIter = currCellDelays.end();

				TUPLE_COMP_CELL tempTuple(k+1,maxVector<short int>(currCellDelays),compCells[i].leakages[k]);
				//TUPLE_COMP_CELL tempTuple(k+1,101,compCells[i].leakages[k]);

				compCells[i].loadCompCells[j+1].push_back(tempTuple);

			} // for each current stage's size ends here


		} // for each load size ends here

	} // for each stage of the mesh ends here 

} // buildCompositeCells ends here


void printCompositeCells(map<short int, COMP_CELL> &compCells, fstream &logfile) {

map<short int, COMP_CELL>::iterator iter;

short int i =0;

for(iter = compCells.begin(); iter != compCells.end(); iter++)
{

i = iter->first;


		// debug - print the composite cell's size, cap vectors
		logfile << "Comp cell stage : " << i << " sizes:" << compCells[i].numSizes << " numUnique;" << compCells[i].uniqueNumGates << endl;
		
		logfile << "Size_Index \t Size Vector \t Cap Vector \t Power" << endl; 
		
		for(int j=0; j < compCells[i].sizeVectors.size(); j++)
		{	
			logfile << j+1 << "\t \t";
			for(int k=0; k < compCells[i].sizeVectors[j].size(); k++)
				logfile << compCells[i].sizeVectors[j][k] << " ";
			logfile << "\t \t";
			for(int k=0; k < compCells[i].capVectors[j].size(); k++)
				logfile << compCells[i].capVectors[j][k] << " ";
			
			logfile << "\t \t ";

                        logfile << compCells[i].leakages[j] << " ";
			
			logfile << endl;
		}

		logfile << "LOAD_SIZE \t COMP_CELL_SIZE \t DELAY \t POWER" << endl;
		map<short int, vector<TUPLE_COMP_CELL> >::const_iterator loadIter;

		for(loadIter = compCells[i].loadCompCells.begin(); loadIter != compCells[i].loadCompCells.end(); loadIter++)
		{
			short int loadSize = loadIter->first;
			
			for(int k =0; k < compCells[i].loadCompCells[loadSize].size(); k++)
			{
				TUPLE_COMP_CELL tempTuple = compCells[i].loadCompCells[loadSize][k];
				logfile << loadSize << "\t \t" << tempTuple.size << "\t \t \t" << tempTuple.delay << "\t \t" << tempTuple.power << endl;

			}

		}

}

}


void createLibsInv(map<unsigned short int, LIB_CELL> &invLibs)
{
	vector<short int> capVector; createCapVector(capVector);
        short int temp =0; //


        switch(OPT_CONTEXT) {

        case 0:
                temp = NUM_SIZES;
		break;
        case 1:
                temp = NUM_SIZES;
		break;
        case 2:
                temp = NUM_VTS;
		break;
	case 3:
		temp = NUM_VTS;
		break;
	case 4:
		temp = NUM_GATE_LENGTHS;
		break;
	case 5:
		temp = NUM_GATE_LENGTHS;
		break;
	case 6:
		temp = NVTS*NSIZES; // lowest size is HVT X1, highest size is LVT XMAX
		break;

        default:
                temp = NUM_SIZES;
        }


	if(OPT_CONTEXT == 0 || OPT_CONTEXT == 1) {

		float leakJump = (float)(INV_TVT_MAX_POWER - INV_TVT_MIN_POWER)/(temp-1);
		for(int i = temp; i> 0; i--) {

			float leakage = INV_TVT_MIN_POWER + i*leakJump;
			LIB_CELL tempCell(i,"INV",leakage,capVector[i-1]);

			short int delay1,delay2;
			if(OPT_CONTEXT == 0) {
				delay1 = INV_TVT_MAX_FCAP + (short int)((temp-i)*(INV_TVT_MIN_FCAP - INV_TVT_MAX_FCAP)/(temp-1));
				delay2 = INV_TVT_MAX_LCAP + (short int)((temp-i)*(INV_TVT_MIN_LCAP - INV_TVT_MAX_LCAP)/(temp-1));
			cout << delay1 << " " << delay2 << endl;
			tempCell.setDelayTable(delay1, delay2, false, INV_DELAY_CAP_COEFF_LP_LD, capVector);
			} else {
				delay1 = INV_TVT_MAX_FCAP + (short int)(INV_TVT_MIN_FCAP - INV_TVT_MAX_FCAP)*(1-exp(INV_NLD_COEFF_LP*(temp-i)));
				delay2 = INV_TVT_MAX_LCAP + (short int)(INV_TVT_MIN_LCAP - INV_TVT_MAX_LCAP)*(1-exp(INV_NLD_COEFF_LP*(temp-i)));
			tempCell.setDelayTable(delay1, delay2, true, INV_DELAY_CAP_COEFF_LP_NLD, capVector);
			}
			//tempCell.setDelayTable(delay1, delay2, IS_DELAY_CAP_NONLIN, INV_DELAY_CAP_COEFF, capVector);
tempCell.setMinMaxDelay();
		invLibs[i] = tempCell;
		}


	} else if (OPT_CONTEXT == 2 || OPT_CONTEXT == 3) {
		vector<float> powerVector;

		for(int i  = 0; i < temp; i++)
			powerVector.push_back( INV_TVT_MIN_POWER + (INV_TVT_MAX_POWER-INV_TVT_MIN_POWER)/pow(INV_EP_POWER_COEFF,i)   );		

                for(int i = temp; i> 0; i--) {

                        LIB_CELL tempCell(i,"INV", powerVector[temp-i] ,capVector[0]); // cap doesn't equals to basic cap
			
			short int delay1,delay2;
                        if(OPT_CONTEXT == 2) {
                                delay1 = INV_TVT_MAX_FCAP + (short int)((temp-i)*(float)(INV_TVT_MIN_FCAP - INV_TVT_MAX_FCAP)/(temp-1));
                                delay2 = INV_TVT_MAX_LCAP + (short int)((temp-i)*(float)(INV_TVT_MIN_LCAP - INV_TVT_MAX_LCAP)/(temp-1));
                        tempCell.setDelayTable(delay1, delay2, false, INV_DELAY_CAP_COEFF_EP_LD, capVector);
                        } else {
                                delay1 = INV_TVT_MAX_FCAP + (short int)(INV_TVT_MIN_FCAP - INV_TVT_MAX_FCAP)*(1-exp(INV_NLD_COEFF_EP*(temp-i)));
                                delay2 = INV_TVT_MAX_LCAP + (short int)(INV_TVT_MIN_LCAP - INV_TVT_MAX_LCAP)*(1-exp(INV_NLD_COEFF_EP*(temp-i)));
                        tempCell.setDelayTable(delay1, delay2, true, INV_DELAY_CAP_COEFF_EP_NLD, capVector);
                        }
                        //tempCell.setDelayTable(delay1, delay2, IS_DELAY_CAP_NONLIN, INV_DELAY_CAP_COEFF, capVector);
tempCell.setMinMaxDelay();
		invLibs[i] = tempCell;
                }

	} else if(OPT_CONTEXT == 4 || OPT_CONTEXT == 5) { 

		vector<float> powerVector;
		 for(int i  = 0; i < temp; i++)
                        powerVector.push_back( INV_TVT_MIN_POWER + (INV_TVT_MAX_POWER-INV_TVT_MIN_POWER)/pow(INV_EP_LENGTH_POWER_COEFF,i)   );

		for(int i = temp; i> 0; i--) {
 
                        LIB_CELL tempCell(i,"INV", powerVector[temp-i] ,capVector[i-1]);
 
			short int delay1,delay2;
                        if(OPT_CONTEXT == 4) {
                                delay1 = INV_TVT_MAX_FCAP + (short int)((temp-i)*(float)(INV_TVT_MIN_FCAP - INV_TVT_MAX_FCAP)/(temp-1));
                                delay2 = INV_TVT_MAX_LCAP + (short int)((temp-i)*(float)(INV_TVT_MIN_LCAP - INV_TVT_MAX_LCAP)/(temp-1));
                        tempCell.setDelayTable(delay1, delay2, false, INV_DELAY_CAP_COEFF_GEP_LD, capVector);
                        } else {
                                delay1 = INV_TVT_MAX_FCAP + (short int)(INV_TVT_MIN_FCAP - INV_TVT_MAX_FCAP)*(1-exp(INV_NLD_COEFF_GEP*(temp-i)));
                                delay2 = INV_TVT_MAX_LCAP + (short int)(INV_TVT_MIN_LCAP - INV_TVT_MAX_LCAP)*(1-exp(INV_NLD_COEFF_GEP*(temp-i)));
                        tempCell.setDelayTable(delay1, delay2, true, INV_DELAY_CAP_COEFF_GEP_NLD, capVector);
                        }
                        //tempCell.setDelayTable(delay1, delay2, IS_DELAY_CAP_NONLIN, INV_DELAY_CAP_COEFF, capVector);
tempCell.setMinMaxDelay();
		invLibs[i] = tempCell;
                }

	} else { // Joint Vt
		vector<double> powerVector;
		for(int i  = 0; i < NSIZES; i++)
                        powerVector.push_back(INV_HVT_MIN_POWER + (INV_HVT_MAX_POWER-INV_HVT_MIN_POWER)/pow(INV_EP_LENGTH_POWER_COEFF,i));

		for(int i = 0; i < NSIZES; i++ ) {
			LIB_CELL tempCell(temp,"INV", powerVector[i] ,capVector[NSIZES-i-1]);
			int delay1,delay2;

                        if(OPT_CONTEXT == 6) {
                                delay1 = INV_HVT_MAX_FCAP + (int)((temp-i)*(double)(INV_HVT_MIN_FCAP - INV_HVT_MAX_FCAP)/(temp-1));
                                delay2 = INV_HVT_MAX_LCAP + (int)((temp-i)*(double)(INV_HVT_MIN_LCAP - INV_HVT_MAX_LCAP)/(temp-1));
                        } else {
                                delay1 = INV_HVT_MAX_FCAP + (INV_HVT_MIN_FCAP - INV_HVT_MAX_FCAP)*(1-exp(INV_NLD_COEFF*(temp-i)));
                                delay2 = INV_HVT_MAX_LCAP + (INV_HVT_MIN_LCAP - INV_HVT_MAX_LCAP)*(1-exp(INV_NLD_COEFF*(temp-i)));
                        }
			cout << "delay1: " << delay1 << "delay2: " << delay2 << endl;
                        tempCell.setDelayTable(delay1, delay2, IS_DELAY_CAP_NONLIN, INV_DELAY_CAP_COEFF, capVector);
tempCell.setMinMaxDelay();
		invLibs[temp] = tempCell;
		temp--;
		}

		powerVector.clear();

		for(int i  = 0; i < NSIZES; i++)
                        powerVector.push_back(INV_TVT_MIN_POWER + (INV_TVT_MAX_POWER-INV_TVT_MIN_POWER)/pow(INV_EP_LENGTH_POWER_COEFF,i));

                for(int i = 0; i < NSIZES; i++ ) {
                        LIB_CELL tempCell(temp,"INV", powerVector[i] ,capVector[NSIZES-i-1]);
			int delay1,delay2;

                        if(OPT_CONTEXT == 6) {
                                int delay1 = INV_TVT_MAX_FCAP + (int)((temp-i)*(double)(INV_TVT_MIN_FCAP - INV_TVT_MAX_FCAP)/(temp-1));
                                int delay2 = INV_TVT_MAX_LCAP + (int)((temp-i)*(double)(INV_TVT_MIN_LCAP - INV_TVT_MAX_LCAP)/(temp-1));
                        } else {
                                int delay1 = INV_TVT_MAX_FCAP + (INV_TVT_MIN_FCAP - INV_TVT_MAX_FCAP)*(1-exp(INV_NLD_COEFF*(temp-i)));
                                int delay2 = INV_TVT_MAX_LCAP + (INV_TVT_MIN_LCAP - INV_TVT_MAX_LCAP)*(1-exp(INV_NLD_COEFF*(temp-i)));
                        }
			cout << "delay1: " << delay1 << "delay2: " << delay2 << endl;
                        tempCell.setDelayTable(delay1, delay2, IS_DELAY_CAP_NONLIN, INV_DELAY_CAP_COEFF, capVector);
tempCell.setMinMaxDelay();
		invLibs[temp] = tempCell;
		temp--;
		
                }

                powerVector.clear();

		for(int i  = 0; i < NSIZES; i++)
                        powerVector.push_back(INV_LVT_MIN_POWER + (INV_LVT_MAX_POWER-INV_LVT_MIN_POWER)/pow(INV_EP_LENGTH_POWER_COEFF,i));

                for(int i = 0; i < NSIZES; i++ ) {
                        LIB_CELL tempCell(temp,"INV", powerVector[i] ,capVector[NSIZES-i-1]);
			int delay1,delay2;

                        if(OPT_CONTEXT == 6) {
                                int delay1 = INV_LVT_MAX_FCAP + (int)((temp-i)*(double)(INV_LVT_MIN_FCAP - INV_LVT_MAX_FCAP)/(temp-1));
                                int delay2 = INV_LVT_MAX_LCAP + (int)((temp-i)*(double)(INV_LVT_MIN_LCAP - INV_LVT_MAX_LCAP)/(temp-1));
                        } else {
                                int delay1 = INV_LVT_MAX_FCAP + (INV_LVT_MIN_FCAP - INV_LVT_MAX_FCAP)*(1-exp(INV_NLD_COEFF*(temp-i)));
                                int delay2 = INV_LVT_MAX_LCAP + (INV_LVT_MIN_LCAP - INV_LVT_MAX_LCAP)*(1-exp(INV_NLD_COEFF*(temp-i)));
                        }
			cout << "delay1: " << delay1 << "delay2: " << delay2 << endl;
                        tempCell.setDelayTable(delay1, delay2, IS_DELAY_CAP_NONLIN, INV_DELAY_CAP_COEFF, capVector);
tempCell.setMinMaxDelay();
		invLibs[temp] = tempCell;
                temp--;
                }

	}

}



void createLibsNand(map<unsigned short int, LIB_CELL> &nandLibs)
{


	vector<short int> capVector; createCapVector(capVector);
        short int temp =0; //


        switch(OPT_CONTEXT) {

        case 0:
                temp = NUM_SIZES;
		break;
        case 1:
                temp = NUM_SIZES;
		break;
        case 2:
                temp = NUM_VTS;
		break;
	case 3:
		temp = NUM_VTS;
		break;
	case 4:
		temp = NUM_GATE_LENGTHS;
		break;
	case 5:
		temp = NUM_GATE_LENGTHS;
		break;
	case 6:
		temp = NVTS*NSIZES; // lowest size is HVT X1, highest size is LVT XMAX
		break;
        default:
                temp = NUM_SIZES;
        }


	if(OPT_CONTEXT == 0 || OPT_CONTEXT == 1) {

		float leakJump = (float)(NAND_TVT_MAX_POWER - NAND_TVT_MIN_POWER)/(temp-1);
		for(int i = temp; i> 0; i--) {

			float leakage = NAND_TVT_MIN_POWER + i*leakJump;
			LIB_CELL tempCell(i,"NAND",leakage,capVector[i-1]);

			short int delay1,delay2;
			if(OPT_CONTEXT == 0) {
				delay1 = NAND_TVT_MAX_FCAP + (short int)((temp-i)*(float)(NAND_TVT_MIN_FCAP - NAND_TVT_MAX_FCAP)/(temp-1));
				delay2 = NAND_TVT_MAX_LCAP + (short int)((temp-i)*(float)(NAND_TVT_MIN_LCAP - NAND_TVT_MAX_LCAP)/(temp-1));
			tempCell.setDelayTable(delay1, delay2, false, NAND_DELAY_CAP_COEFF_LP_LD, capVector);
			} else {
				delay1 = NAND_TVT_MAX_FCAP + (short int)(NAND_TVT_MIN_FCAP - NAND_TVT_MAX_FCAP)*(1-exp(NAND_NLD_COEFF_LP*(temp-i)));
				delay2 = NAND_TVT_MAX_LCAP + (short int)(NAND_TVT_MIN_LCAP - NAND_TVT_MAX_LCAP)*(1-exp(NAND_NLD_COEFF_LP*(temp-i)));
			tempCell.setDelayTable(delay1, delay2, true, NAND_DELAY_CAP_COEFF_LP_NLD, capVector);
			}
			//tempCell.setDelayTable(delay1, delay2, IS_DELAY_CAP_NONLIN, NAND_DELAY_CAP_COEFF, capVector);
tempCell.setMinMaxDelay();
		nandLibs[i] = tempCell;
		}


	} else if (OPT_CONTEXT == 2 || OPT_CONTEXT == 3) {
		vector<float> powerVector;

		for(int i  = 0; i < temp; i++)
			powerVector.push_back( NAND_TVT_MIN_POWER + (NAND_TVT_MAX_POWER-NAND_TVT_MIN_POWER)/pow(NAND_EP_POWER_COEFF,i)   );		

                for(int i = temp; i> 0; i--) {

                        LIB_CELL tempCell(i,"NAND", powerVector[temp-i] ,capVector[0]); // cap doesn't equals to basic cap
			short int delay1,delay2;
                        if(OPT_CONTEXT == 2) {
                                delay1 = NAND_TVT_MAX_FCAP + (short int)((temp-i)*(float)(NAND_TVT_MIN_FCAP - NAND_TVT_MAX_FCAP)/(temp-1));
                                delay2 = NAND_TVT_MAX_LCAP + (short int)((temp-i)*(float)(NAND_TVT_MIN_LCAP - NAND_TVT_MAX_LCAP)/(temp-1));
                        tempCell.setDelayTable(delay1, delay2, false, NAND_DELAY_CAP_COEFF_EP_LD, capVector);
                        } else {
                                delay1 = NAND_TVT_MAX_FCAP + (short int)(NAND_TVT_MIN_FCAP - NAND_TVT_MAX_FCAP)*(1-exp(NAND_NLD_COEFF_EP*(temp-i)));
                                delay2 = NAND_TVT_MAX_LCAP + (short int)(NAND_TVT_MIN_LCAP - NAND_TVT_MAX_LCAP)*(1-exp(NAND_NLD_COEFF_EP*(temp-i)));
                        tempCell.setDelayTable(delay1, delay2, true, NAND_DELAY_CAP_COEFF_EP_NLD, capVector);
                        }
                        //tempCell.setDelayTable(delay1, delay2, IS_DELAY_CAP_NONLIN, NAND_DELAY_CAP_COEFF, capVector);
tempCell.setMinMaxDelay();
		nandLibs[i] = tempCell;
                }

	} else if(OPT_CONTEXT == 4 || OPT_CONTEXT == 5) { 

		vector<float> powerVector;
		 for(int i  = 0; i < temp; i++)
                        powerVector.push_back( NAND_TVT_MIN_POWER + (NAND_TVT_MAX_POWER-NAND_TVT_MIN_POWER)/pow(NAND_EP_LENGTH_POWER_COEFF,i)   );

		for(int i = temp; i> 0; i--) {
 
                        LIB_CELL tempCell(i,"NAND", powerVector[temp-i] ,capVector[i-1]);
			short int delay1,delay2;
                        if(OPT_CONTEXT == 4) {
                                delay1 = NAND_TVT_MAX_FCAP + (short int)((temp-i)*(float)(NAND_TVT_MIN_FCAP - NAND_TVT_MAX_FCAP)/(temp-1));
                                delay2 = NAND_TVT_MAX_LCAP + (short int)((temp-i)*(float)(NAND_TVT_MIN_LCAP - NAND_TVT_MAX_LCAP)/(temp-1));
                        tempCell.setDelayTable(delay1, delay2, false, NAND_DELAY_CAP_COEFF_GEP_LD, capVector);
                        } else {
                                delay1 = NAND_TVT_MAX_FCAP + (short int)(NAND_TVT_MIN_FCAP - NAND_TVT_MAX_FCAP)*(1-exp(NAND_NLD_COEFF_GEP*(temp-i)));
                                delay2 = NAND_TVT_MAX_LCAP + (short int)(NAND_TVT_MIN_LCAP - NAND_TVT_MAX_LCAP)*(1-exp(NAND_NLD_COEFF_GEP*(temp-i)));
                        tempCell.setDelayTable(delay1, delay2, true, NAND_DELAY_CAP_COEFF_GEP_NLD, capVector);
                        }
                        //tempCell.setDelayTable(delay1, delay2, IS_DELAY_CAP_NONLIN, NAND_DELAY_CAP_COEFF, capVector);
tempCell.setMinMaxDelay();
		nandLibs[i] = tempCell;
                }

	} else { // Joint Vt
		vector<double> powerVector;
		for(int i  = 0; i < NSIZES; i++)
                        powerVector.push_back(NAND_HVT_MIN_POWER + (NAND_HVT_MAX_POWER-NAND_HVT_MIN_POWER)/pow(NAND_EP_LENGTH_POWER_COEFF,i));

		for(int i = 0; i < NSIZES; i++ ) {
			LIB_CELL tempCell(temp,"NAND", powerVector[i] ,capVector[NSIZES-i-1]);
			int delay1,delay2;
                        if(OPT_CONTEXT == 6) {
                                delay1 = NAND_HVT_MAX_FCAP + (int)((temp-i)*(double)(NAND_HVT_MIN_FCAP - NAND_HVT_MAX_FCAP)/(temp-1));
                                delay2 = NAND_HVT_MAX_LCAP + (int)((temp-i)*(double)(NAND_HVT_MIN_LCAP - NAND_HVT_MAX_LCAP)/(temp-1));
                        } else {
                                delay1 = NAND_HVT_MAX_FCAP + (NAND_HVT_MIN_FCAP - NAND_HVT_MAX_FCAP)*(1-exp(NAND_NLD_COEFF*(temp-i)));
                                delay2 = NAND_HVT_MAX_LCAP + (NAND_HVT_MIN_LCAP - NAND_HVT_MAX_LCAP)*(1-exp(NAND_NLD_COEFF*(temp-i)));
                        }
			cout << "delay1: " << delay1 << "delay2: " << delay2 << endl;
                        tempCell.setDelayTable(delay1, delay2, IS_DELAY_CAP_NONLIN, NAND_DELAY_CAP_COEFF, capVector);
tempCell.setMinMaxDelay();
		nandLibs[temp] = tempCell;
		temp--;
		}

		powerVector.clear();

		for(int i  = 0; i < NSIZES; i++)
                        powerVector.push_back(NAND_TVT_MIN_POWER + (NAND_TVT_MAX_POWER-NAND_TVT_MIN_POWER)/pow(NAND_EP_LENGTH_POWER_COEFF,i));

                for(int i = 0; i < NSIZES; i++ ) {
                        LIB_CELL tempCell(temp,"NAND", powerVector[i] ,capVector[NSIZES-i-1]);
			int delay1,delay2;
                        if(OPT_CONTEXT == 6) {
                                delay1 = NAND_TVT_MAX_FCAP + (int)((temp-i)*(double)(NAND_TVT_MIN_FCAP - NAND_TVT_MAX_FCAP)/(temp-1));
                                delay2 = NAND_TVT_MAX_LCAP + (int)((temp-i)*(double)(NAND_TVT_MIN_LCAP - NAND_TVT_MAX_LCAP)/(temp-1));
                        } else {
                                delay1 = NAND_TVT_MAX_FCAP + (NAND_TVT_MIN_FCAP - NAND_TVT_MAX_FCAP)*(1-exp(NAND_NLD_COEFF*(temp-i)));
                                delay2 = NAND_TVT_MAX_LCAP + (NAND_TVT_MIN_LCAP - NAND_TVT_MAX_LCAP)*(1-exp(NAND_NLD_COEFF*(temp-i)));
                        }
			cout << "delay1: " << delay1 << "delay2: " << delay2 << endl;
                        tempCell.setDelayTable(delay1, delay2, IS_DELAY_CAP_NONLIN, NAND_DELAY_CAP_COEFF, capVector);
tempCell.setMinMaxDelay();
		nandLibs[temp] = tempCell;
		temp--;
		
                }

                powerVector.clear();

		for(int i  = 0; i < NSIZES; i++)
                        powerVector.push_back(NAND_LVT_MIN_POWER + (NAND_LVT_MAX_POWER-NAND_LVT_MIN_POWER)/pow(NAND_EP_LENGTH_POWER_COEFF,i));

                for(int i = 0; i < NSIZES; i++ ) {
                        LIB_CELL tempCell(temp,"NAND", powerVector[i] ,capVector[NSIZES-i-1]);
			int delay1,delay2;
                        if(OPT_CONTEXT == 6) {
                                delay1 = NAND_LVT_MAX_FCAP + (int)((temp-i)*(double)(NAND_LVT_MIN_FCAP - NAND_LVT_MAX_FCAP)/(temp-1));
                                delay2 = NAND_LVT_MAX_LCAP + (int)((temp-i)*(double)(NAND_LVT_MIN_LCAP - NAND_LVT_MAX_LCAP)/(temp-1));
                        } else {
                                delay1 = NAND_LVT_MAX_FCAP + (NAND_LVT_MIN_FCAP - NAND_LVT_MAX_FCAP)*(1-exp(NAND_NLD_COEFF*(temp-i)));
                                delay2 = NAND_LVT_MAX_LCAP + (NAND_LVT_MIN_LCAP - NAND_LVT_MAX_LCAP)*(1-exp(NAND_NLD_COEFF*(temp-i)));
                        }
			cout << "delay1: " << delay1 << "delay2: " << delay2 << endl;
                        tempCell.setDelayTable(delay1, delay2, IS_DELAY_CAP_NONLIN, NAND_DELAY_CAP_COEFF, capVector);
tempCell.setMinMaxDelay();
		nandLibs[temp] = tempCell;
                temp--;
                }

	}



}


void createLibsThird(map<unsigned short int, LIB_CELL> &thirdLibs)
{

string cellName; 
short int thirdType = STAR_FANIN;

switch(thirdType) {
case 1:
	cellName = "INV";
	break;
case 2:
	cellName = "NAND";
	break;
case 3:
	cellName = "AOI21";
	break;
case 4:
	cellName = "AOI211";
	break;
case 5:
	cellName = "AOI221";
	break;
case 6:
	cellName = "AOI222";
	break;
default:
	cellName = "AOI211"; //corresponds to fan in of 4
}

//cout << "third libs name:" << cellName << endl;
	vector<short int> capVector; createCapVector(capVector);
        short int temp =0; //


        switch(OPT_CONTEXT) {

        case 0:
                temp = NUM_SIZES;
		break;
        case 1:
                temp = NUM_SIZES;
		break;
        case 2:
                temp = NUM_VTS;
		break;
	case 3:
		temp = NUM_VTS;
		break;
	case 4:
		temp = NUM_GATE_LENGTHS;
		break;
	case 5:
		temp = NUM_GATE_LENGTHS;
		break;
	case 6:
		temp = NVTS*NSIZES; // lowest size is HVT X1, highest size is LVT XMAX
		break;

        default:
                temp = NUM_SIZES;
        }


	if(OPT_CONTEXT == 0 || OPT_CONTEXT == 1) {

		float leakJump = (float)(AOI222_TVT_MAX_POWER - AOI222_TVT_MIN_POWER)/(temp-1);
		for(int i = temp; i> 0; i--) {

			float leakage = AOI222_TVT_MIN_POWER + i*leakJump;
			LIB_CELL tempCell(i,cellName,leakage,capVector[i-1]);
			short int delay1,delay2;
			if(OPT_CONTEXT == 0) {
				delay1 = AOI222_TVT_MAX_FCAP + (short int)((temp-i)*(float)(AOI222_TVT_MIN_FCAP - AOI222_TVT_MAX_FCAP)/(temp-1));
				delay2 = AOI222_TVT_MAX_LCAP + (short int)((temp-i)*(float)(AOI222_TVT_MIN_LCAP - AOI222_TVT_MAX_LCAP)/(temp-1));
			tempCell.setDelayTable(delay1, delay2, false, AOI222_DELAY_CAP_COEFF_LP_LD, capVector);
			} else {
				delay1 = AOI222_TVT_MAX_FCAP + (short int)(AOI222_TVT_MIN_FCAP - AOI222_TVT_MAX_FCAP)*(1-exp(AOI222_NLD_COEFF_LP*(temp-i)));
				delay2 = AOI222_TVT_MAX_LCAP + (short int)(AOI222_TVT_MIN_LCAP - AOI222_TVT_MAX_LCAP)*(1-exp(AOI222_NLD_COEFF_LP*(temp-i)));
			tempCell.setDelayTable(delay1, delay2, true, AOI222_DELAY_CAP_COEFF_LP_NLD, capVector);
			}
			//tempCell.setDelayTable(delay1, delay2, IS_DELAY_CAP_NONLIN, AOI222_DELAY_CAP_COEFF, capVector);
tempCell.setMinMaxDelay();
		thirdLibs[i] = tempCell;
		}


	} else if (OPT_CONTEXT == 2 || OPT_CONTEXT == 3) {
		vector<float> powerVector;

		for(int i  = 0; i < temp; i++)
			powerVector.push_back( AOI222_TVT_MIN_POWER + (AOI222_TVT_MAX_POWER-AOI222_TVT_MIN_POWER)/pow(AOI222_EP_POWER_COEFF,i)   );		

                for(int i = temp; i> 0; i--) {

                        LIB_CELL tempCell(i,cellName, powerVector[temp-i] ,capVector[0]); // cap doesn't equals to basic cap
			short int delay1,delay2;
                        if(OPT_CONTEXT == 2) {
                                delay1 = AOI222_TVT_MAX_FCAP + (short int)((temp-i)*(float)(AOI222_TVT_MIN_FCAP - AOI222_TVT_MAX_FCAP)/(temp-1));
                                delay2 = AOI222_TVT_MAX_LCAP + (short int)((temp-i)*(float)(AOI222_TVT_MIN_LCAP - AOI222_TVT_MAX_LCAP)/(temp-1));
                        tempCell.setDelayTable(delay1, delay2, false, AOI222_DELAY_CAP_COEFF_EP_LD, capVector);
                        } else {
                                delay1 = AOI222_TVT_MAX_FCAP + (short int)(AOI222_TVT_MIN_FCAP - AOI222_TVT_MAX_FCAP)*(1-exp(AOI222_NLD_COEFF_EP*(temp-i)));
                                delay2 = AOI222_TVT_MAX_LCAP + (short int)(AOI222_TVT_MIN_LCAP - AOI222_TVT_MAX_LCAP)*(1-exp(AOI222_NLD_COEFF_EP*(temp-i)));
                        tempCell.setDelayTable(delay1, delay2, true, AOI222_DELAY_CAP_COEFF_EP_NLD, capVector);
                        }
                        //tempCell.setDelayTable(delay1, delay2, IS_DELAY_CAP_NONLIN, AOI222_DELAY_CAP_COEFF, capVector);
tempCell.setMinMaxDelay();
		thirdLibs[i] = tempCell;
                }

	} else if(OPT_CONTEXT == 4 || OPT_CONTEXT == 5) { 

		vector<float> powerVector;
		 for(int i  = 0; i < temp; i++)
                        powerVector.push_back( AOI222_TVT_MIN_POWER + (AOI222_TVT_MAX_POWER-AOI222_TVT_MIN_POWER)/pow(AOI222_EP_LENGTH_POWER_COEFF,i)   );

		for(int i = temp; i> 0; i--) {
 
                        LIB_CELL tempCell(i,cellName, powerVector[temp-i] ,capVector[i-1]);
			short int delay1,delay2;
                        if(OPT_CONTEXT == 4) {
                                delay1 = AOI222_TVT_MAX_FCAP + (short int)((temp-i)*(float)(AOI222_TVT_MIN_FCAP - AOI222_TVT_MAX_FCAP)/(temp-1));
                                delay2 = AOI222_TVT_MAX_LCAP + (short int)((temp-i)*(float)(AOI222_TVT_MIN_LCAP - AOI222_TVT_MAX_LCAP)/(temp-1));
                        tempCell.setDelayTable(delay1, delay2, false, AOI222_DELAY_CAP_COEFF_GEP_LD, capVector);
                        } else {
                                delay1 = AOI222_TVT_MAX_FCAP + (short int)(AOI222_TVT_MIN_FCAP - AOI222_TVT_MAX_FCAP)*(1-exp(AOI222_NLD_COEFF_GEP*(temp-i)));
                                delay2 = AOI222_TVT_MAX_LCAP + (short int)(AOI222_TVT_MIN_LCAP - AOI222_TVT_MAX_LCAP)*(1-exp(AOI222_NLD_COEFF_GEP*(temp-i)));
                        tempCell.setDelayTable(delay1, delay2, true, AOI222_DELAY_CAP_COEFF_GEP_NLD, capVector);
                        }
                        //tempCell.setDelayTable(delay1, delay2, IS_DELAY_CAP_NONLIN, AOI222_DELAY_CAP_COEFF, capVector);
tempCell.setMinMaxDelay();
		thirdLibs[i] = tempCell;
                }

	} else { // Joint Vt
		vector<double> powerVector;
		for(int i  = 0; i < NSIZES; i++)
                        powerVector.push_back(AOI222_HVT_MIN_POWER + (AOI222_HVT_MAX_POWER-AOI222_HVT_MIN_POWER)/pow(AOI222_EP_LENGTH_POWER_COEFF,i));

		for(int i = 0; i < NSIZES; i++ ) {
			LIB_CELL tempCell(temp,cellName, powerVector[i] ,capVector[NSIZES-i-1]);
			int delay1,delay2;
                        if(OPT_CONTEXT == 6) {
                                delay1 = AOI222_HVT_MAX_FCAP + (int)((temp-i)*(double)(AOI222_HVT_MIN_FCAP - AOI222_HVT_MAX_FCAP)/(temp-1));
                                delay2 = AOI222_HVT_MAX_LCAP + (int)((temp-i)*(double)(AOI222_HVT_MIN_LCAP - AOI222_HVT_MAX_LCAP)/(temp-1));
                        } else {
                                delay1 = AOI222_HVT_MAX_FCAP + (AOI222_HVT_MIN_FCAP - AOI222_HVT_MAX_FCAP)*(1-exp(AOI222_NLD_COEFF*(temp-i)));
                                delay2 = AOI222_HVT_MAX_LCAP + (AOI222_HVT_MIN_LCAP - AOI222_HVT_MAX_LCAP)*(1-exp(AOI222_NLD_COEFF*(temp-i)));
                        }
			cout << "delay1: " << delay1 << "delay2: " << delay2 << endl;
                        tempCell.setDelayTable(delay1, delay2, IS_DELAY_CAP_NONLIN, AOI222_DELAY_CAP_COEFF, capVector);
tempCell.setMinMaxDelay();
		thirdLibs[temp] = tempCell;
		temp--;
		}

		powerVector.clear();

		for(int i  = 0; i < NSIZES; i++)
                        powerVector.push_back(AOI222_TVT_MIN_POWER + (AOI222_TVT_MAX_POWER-AOI222_TVT_MIN_POWER)/pow(AOI222_EP_LENGTH_POWER_COEFF,i));

                for(int i = 0; i < NSIZES; i++ ) {
                        LIB_CELL tempCell(temp,cellName, powerVector[i] ,capVector[NSIZES-i-1]);
			int delay1,delay2;
                        if(OPT_CONTEXT == 6) {
                                delay1 = AOI222_TVT_MAX_FCAP + (int)((temp-i)*(double)(AOI222_TVT_MIN_FCAP - AOI222_TVT_MAX_FCAP)/(temp-1));
                                delay2 = AOI222_TVT_MAX_LCAP + (int)((temp-i)*(double)(AOI222_TVT_MIN_LCAP - AOI222_TVT_MAX_LCAP)/(temp-1));
                        } else {
                                delay1 = AOI222_TVT_MAX_FCAP + (AOI222_TVT_MIN_FCAP - AOI222_TVT_MAX_FCAP)*(1-exp(AOI222_NLD_COEFF*(temp-i)));
                                delay2 = AOI222_TVT_MAX_LCAP + (AOI222_TVT_MIN_LCAP - AOI222_TVT_MAX_LCAP)*(1-exp(AOI222_NLD_COEFF*(temp-i)));
                        }
			cout << "delay1: " << delay1 << "delay2: " << delay2 << endl;
                        tempCell.setDelayTable(delay1, delay2, IS_DELAY_CAP_NONLIN, AOI222_DELAY_CAP_COEFF, capVector);
tempCell.setMinMaxDelay();
		thirdLibs[temp] = tempCell;
		temp--;
		
                }

                powerVector.clear();

		for(int i  = 0; i < NSIZES; i++)
                        powerVector.push_back(AOI222_LVT_MIN_POWER + (AOI222_LVT_MAX_POWER-AOI222_LVT_MIN_POWER)/pow(AOI222_EP_LENGTH_POWER_COEFF,i));

                for(int i = 0; i < NSIZES; i++ ) {
                        LIB_CELL tempCell(temp,cellName, powerVector[i] ,capVector[NSIZES-i-1]);
			int delay1,delay2;
                        if(OPT_CONTEXT == 6) {
                                delay1 = AOI222_LVT_MAX_FCAP + (int)((temp-i)*(double)(AOI222_LVT_MIN_FCAP - AOI222_LVT_MAX_FCAP)/(temp-1));
                                delay2 = AOI222_LVT_MAX_LCAP + (int)((temp-i)*(double)(AOI222_LVT_MIN_LCAP - AOI222_LVT_MAX_LCAP)/(temp-1));
                        } else {
                                delay1 = AOI222_LVT_MAX_FCAP + (AOI222_LVT_MIN_FCAP - AOI222_LVT_MAX_FCAP)*(1-exp(AOI222_NLD_COEFF*(temp-i)));
                                delay2 = AOI222_LVT_MAX_LCAP + (AOI222_LVT_MIN_LCAP - AOI222_LVT_MAX_LCAP)*(1-exp(AOI222_NLD_COEFF*(temp-i)));
                        }
			cout << "delay1: " << delay1 << "delay2: " << delay2 << endl;
                        tempCell.setDelayTable(delay1, delay2, IS_DELAY_CAP_NONLIN, AOI222_DELAY_CAP_COEFF, capVector);
tempCell.setMinMaxDelay();
		thirdLibs[temp] = tempCell;
                temp--;
                }

	}

}



void printMinGates(unsigned int &minNumGates)
{

if(STAR_FANIN > 6 || STAR_FANIN < 1) {
cout << "\n\nEXITING PROGRAM... SUPPORTED STAR_FANIN RANGE IS 1 to 6" << endl << endl;
exit(1);
}

minNumGates = 0;
int numMeshGates = ((MESH_WIDTH+1)/2)*(MESH_WIDTH+1)/2;

	for(int i =0 ; i < STAR_FANIN ; i++)
		minNumGates += numMeshGates;

	minNumGates += numMeshGates*STAR_FANOUT; // po side chains are only meshes

	cout << "(Min size of the eyechart is:" << minNumGates << ")" << endl;

}

void formEye(EYE_CHART &eyeChart, unsigned int &numGates) {

// no chains are included in the PO chains

	int numMeshGates = ((MESH_WIDTH+1)/2)*(MESH_WIDTH+1)/2; //calculate # gates per mesh
	
	int numMeshes =  numGates*MESH_PERCENTAGE/(100*numMeshGates); // # of MESH_WIDTH stage meshes
	
	//cout << "num meshes :" << numMeshes << endl;

	int numMeshesPerPiChain = (int) (numMeshes*((double)PI_SIDE_MESH_PERCENTAGE/100)/STAR_FANIN);

	//cout << "num meshes per pi chain :" << numMeshesPerPiChain << endl;
	

	if(numMeshesPerPiChain <= 0)
		numMeshesPerPiChain = 1;

	int numMeshesPerPoChain = (int)(numMeshes - (numMeshesPerPiChain*STAR_FANIN))/STAR_FANOUT;

	if(numMeshesPerPoChain <= 0)
                numMeshesPerPoChain = 1;

	int excessMeshes = numMeshes - numMeshesPerPoChain*STAR_FANOUT - numMeshesPerPiChain*STAR_FANIN;
	
	cout << "Excess Meshes: " << excessMeshes << endl;
	for(int i =0; i < STAR_FANIN; i++)
		eyeChart.numPiChainMeshes.push_back(numMeshesPerPiChain);
	
	//if(excessMeshes >= 0)
	//	eyeChart.numPiChainMeshes[0] += excessMeshes; // add all excess meshes to the first PI chain

	int excessMeshCntr = excessMeshes;
	for(int i =0 ; i<STAR_FANIN; i++) {
	
		if(excessMeshCntr > 0) {
			eyeChart.numPiChainMeshes[i] += 1;
			excessMeshCntr--;
			if(i == STAR_FANIN - 1)
				i = 0;
		}
	}
	
	for(int i=0; i<STAR_FANOUT; i++)
		eyeChart.numPoChainMeshes.push_back(numMeshesPerPoChain); 
	
	int numChains =0; int numFinalMeshes = 0;
	
	for(int i=0; i < STAR_FANIN; i++) // for each pi chain
	{
		int localChainCnt = 0;
		eyeChart.piChainInfo.push_back(vector<int>());
		
		int chainCount = INSERT_CHAIN_AFTER+i;	
		for(int j=0; j < eyeChart.numPiChainMeshes[i]; j++) // for each mesh
		{

			numFinalMeshes++;
			chainCount--;
			if(chainCount == 0) {
				eyeChart.piChainInfo[i].push_back(CHAIN_ID); numChains++;
				localChainCnt++;
				chainCount = INSERT_CHAIN_AFTER+i;
			}
			for(int k=1; k <= MESH_WIDTH; k++)
				eyeChart.piChainInfo[i].push_back(k);
		}
		eyeChart.numPiChainChains.push_back(localChainCnt);
	}	

	for(int i=0; i<STAR_FANOUT; i++)
	{
		eyeChart.poChainInfo.push_back(vector<int>());
		for(int j =0; j < eyeChart.numPoChainMeshes[i]; j++) {
			numFinalMeshes++;
			for(int k =1; k <= MESH_WIDTH; k++)
				eyeChart.poChainInfo[i].push_back(k);
		}
	
	}
	//adjust numGates to the new number
        numGates = numMeshes*numMeshGates + numChains + 1; // plus 1 because of center star cell
	

	int piMaxStages = 0, poMaxStages =0;
	for(int i=0; i< eyeChart.piChainInfo.size(); i++)
	{
		eyeChart.numPiStages.push_back(eyeChart.piChainInfo[i].size());
	}
	
	for(int i=0; i< eyeChart.poChainInfo.size(); i++)
	{
	
		eyeChart.numPoStages.push_back(eyeChart.poChainInfo[i].size());
	
	}
	
	if(!eyeChart.numPiStages.empty())
		piMaxStages = maxVector(eyeChart.numPiStages);
	
	if(!eyeChart.numPoStages.empty())
		poMaxStages = maxVector(eyeChart.numPoStages);	
	
	eyeChart.logic_depth = piMaxStages + poMaxStages + 1;
	
	cout << "Generating Eyechart (" << eyeChart.logic_depth  <<  ") with gates: " << numGates << endl;

} //formEye ends


void printEye(const EYE_CHART &eyeChart, fstream &logfile)
{

int temp = 0;
switch(OPT_CONTEXT) {

        case 0:
                temp = NUM_SIZES;
                break; 
        case 1:
                temp = NUM_SIZES;
                break; 
        case 2:
                temp = NUM_VTS;
                break; 
        case 3:
                temp = NUM_VTS;
                break; 
        case 4:
                temp = NUM_GATE_LENGTHS;
                break; 
        case 5:
                temp = NUM_GATE_LENGTHS;
                break;
        case 6:
                temp = NVTS*NSIZES; // lowest size is HVT X1, highest size is LVT XMAX
                break;

        default:
                temp = NUM_SIZES;
}


//logfile << "PI INFO:" << endl;

	for(int i=0; i < STAR_FANIN; i++)
	{
		logfile << "PI" << i+1 << ":";
		for(int j=0; j<eyeChart.piChainInfo[i].size(); j++)
		{
			int id = eyeChart.piChainInfo[i][j];
			int ng = 1;// number of gates for that stage
		
			if(id <= (MESH_WIDTH+1)/2)
				ng = id;
			else
				ng = MESH_WIDTH - id +1;

			if(id == 0 || id == 1 || id == MESH_WIDTH) {
				logfile << id << "-(" << temp << ") ";
			} else {

				logfile << id << "-(";
				for(int j =0; j < ng-1 ; j++) 
					logfile << temp << ",";
				logfile << temp << ") ";

			}

		}
		logfile << endl;
	}

logfile << "STAR:" << STAR_CELL_ID << "-(" << temp << ")" << endl;

//logfile << "PO INFO:" << endl;

	for(int i=0; i<STAR_FANOUT; i++)
	{

		logfile << "PO" << i+1 << ":";
		for(int j=0; j<eyeChart.poChainInfo[i].size(); j++) {

			int id = eyeChart.poChainInfo[i][j];
                        int ng = 1;// number of gates for that stage

                        if(id <= (MESH_WIDTH+1)/2)
                                ng = id;
                        else
                                ng = MESH_WIDTH - id +1;

                        if(id == 0 || id == 1 || id == MESH_WIDTH) {
                                logfile << id << "-(" << temp << ") ";
                        } else {

                                logfile << id << "-(";
                                for(int j =0; j < ng-1 ; j++)
                                        logfile << temp << ",";
				logfile << temp << ") ";
                        }
		}
		logfile << endl;

	}


}


//************************************************** Class functions ********************************

LIB_CELL::LIB_CELL(short int s, string f,float l,short int c)
{
	size = s;
	function = f;
	leakage = l;
	cap = c;
}


LIB_CELL::~LIB_CELL()
{
}

void LIB_CELL::setDelayTable(short int init_delay, short int finalDelay, bool isExp, float jumpCoeff, vector<short int> caps) // artificially generates linear delay table
{


	for(int i=0; i< caps.size(); i++) {
		//delay_table[caps[i]] = init_delay + i*jump;

		//if(isExp)
			delay_table[caps[i]] = init_delay + (short int)(finalDelay-init_delay)*(1-exp(jumpCoeff*i));
		//else 
			//delay_table[caps[i]] = init_delay + (short int)(finalDelay-init_delay)*(1-exp(jumpCoeff*i));
			//delay_table[caps[i]] = init_delay + (short int)((finalDelay-init_delay)/(caps.size()-1))*i;

	}
}


void LIB_CELL::printLibCell(fstream &logfile)
{
	logfile << endl;
	logfile << "CELL:" << function << "\tX:" << size << "\tCAP:" << (float)cap/1000 << "\tLEAKAGE_POWER:" <<leakage <<"\tMIN_DELAY:" << (float)min_delay/1000 << "\tMAX_DELAY:" << (float)max_delay/1000 << "\n" <<endl;
	
	map<short int, short int>::const_iterator iter;
	logfile << "CAP: " ;
	for(iter = delay_table.begin(); iter != delay_table.end(); iter++)
	{
	logfile << (float)iter->first/1000 << " "; // divide by thousand to convert to pico farad, because cap values are in femto
	}
	logfile << endl;
	logfile << "DELAY: " ;
	for(iter = delay_table.begin(); iter != delay_table.end(); iter++)
        {
        logfile << (float)iter->second/1000 << " ";// divide by thousand to convert to nano second, because delay values are in pico
        }
	logfile << endl;

}

void LIB_CELL::setMinMaxDelay() // Use immediately after filling up the delay tables
{
	map<short int,short int>::const_iterator iter;
	short int mindelay ,maxdelay;

	iter = delay_table.begin();
	mindelay = iter->second;maxdelay = iter->second;

	// this operation of find out min delay is not usually necessary since delay
	// w.r.t cap is monotonically increasing
	while(iter != delay_table.end())
	{
		if(iter->second > maxdelay)
			maxdelay = iter->second;

		if(iter->second < mindelay)
			mindelay = iter->second;	
		iter++;
	
	}

	min_delay = mindelay; 
	max_delay = maxdelay;
}

short int LIB_CELL::getInputCap()
{
return cap;
}

short int LIB_CELL::get_size()
{
return size;
}

float LIB_CELL::getLeakage()
{
return leakage;
}


short int LIB_CELL::getDelay(int cap)
{
return delay_table[cap];
}

short int LIB_CELL::getMinDelay()
{
return min_delay;
}

short int LIB_CELL::getMaxDelay()
{
return max_delay;
}






STATE_TABLE::STATE_TABLE()
{
}

STATE_TABLE::~STATE_TABLE()
{
}

void STATE_TABLE::addState(unsigned int s, short int delay, short int size, float leakage)
{

STATE_TRIPLET y;
y.set_triplet(delay,size,leakage);
st[s] = y;

}

void STATE_TABLE::printst(fstream &logfile)
{

logfile << endl;
map<unsigned int,STATE_TRIPLET>::const_iterator iter;
for(iter = st.begin(); iter != st.end(); iter++)
logfile << iter->first << "\t" << iter->second.delay_cost << "\t" << iter->second.size <<"\t" << iter->second.leakage << endl;

}

void STATE_TABLE::clear()
{
this->st.clear();

}

unsigned int STATE_TABLE::minState()
{

map<unsigned int,STATE_TRIPLET>::const_iterator iter;

iter = this->st.begin();
return iter->first;
}

unsigned int STATE_TABLE::maxState()
{ 

map<unsigned int,STATE_TRIPLET>::reverse_iterator iter;
iter = this->st.rbegin();
return iter->first;
}


STATE_TRIPLET STATE_TABLE::getTriplet(unsigned int state, bool over_range)
{
if(!over_range)
return st[state];
else
return st[this->maxState()];

}

short int STATE_TABLE::getDelayCost(unsigned int state, bool over_range)
{
STATE_TRIPLET temp;

if(!over_range)
temp = st[state];
else
temp = st[this->maxState()];

return temp.delay_cost;
}

short int STATE_TABLE::getSize(unsigned int state, bool over_range)
{
STATE_TRIPLET temp;

if(!over_range)
temp = st[state];
else
temp = st[this->maxState()];

return temp.size;
}

float STATE_TABLE::getLeakage(unsigned int state, bool over_range)
{
STATE_TRIPLET temp;

if(!over_range)
temp = st[state];
else
temp = st[this->maxState()];

return temp.leakage;
}




bool STATE_TABLE::isStateAvailable(unsigned int state, bool &over_range) // to check if there is an entry corresponding to the state
{

	if(state >= this->minState()) {

		if(state <= this->maxState())
			over_range = false;
		else
			over_range = true;

	return true; 

	} else {
		return false;

	}

}


