// This file contains the parameters used for eyechart generation
#define PRINT_LOG_INFO 1 // adds log information
#define PRINT_STATE_TABLE_INFO 0// by default prints out state tables to state_table.info
#define PRINT_STATE_NOT_INFO 0// by default prints out states skipped due to acco problems

#define BATCH_MODE 1 // simultaneously solves for multiple dmax constraints - huge runtime benefits

#define DEPTH1 10 // before star 
#define DEPTH2 10 // after star

#define OPT_CONTEXT 1

// 0 - LP-LD, 1 - LP-NLD, 2 - EP-LD, 3 - EP_NLD, 4-EP-LD gateLength, 5 - EP-NLD gatelength
//6 - JOINT Vt, size opt

// LP_LD< LP_NLD, EP-LD, EP-NLD
#define NUM_SIZES 8
#define NUM_VTS 3
#define NUM_GATE_LENGTHS 3

//Joint context
#define NVTS 3
#define NSIZES 3


#define INIT_CAP  10
#define JUMP_CAP 2

#define IS_DELAY_CAP_NONLIN true // delay vs cap is linear  true - nonlinear, currently only controls joint vt case, rest of the cases are hard coded

// All powers in pW, all delays in ps
#define INV_EP_POWER_COEFF 6.5 
#define INV_EP_LENGTH_POWER_COEFF 6.5
#define INV_NLD_COEFF_LP -0.4
#define INV_NLD_COEFF_EP -0.9
#define INV_NLD_COEFF_GEP -0.95 // gate length
#define INV_NLD_COEFF -0.9 // gate length
#define INV_DELAY_CAP_COEFF_LP_LD -0.025
#define INV_DELAY_CAP_COEFF_LP_NLD -0.05
#define INV_DELAY_CAP_COEFF_EP_LD -0.25
#define INV_DELAY_CAP_COEFF_EP_NLD -0.25
#define INV_DELAY_CAP_COEFF_GEP_LD -0.25
#define INV_DELAY_CAP_COEFF_GEP_NLD -0.25
#define INV_DELAY_CAP_COEFF -0.25

#define INV_TVT_MAX_FCAP 2 //10
#define INV_TVT_MAX_LCAP 10 // 60
#define INV_TVT_MIN_FCAP 20// 120
#define INV_TVT_MIN_LCAP 30// 250
#define INV_TVT_MAX_POWER 600
#define INV_TVT_MIN_POWER 60

#define INV_HVT_MAX_FCAP 4
#define INV_HVT_MAX_LCAP 85
#define INV_HVT_MIN_FCAP 12 
#define INV_HVT_MIN_LCAP 75
#define INV_HVT_MAX_POWER 75
#define INV_HVT_MIN_POWER 10

#define INV_LVT_MAX_FCAP 1
#define INV_LVT_MAX_LCAP 32
#define INV_LVT_MIN_FCAP 6
#define INV_LVT_MIN_LCAP 58
#define INV_LVT_MAX_POWER 3300
#define INV_LVT_MIN_POWER 300


#define NAND_EP_POWER_COEFF 6.1
#define NAND_EP_LENGTH_POWER_COEFF 6.1
#define NAND_NLD_COEFF_LP -0.35
#define NAND_NLD_COEFF_EP -1.0
#define NAND_NLD_COEFF_GEP -0.95
#define NAND_NLD_COEFF -0.85
#define NAND_DELAY_CAP_COEFF_LP_LD -0.025
#define NAND_DELAY_CAP_COEFF_LP_NLD -0.05
#define NAND_DELAY_CAP_COEFF_EP_LD -0.25
#define NAND_DELAY_CAP_COEFF_EP_NLD -0.25
#define NAND_DELAY_CAP_COEFF_GEP_LD -0.25
#define NAND_DELAY_CAP_COEFF_GEP_NLD -0.2
#define NAND_DELAY_CAP_COEFF -0.25

#define NAND_TVT_MAX_FCAP 4//15
#define NAND_TVT_MAX_LCAP 14//75
#define NAND_TVT_MIN_FCAP 25 //140 
#define NAND_TVT_MIN_LCAP 40 //280
#define NAND_TVT_MAX_POWER 800
#define NAND_TVT_MIN_POWER 70

#define NAND_HVT_MAX_FCAP 5
#define NAND_HVT_MAX_LCAP 65
#define NAND_HVT_MIN_FCAP 14
#define NAND_HVT_MIN_LCAP 82
#define NAND_HVT_MAX_POWER 100
#define NAND_HVT_MIN_POWER 15

#define NAND_LVT_MAX_FCAP 2
#define NAND_LVT_MAX_LCAP 42
#define NAND_LVT_MIN_FCAP 6
#define NAND_LVT_MIN_LCAP 64
#define NAND_LVT_MAX_POWER 4800
#define NAND_LVT_MIN_POWER 300


#define AOI222_EP_POWER_COEFF 6.9
#define AOI222_EP_LENGTH_POWER_COEFF 6.9
#define AOI222_NLD_COEFF_LP -0.42
#define AOI222_NLD_COEFF_EP -1.2
#define AOI222_NLD_COEFF_GEP -1.15
#define AOI222_NLD_COEFF -1.02
#define AOI222_DELAY_CAP_COEFF_LP_LD -0.025
#define AOI222_DELAY_CAP_COEFF_LP_NLD -0.05
#define AOI222_DELAY_CAP_COEFF_EP_LD -0.25
#define AOI222_DELAY_CAP_COEFF_EP_NLD -0.25
#define AOI222_DELAY_CAP_COEFF_GEP_LD -0.25
#define AOI222_DELAY_CAP_COEFF_GEP_NLD -0.2
#define AOI222_DELAY_CAP_COEFF -0.25

#define AOI222_TVT_MAX_FCAP 6 //20
#define AOI222_TVT_MAX_LCAP 18 //80
#define AOI222_TVT_MIN_FCAP 30//160
#define AOI222_TVT_MIN_LCAP 50 //
#define AOI222_TVT_MAX_POWER 1500
#define AOI222_TVT_MIN_POWER 175

#define AOI222_HVT_MAX_FCAP 12
#define AOI222_HVT_MAX_LCAP 84
#define AOI222_HVT_MIN_FCAP 18 
#define AOI222_HVT_MIN_LCAP 98
#define AOI222_HVT_MAX_POWER 170
#define AOI222_HVT_MIN_POWER 30

#define AOI222_LVT_MAX_FCAP 6
#define AOI222_LVT_MAX_LCAP 59
#define AOI222_LVT_MIN_FCAP 12
#define AOI222_LVT_MIN_LCAP 72
#define AOI222_LVT_MAX_POWER 8400
#define AOI222_LVT_MIN_POWER 950


#define INIT_LEAKAGE_INV 100
#define INIT_LEAKAGE_NAND 150
#define INIT_LEAKAGE_THIRD 500
#define JUMP_LEAKAGE 100
//#define INIT_DELAY_INV  10
//#define INIT_DELAY_NAND  14
//#define INIT_DELAY_THIRD  30
//
//#define JUMP_DELAY 2

#define MESH_WIDTH 5 // 5 stage mesh

#define STAR_FANIN 6 // fan in of the star node 

#define STAR_FANOUT 10 // fan out of the star node, **** Also determines the max fanout in the circuit

#define IS_PO_CHAIN_SYMMETRIC 1 // defalt PO side chains are symmetric

#define LOAD_CAP 10 // used for all loads

#define CHAIN_ID 0 // MESH stage ids are 1 throgh n for a n-stage mesh
#define STAR_CELL_ID 99 //used to detect if a cell is star cell 


#define PI_SIDE_MESH_PERCENTAGE 25 

#define INSERT_CHAIN_AFTER 30 // inserts a chain after 10 meshes in the PI side

#define MESH_PERCENTAGE 90 // of the total # of gates, the percentage of gates used by meshes


