/******************************************************************************
* uclaShape.cpp
* Developed by: XinHeng Huang email: huangxinheng@gmail.com
* Supervised by: Prof. Puneet Gupta
* Affiliation: University of California, Los Angeles, Department of Electrical
* Engineering
*
* Copyright (c) 2011.
*
******************************************************************************/
#include "uclaShape.h"

static void printShape(oaShape  *shape)
{
    oaType  type = shape->getType();
    oaBox   box;
    shape->getBBox(box);
    cout << "\t \t" << type.getName() << endl << "\t \t \t ("
         << box.left() << ", " << box.bottom() << "), (" << box.right() << ", "
         << box.top() << ")" << endl;

    return;
}

void uclaShape::addPolygonData(LayoutSet &sets,int* points,unsigned int size){
	polygon_data<int> poly_data;
	vector<point_data<int> > poly_points(size);
	for(unsigned int i=0;i<size;i++)
	{
		int x=i*2;
                int y=x+1;	     
		poly_points[i]=point_data<int>(points[x],points[y]);
		//cout<<endl;
		//cout<<"Loading.."<<points[x]<<","<<points[y]<<endl;
	}
	poly_data.set(poly_points.begin(),poly_points.end());
	
	sets.push_back(poly_data);
}

oaPointArray uclaShape::getPolygonData(polygon_data<int> group){
	    vector<point_data<int> > pts;
	    pts.insert(pts.begin(),group.begin(),group.end());
	    // -1 last one is duplicated
	    oaPoint oa_p[group.size()-1];
	    // generating oaPoint
	    for(size_t i=0;i<group.size()-1;i++){
         	    oaPoint buffer(pts[i].x(),pts[i].y());
         	    oa_p[i]=buffer;
   	     }
    	oaPointArray p_arr(oa_p,group.size()-1);	
    	return p_arr;
}
void uclaShape::load_shape(oaShape* shape,LayoutSet &group_1){		      
		       if(shape->getType()==oacPolygonType){
				oaPointArray points;
				oaPolygon* polygons=(oaPolygon*)shape;
				polygons->getPoints(points);
				size_t size=points.getNumElements()*2;
				int data[size];
				size_t index=size-1; 		                                
                       		for(size_t i=0;i<points.getNumElements();i++){
                                      // clockwise
                                      data[index--]=points[i].y();
				      data[index--]=points[i].x();
				}
				addPolygonData(group_1,data,(size/2));
		       }
		       else if(shape->getType()==oacRectType){
			        int data[8];
				oaBox box;
        			shape->getBBox(box);
			
				data[0]=box.left();
				data[1]=box.bottom();
				data[2]=box.left();
				data[3]=box.top();
				data[4]=box.right();
				data[5]=box.top();
				data[6]=box.right();
				data[7]=box.bottom();
				addPolygonData(group_1,data,4);
		       }			       
}

void uclaShape::getResult(vector<oaPointArray> &result,LayoutSet &group_2){ 

		if(group_2.size()>0){
			for(size_t i=0;i<group_2.size();i++){
				oaPointArray p_buffer;
    				p_buffer=getPolygonData(group_2[i]);
/*print out coordinate
    				cout<<endl<<"Result size"<<p_buffer.getNumElements()<<endl;
				for(size_t i=0;i<p_buffer.getNumElements();i++)
                                	cout<<p_buffer[i].x()<<","<<p_buffer[i].y()<<endl;
*/		
				result.push_back(p_buffer);
			}
		}
}

void uclaShape::clear(oaLPPHeader* lppHeader){
	if(lppHeader){
		oaIter<oaShape> shapes(lppHeader->getShapes());
        	oaShape* m_shape;
        	while(m_shape=shapes.getNext())
                	m_shape->destroy();
	}
}
void uclaShape::clear(oaBlock* block,oaLayerNum layerNum,oaPurposeNum purposeNum){
	oaLPPHeader* lppHeader=oaLPPHeader::find(block,layerNum,purposeNum);
	if(lppHeader){
		oaIter<oaShape> shapes(lppHeader->getShapes());
        	oaShape* m_shape;
        	while(m_shape=shapes.getNext())
                	m_shape->destroy();
	}

}
oaBoolean uclaShape::logic_operation(oaBlock* block,oaLPPHeader *lppHeader1, oaLPPHeader *lppHeader2,oaLPPHeader *lppHeader3,oaLayerOp op,int flag){
	
	if(!lppHeader1 || !lppHeader2 || !lppHeader3)
		return false;
	oaLayerNum layerNum=lppHeader3->getLayerNum();
	oaPurposeNum purposeNum=lppHeader3->getPurposeNum();
	LayoutSet res;
	LayoutSet res1;
	vector <oaPointArray> result;
       if (!lppHeader1->getShapes().isEmpty() && !lppHeader2->getShapes().isEmpty()){ 
                oaShape* m_shape;
		oaIter<oaShape> shapes1(lppHeader1->getShapes());
  		oaIter<oaShape> shapes2(lppHeader2->getShapes());
		while(m_shape=shapes2.getNext())
			load_shape(m_shape,res);
		 while(m_shape=shapes1.getNext())
			load_shape(m_shape,res1);	
	
        }
	if(op==oacAndLayerOp)
		res1&=res;
	if(op==oacOrLayerOp)
		res1|=res;
	if(op==oacXorLayerOp)
		res1^=res;
	if(op==oacNotLayerOp)
                res1^=(res&res1);

	getResult(result,res1);

	if(flag){
		clear(lppHeader3);
		cout<<"Warning:overwriting the existing layer!"<<endl;
	}

	if(result.size()!=0)
		for(unsigned int i=0;i<result.size();i++){
			
			oaPolygon::create(block,layerNum,purposeNum,result[i]);
			
		}
	return true;
}

oaBoolean uclaShape::logic_operation(oaBlock* block,oaLPPHeader *lppHeader1, oaLPPHeader *lppHeader2,oaLayerNum layerNum,oaPurposeNum purposeNum,oaLayerOp op,int flag){

	oaLPPHeader* lppHeader=oaLPPHeader::find(block,layerNum,purposeNum);
        if(!lppHeader1 || !lppHeader2)
		return false;

	LayoutSet res;
        LayoutSet res1;
        vector <oaPointArray> result;
       if (!lppHeader1->getShapes().isEmpty() && !lppHeader2->getShapes().isEmpty()){
                oaShape* m_shape;
                oaIter<oaShape> shapes1(lppHeader1->getShapes());
                oaIter<oaShape> shapes2(lppHeader2->getShapes());
                while(m_shape=shapes2.getNext())
                        load_shape(m_shape,res);
                 while(m_shape=shapes1.getNext())
                        load_shape(m_shape,res1);
        }
        if(op==oacAndLayerOp)
                res1&=res;
        if(op==oacOrLayerOp)
                res1|=res;
        if(op==oacXorLayerOp)
                res1^=res;
	if(op==oacNotLayerOp)
		res1^=(res&res1);
        //cout<<"Result SIZE "<<res1.size()<<endl;
        getResult(result,res1);

	if(lppHeader && flag){
		clear(lppHeader);
		cout<<"Warning:overwriting the existing layer!"<<endl;
	}


        if(result.size()!=0)
                for(unsigned int i=0;i<result.size();i++){
                       oaPolygon::create(block,layerNum,purposeNum,result[i]);

                }
	return true;
}

oaBoolean uclaShape::equivalence(oaLPPHeader *lppHeader1, oaLPPHeader *lppHeader2){
 	if(!lppHeader1 || !lppHeader2)
		return false;
	LayoutSet res;
        LayoutSet res1;
        vector <oaPointArray> result;
	
	if(lppHeader1->getShapes().isEmpty()&&lppHeader2->getShapes().isEmpty())
		return true;

       if (!lppHeader1->getShapes().isEmpty() && !lppHeader2->getShapes().isEmpty()){ 
                oaShape* m_shape;
		oaIter<oaShape> shapes1(lppHeader1->getShapes());
  		oaIter<oaShape> shapes2(lppHeader2->getShapes());
		while(m_shape=shapes2.getNext())
			load_shape(m_shape,res);
		while(m_shape=shapes1.getNext())
			load_shape(m_shape,res1);	
		
	  }
	return equivalence(res,res1);

}
oaBoolean uclaShape::equivalence(oaBlock* block1,oaLayerNum layerNum1,oaPurposeNum purposeNum1,oaBlock* block2,oaLayerNum layerNum2,oaPurposeNum purposeNum2){
 	
	oaLPPHeader* lppHeader1=oaLPPHeader::find(block1,layerNum1,purposeNum1);
	oaLPPHeader* lppHeader2=oaLPPHeader::find(block2,layerNum2,purposeNum2);
	if(!lppHeader1 || !lppHeader2)
                return false;

	LayoutSet res;
        LayoutSet res1;
        vector <oaPointArray> result;
	
	if(lppHeader1->getShapes().isEmpty()&&lppHeader2->getShapes().isEmpty())
		return true;

       if (!lppHeader1->getShapes().isEmpty() && !lppHeader2->getShapes().isEmpty()){ 
                oaShape* m_shape;
		oaIter<oaShape> shapes1(lppHeader1->getShapes());
  		oaIter<oaShape> shapes2(lppHeader2->getShapes());
		while(m_shape=shapes2.getNext())
			load_shape(m_shape,res);
		while(m_shape=shapes1.getNext())
			load_shape(m_shape,res1);	
		
	  }
	return equivalence(res,res1);

}oaBoolean uclaShape::empty(oaLPPHeader *lppHeader){
	if(!lppHeader)
		return true;
	if(lppHeader->getShapes().isEmpty())
		return true;
	return false;
}
oaBoolean uclaShape::empty(oaBlock* block,oaLayerNum layerNum,oaPurposeNum purposeNum){
	oaLPPHeader* lppHeader=oaLPPHeader::find(block,layerNum,purposeNum);
	if(!lppHeader)
		return true;
	if(lppHeader->getShapes().isEmpty())
		return true;
	return false;
}
oaDouble uclaShape::area(oaLPPHeader *lppHeader){
	LayoutSet res;
	if(lppHeader){
		if(!lppHeader->getShapes().isEmpty()){
			oaShape* m_shape;
		oaIter<oaShape> shapes(lppHeader->getShapes());
		while(m_shape=shapes.getNext())
			load_shape(m_shape,res);
		}
		return area(res);
	}
	return -1;
}
oaDouble uclaShape::area(oaBlock* block,oaLayerNum layerNum, oaPurposeNum purposeNum){
	oaLPPHeader* lppHeader=oaLPPHeader::find(block,layerNum,purposeNum);
	LayoutSet res;
	if(lppHeader){
		if(!lppHeader->getShapes().isEmpty()){
			oaShape* m_shape;
		oaIter<oaShape> shapes(lppHeader->getShapes());
		while(m_shape=shapes.getNext())
			load_shape(m_shape,res);
		}
		return area(res);
	}
	return -1;
}
oaBoolean uclaShape::bloat(oaBlock* block,oaLPPHeader* lppHeader,oaLayerNum layerNum,oaPurposeNum purposeNum,int num,int flag){

	oaLPPHeader* old_lppHeader=oaLPPHeader::find(block,layerNum,purposeNum);
	if(!lppHeader)
		return false;

	LayoutSet res;
        vector <oaPointArray> result;

	if(!lppHeader->getShapes().isEmpty()){
		oaShape* m_shape;
		oaIter<oaShape> shapes(lppHeader->getShapes());
		while(m_shape=shapes.getNext())
			load_shape(m_shape,res);
		bloat(res,num);	
	}
	 getResult(result,res);

	if(old_lppHeader && flag){
		clear(old_lppHeader);
		cout<<"Warning:overwriting the existing layer!"<<endl;
	}

        if(result.size()!=0)
                for(unsigned int i=0;i<result.size();i++){
                        oaPolygon::create(block,layerNum,purposeNum,result[i]);

                }
	return true;
}
oaBoolean uclaShape::bloat(oaBlock* block,oaLPPHeader* lppHeader,int num,int flag){
	if(!lppHeader)
		return false;
	oaLayerNum layerNum= lppHeader->getLayerNum();
	oaPurposeNum purposeNum=lppHeader->getPurposeNum();
	LayoutSet res;
        vector <oaPointArray> result;

	if(!lppHeader->getShapes().isEmpty()){
		oaShape* m_shape;
		oaIter<oaShape> shapes(lppHeader->getShapes());
		while(m_shape=shapes.getNext())
			load_shape(m_shape,res);
		bloat(res,num);	
	}
	 getResult(result,res);

	if(flag){
		clear(lppHeader);
		cout<<"Warning:overwriting the existing layer!"<<endl;
	}

        if(result.size()!=0)
                for(unsigned int i=0;i<result.size();i++){
                        oaPolygon::create(block,layerNum,purposeNum,result[i]);

                }
	return true;
}
oaBoolean uclaShape::shrink(oaBlock* block,oaLPPHeader* lppHeader,int num,int flag){

	if(!lppHeader)
		return false;
	oaLayerNum layerNum= lppHeader->getLayerNum();
	oaPurposeNum purposeNum=lppHeader->getPurposeNum();

	LayoutSet res;
        vector <oaPointArray> result;

        if(!lppHeader->getShapes().isEmpty()){
                oaShape* m_shape;
                oaIter<oaShape> shapes(lppHeader->getShapes());
                while(m_shape=shapes.getNext())
                        load_shape(m_shape,res);
                shrink(res,num);   
        }
        getResult(result,res);
	
	if(flag){
		clear(lppHeader);
		cout<<"Warning:overwriting the existing layer!"<<endl;
	}

        if(result.size()!=0)
                for(unsigned int i=0;i<result.size();i++){
                      oaPolygon::create(block,layerNum,purposeNum,result[i]);

                }
	return true;
}
oaBoolean uclaShape::shrink(oaBlock* block,oaLPPHeader* lppHeader,oaLayerNum layerNum,oaPurposeNum purposeNum,int num,int flag){
	
	oaLPPHeader* old_lppHeader=oaLPPHeader::find(block,layerNum,purposeNum);
	if(!lppHeader)
		return false;

	LayoutSet res;
        vector <oaPointArray> result;

        if(!lppHeader->getShapes().isEmpty()){
                oaShape* m_shape;
                oaIter<oaShape> shapes(lppHeader->getShapes());
                while(m_shape=shapes.getNext())
                        load_shape(m_shape,res);
                shrink(res,num);   
        }
         getResult(result,res);

	if(old_lppHeader && flag){
		clear(old_lppHeader);
		cout<<"Warning:overwriting the existing layer!"<<endl;
	}


        if(result.size()!=0)
                for(unsigned int i=0;i<result.size();i++){
                      oaPolygon::create(block,layerNum,purposeNum,result[i]);

                }
	return true;
}
oaBoolean uclaShape::scale_up(oaBlock* block,oaLPPHeader* lppHeader,int num,int flag){
	if(!lppHeader)
		return false;
	oaLayerNum layerNum= lppHeader->getLayerNum();
	oaPurposeNum purposeNum=lppHeader->getPurposeNum();


	LayoutSet res;
        vector <oaPointArray> result;

        if(!lppHeader->getShapes().isEmpty()){
                oaShape* m_shape;
                oaIter<oaShape> shapes(lppHeader->getShapes());
                while(m_shape=shapes.getNext())
                        load_shape(m_shape,res);
                scale_up(res,num);
        }
         getResult(result,res);

	if(flag){
		clear(lppHeader);
		cout<<"Warning:overwriting the existing layer!"<<endl;
	}

        if(result.size()!=0)
                for(unsigned int i=0;i<result.size();i++){       
                         oaPolygon::create(block,layerNum,purposeNum,result[i]);

                }
	return true;
}
oaBoolean uclaShape::scale_up(oaBlock* block,oaLPPHeader* lppHeader,oaLayerNum layerNum,oaPurposeNum purposeNum,int num,int flag){

	oaLPPHeader* old_lppHeader=oaLPPHeader::find(block,layerNum,purposeNum);

	if(!lppHeader)
		return false;

	LayoutSet res;
        vector <oaPointArray> result;

        if(!lppHeader->getShapes().isEmpty()){
                oaShape* m_shape;
                oaIter<oaShape> shapes(lppHeader->getShapes());
                while(m_shape=shapes.getNext())
                        load_shape(m_shape,res);
                scale_up(res,num);   
        }
         getResult(result,res);

	if(old_lppHeader && flag){
		clear(old_lppHeader);
		cout<<"Warning:overwriting the existing layer!"<<endl;
	}

        if(result.size()!=0)
                for(unsigned int i=0;i<result.size();i++){
                      oaPolygon::create(block,layerNum,purposeNum,result[i]);

                }
	return true;
}
oaBoolean uclaShape::scale_down(oaBlock* block,oaLPPHeader* lppHeader,int num,int flag){
      	if(!lppHeader)
		return false;
	oaLayerNum layerNum=lppHeader->getLayerNum();
	oaPurposeNum purposeNum=lppHeader->getPurposeNum();

	LayoutSet res;
        vector <oaPointArray> result;

        if(!lppHeader->getShapes().isEmpty()){
                oaShape* m_shape;
                oaIter<oaShape> shapes(lppHeader->getShapes());
                while(m_shape=shapes.getNext())
                        load_shape(m_shape,res);
                scale_down(res,num);
        }
         getResult(result,res);

	if(flag){
		clear(lppHeader);
		cout<<"Warning:overwriting the existing layer!"<<endl;
	}

        if(result.size()!=0)
                for(unsigned int i=0;i<result.size();i++){
                        oaPolygon::create(block,layerNum,purposeNum,result[i]);

                }
	return true;
}
oaBoolean uclaShape::scale_down(oaBlock* block,oaLPPHeader* lppHeader,oaLayerNum layerNum,oaPurposeNum purposeNum,int num,int flag){


	oaLPPHeader* old_lppHeader=oaLPPHeader::find(block,layerNum,purposeNum);
	if(!lppHeader)
		return false;

	LayoutSet res;
        vector <oaPointArray> result;

        if(!lppHeader->getShapes().isEmpty()){
                oaShape* m_shape;
                oaIter<oaShape> shapes(lppHeader->getShapes());
                while(m_shape=shapes.getNext())
                        load_shape(m_shape,res);
                scale_down(res,num);   
        }
         getResult(result,res);

	if(old_lppHeader && flag){
		clear(old_lppHeader);
		cout<<"Warning:overwriting the existing layer!"<<endl;
	}

        if(result.size()!=0)
                for(unsigned int i=0;i<result.size();i++){
                      oaPolygon::create(block,layerNum,purposeNum,result[i]);

                }
	return true;
}
oaBoolean uclaShape::keep(oaBlock* block,oaLPPHeader* lppHeader,oaUInt4 min_area,oaUInt4 max_area,oaUInt4 min_width,oaUInt4 max_width,oaUInt4 min_height,oaUInt4 max_height){
      	if(!lppHeader)
		return false;
	oaLayerNum layerNum=lppHeader->getLayerNum();
	oaPurposeNum purposeNum=lppHeader->getPurposeNum();

	LayoutSet res;
        vector <oaPointArray> result;

        if(!lppHeader->getShapes().isEmpty()){
                oaShape* m_shape;
                oaIter<oaShape> shapes(lppHeader->getShapes());
                while(m_shape=shapes.getNext())
                        load_shape(m_shape,res);
                keep(res,min_area,max_area,min_width,max_width,min_height,max_height);
        }
         getResult(result,res);

	clear(lppHeader);
	cout<<"Warning:overwriting the existing layer!"<<endl;
	
        if(result.size()!=0)
                for(unsigned int i=0;i<result.size();i++){
                        oaPolygon::create(block,layerNum,purposeNum,result[i]);

                }
	return true;
}

