// *****************************************************************************
// *****************************************************************************
#include <iostream>
#include <cassert>
#include "uclaShape.h"
#include <list>
#include <time.h>
#include <deque>
#include <iostream>
using namespace oa;
using namespace std;



//************************************************
// *****************************************************************************
// printShape()
//
// This function prints the type of shape and its bounding box.
// *****************************************************************************
static void
printShape(oaShape  *shape)
{
    oaType  type = shape->getType();
    oaBox   box;
    shape->getBBox(box);
    cout << "\t \t" << type.getName() << endl << "\t \t \t (" 
	 << box.left() << ", " << box.bottom() << "), (" << box.right() << ", "
	 << box.top() << ")" << endl;

    return;
}
// *****************************************************************************
// printTCObjectName()
//
// This function prints the name of the 'object' if it is layer or purpose.
// *****************************************************************************
static void
printTCObjectName(oaTechObject	*object)
{
    oaType	type = object->getType();
    oaString	tcObjectName;

    if (type == oacPhysicalLayerType || type == oacDerivedLayerType) {
	((oaLayer *)object)->getName(tcObjectName);
    } else if (type == oacPurposeType) {
	((oaPurpose *)object)->getName(tcObjectName);
    }

    cout << "\t" << type.getName() << " = " << tcObjectName << endl;

    return;
}

// ****************************************************************************
// main()
//
// This top level function opens a Design specified by the input library, cell 
// and view names, prints all layer and purpose names used in that Design and
// for all shapes on each layer purpose pair, prints its type and bounding box
// *****************************************************************************
int
main(int    argc, 
     char   *argv[])
{
     //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

 //once again we make our usage of the library generic
    oaDesignInit();
    oaRegionQuery::init("oaRQSystem");
    oaDesign* view;

    if (argc != 4) {
	cout << "Invalid number of input arguments. Specify library name, " 
	     << "cellName, and viewName in the same order\n";
	exit (1);
    }
	
    try {
	oaNativeNS	ns;           // reads in design
	oaScalarName	libName(ns, argv[1]);
	oaScalarName	cellName(ns, argv[2]);
	oaScalarName	viewName(ns, argv[3]);
	oaString	libraryPath(argv[1]);

	if (oaLib::exists(libraryPath)) {       // see if design exists
	   if (!oaLib::find(libName)) {
		oaLib::open(libName, libraryPath);
	    }
	} else {
	    cout << "Library " << libraryPath << "is not present." << endl;
	}
                         // end of reading in design
	view = oaDesign::open(libName, cellName, viewName, 'a');
	oaTech	    *techFile = view->getTech();
// *view is the design......
	// Iterate over all the layer purpose pairs used by 'view'
 
	oaIter<oaLPPHeader> headers(view->getTopBlock()->getLPPHeaders());
	

	oaLPPHeader *lppHeader1 = headers.getNext(); 
	oaLPPHeader *lppHeader2 = headers.getNext();

//Testing only	    
//	oaLPPHeader *lppHeader3 = headers.getNext();
//	oaIter<oaShape> shapes3(lppHeader3->getShapes());
//	printShape(shapes3.getNext());

	    oaLayerNum layerNum1 = lppHeader1->getLayerNum();
	    oaPurposeNum purpNum1 = lppHeader1->getPurposeNum();

	    oaLayerNum layerNum2 = lppHeader2->getLayerNum();
            oaPurposeNum purpNum2 = lppHeader2->getPurposeNum();

            
	    oaLayer	    *layer1   = NULL;
	    oaPurpose	    *purpose1 = NULL;
	    oaLayer  	    *layer2   = NULL;
	    oaPurpose       *purpose2 = NULL;

	    if (techFile) {
		layer1 = oaLayer::find(techFile, layerNum1);
		purpose1 = oaPurpose::find(techFile, purpNum1);
		
		layer2 = oaLayer::find(techFile, layerNum2);
                purpose2 = oaPurpose::find(techFile, purpNum2);
	    }

	    if (layer1) {
		printTCObjectName(layer1);
	    } else {
		cout << "\t Layer   = " << layerNum1 << endl;
	    }

	    if (layer2) {
                printTCObjectName(layer2);
            } else {
                cout << "\t Layer   = " << layerNum2 << endl;
            }


	    if (purpose1) {
		printTCObjectName(purpose1);	
	    } else {
		cout << "\t Purpose = " << purpNum1 << endl;
	    }

	    if (purpose2) {
                printTCObjectName(purpose2);
            } else {
                cout << "\t Purpose = " << purpNum2 << endl;
            }

           
	//TESTING
	oaLayerOp op=oacAndLayerOp;

//	uclaShape::logic_operation(view->getTopBlock(),lppHeader1,lppHeader2,5,0,op,1);

	uclaShape::logic_operation(view->getTopBlock(),lppHeader1,lppHeader2,lppHeader1,op,1);	
//	logic_operation(view->getTopBlock(),lppHeader1,lppHeader2,lppHeader1,op);

        cout<<"Area1= "<<uclaShape::area(lppHeader1)<<endl;
	assert(uclaShape::area(lppHeader1)==uclaShape::area(view->getTopBlock(),lppHeader1->getLayerNum(),lppHeader1->getPurposeNum()));
	cout<<"Area2= "<<uclaShape::area(lppHeader2)<<endl;
	
	assert(uclaShape::area(lppHeader2)==uclaShape::area(view->getTopBlock(),lppHeader2->getLayerNum(),lppHeader2->getPurposeNum()));
//      logic_operation(view->getTopBlock(),lppHeader1,lppHeader2,5,0,op);

	assert(uclaShape::equivalence(lppHeader1,lppHeader2)==false);
        assert(uclaShape::equivalence(lppHeader1,lppHeader1)==true);
	assert(uclaShape::empty(lppHeader1)==false);
	assert(uclaShape::empty(view->getTopBlock(),lppHeader1->getLayerNum(),lppHeader1->getPurposeNum()==false));	
//	cout<<uclaShape::area(lppHeader1)<<endl;

	
	uclaShape::bloat(view->getTopBlock(),lppHeader1,100);
	uclaShape::shrink(view->getTopBlock(),lppHeader1,100);
	uclaShape::bloat(view->getTopBlock(),lppHeader1,200,1);
	uclaShape::shrink(view->getTopBlock(),lppHeader1,200,1);

	//cout<<uclaShape::area(lppHeader1)<<endl;
	assert(uclaShape::equivalence(lppHeader1,lppHeader1)==true);
	
	uclaShape::scale_up(view->getTopBlock(),lppHeader1,2);
	uclaShape::scale_down(view->getTopBlock(),lppHeader1,2);
	uclaShape::scale_up(view->getTopBlock(),lppHeader1,4,1);
	uclaShape::scale_down(view->getTopBlock(),lppHeader1,4,1);
	//cout<<uclaShape::area(lppHeader1)<<endl;


	assert(uclaShape::equivalence(lppHeader1,lppHeader1)==true);


	headers.reset();
	int count=0;
	while(headers.getNext())
		count++;
	cout<<"Number of Layer= "<<count<<endl;

		
	view->save();
	view->close();

    }catch (oaException  &excp){
	cout << "Error: " << excp.getMsg() << endl;
	exit(1);
    }

    return 0;
}
