/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: Zhong Xiu <zxiu@andrew.cmu.edu>

ChangeLog:
2004-09-15: ChangeLog started
2005-07-17: Moved from Timer class
*/

#if !defined(oagUtilGlobMatch_P)
#define oagUtilGlobMatch_P

#include <string>

namespace oagUtil {

/// \brief A string matcher for glob-like patterns.
///
/// Patterns are strings which may contain special metacharacters.  The
/// '?' metacharacter matches any character.  The '*' metacharacter
/// matches zero or more characters.
///
/// \todo This class is very inefficient and should be fixed.

class GlobMatch {
  public:
    /// \brief Construct a matcher for the specified pattern.
    /// \param pattern Pattern to match against.
    GlobMatch(const std::string &pattern);

    ~GlobMatch() {
        // nothing
    }

    /// Match a string against the pattern.
    /// \param s String to check for match.
    /// \return True if the string matches the pattern.
    bool match(const std::string &s);

  private:
    std::string _pattern;

    bool _recursiveMatch(const std::string &pattern,
                         const std::string &s);
};

}

#endif
