/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: Zhong Xiu <zxiu@andrew.cmu.edu>

ChangeLog:
2004-09-15: ChangeLog started
*/

#if !defined(oagTimerExtDelay_P)
#define oagTimerExtDelay_P

#include <float.h>
#include <vector>
#include "oaDesignDB.h"

#include "oagTimerModel.h"

using namespace oa;

namespace oagTimer {

/*!
  The TimerExtDaly class defines the external delay value on
  the PI or PO.
*/

class TPointMaster;
 
class TimerExtDelay {
  friend class Timer;
  friend class Report;

  public:
    /*! The constructor, initialize the delay to be 0. */
    TimerExtDelay() {
      delay = 0.0;
    }
    /*! The destructor. */
    ~TimerExtDelay() {}

  private:
    /*! The external delay value on this oaOccTerm */
    DelayType delay;

    /*! The static appDef pointer */
    static oaVoidPointerAppDef<oaOccTerm> *termAppDef;
};

/*!
  The TimerDrivingCell class defines the driving cell's information 
  at the PI.
*/
class TimerDrivingCell {
  friend class Timer;
  friend class TPointMaster;
  friend class Report;

  public:
    /*! The constructor. */
    TimerDrivingCell() {
    }
    /*! The destructor. */
    ~TimerDrivingCell() {}

  private:
    /*! The external driving cell on this oaTerm */
    TPointMaster *driver;

    /*! The static appDef pointer */
    static oaVoidPointerAppDef<oaOccTerm> *termAppDef;
};

/*!
  The TimerFanoutLoad class defines the external fanout load value
  on the PO.
*/
class TimerFanoutLoad {
  friend class Timer;
  friend class Report;

  public:
    /*! The constructor. */
    TimerFanoutLoad() {
      load = 0.0;
    }
    /*! The destructor. */
    ~TimerFanoutLoad() {}

  private:
    /*! The external fanout load value on this oaOccTerm */
    double load;

    /*! The static appDef pointer */
    static oaVoidPointerAppDef<oaOccTerm> *termAppDef;
};

/*!
  The TimerInputTransition class defines the external transition value on
  the PI.
*/

class TimerInputTransition {
  friend class Timer;
  friend class Report;

  public:
    /*! The constructor, initialize the delay to be 0. */
    TimerInputTransition() {
      transition = 0.0;
    }
    /*! The destructor. */
    ~TimerInputTransition() {}

  private:
    /*! The external delay value on this oaOccTerm */
    TimeType transition;

    /*! The static appDef pointer */
    static oaVoidPointerAppDef<oaOccTerm> *termAppDef;
};

}

#endif
