/************************************************************
* 
* File: oagTimerDP.h
* Author: Santiago Mok (smok@ee.ucla.edu)
* Created: 03-05-2011
* Last Modified: Mon 21 Mar 2011 11:49:00 AM PDT
*
************************************************************/
#if !defined(oagTimerDP_P)
#define oagTimerDP_P

#include "oaDesignDB.h"
#include "oagTimerTimer.h"
#include "oagTimerUtil.h"

#include <map>
#include <vector>
namespace oagTimer{
/*---------------------------------------------------------*/
class DP{
  public:
    DP(oaDesign *d, Timer *t);
    ~DP();
    void run();

  private:
    void DpRelaxation();
    void DpRestoration();
    oaString getSolution(CellData *c);
    oaString resolveInconsistency(CellData *c);
    void mergeFanoutSolutions(oaOccInstTerm *outPin);
    void merge(oaOccInstTerm *outPin, oaIter<oaOccInstTerm> itIter, DPData *d);
    void pruneSolutions(vector<DPData*> &d);

    /*! Copy all data in DPData structure from source to destination
     * @param DPATA*: the source data structure
     * @param DPATA*: the destination data structure
     */
    void copyDPData(DPData *src, DPData *dst);
    void copyVecData(vector<DPData*> &src, vector<DPData*> &dst);

    /*! This function is used only in DP to query the max arrival time
     * to the given input arc (in) from the fanin instance
     * based on the given cellsize of the 
     * input arc's instance
     * @param oaOccInstTerm*: instance input arc
     * @param oaString: prospective size of the instance;
     */
    double getMaxArr(oaOccInstTerm *in, oaString prospSize);

    void clearDPDataVec(vector<DPData*> &vec);
    void clearDPData(DPData *v);

    //Debug:
    void printMap(map<oaOccInstTerm*,oaString> m);
    void printDPData(vector<DPData*> d);
    void printDPGraph();

  private:
    oaDesign *design;
    Timer *timing;
    vector<oaModInst*> G; 
    map<oaModInst*,oaString> currSizing;
    map<oaModInst*,oaString> bestDesign;
    bool iterRefine;
    map<oaOccInst*, oaString> dpSolutions;

    bool flag;
    int count;
    
    double targetDelay;
};
/*---------------------------------------------------------*/
}//namespace
#endif
