/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: Philip Chong <pchong@cadence.com>

ChangeLog:
2005-06-27: ChangeLog started
*/

#include "oagUtilUnitTest.h"

#include <iostream>

namespace oagUtil {

UnitTest::UnitTest(void) :
    numTests(0),
    numPassed(0)
{
}

UnitTest::~UnitTest()
{
}

void
UnitTest::logOneTest(bool       passed,
                     const char *message)
{
    ++numTests;
    if (passed) {
        ++numPassed;
        std::cout << "Unit test passed: " << message << std::endl;
    } else {
        std::cout << "Unit test failed: " << message << std::endl;
    }
}

int
UnitTest::getReturnCode(void)
{
    std::cout << "Unit test complete: " << numTests << " tests "
        << numPassed << " passed" << std::endl;
    return (numPassed == numTests) ? 0 : 1;
}

}
