/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: Philip Chong <pchong@cadence.com>

ChangeLog:
2005-08-11: ChangeLog started
*/

#include "oagUtilOaUtil.h"

using namespace oa;

namespace oagUtil {

///////////////////////////////////////////////////////////////////////////////
/// Get the bounding box for the given net.
/// An inverted box is returned for an empty net.
///
/// \param net Net for which to compute the bounding box.
/// \param box Bounding box for the net.

void
OaUtil::getBBox(const oa::oaNet *net,
                oa::oaBox       &box)
{
    box.init();

    // add pinFigs for terms on this net
    oaIter<oaTerm> termIter(net->getTerms());
    while (oaTerm *i = termIter.getNext()) {
        oaIter<oaPin> pinIter(i->getPins());
        while (oaPin *j = pinIter.getNext()) {
            oaIter<oaPinFig> figIter(j->getFigs());
            oaPinFig *pinFig = figIter.getNext();
            assert(pinFig);
            oaBox pinBox;
            pinFig->getBBox(pinBox);
            box.merge(pinBox);
        }
    }

    // add pinFigs for instTerms on this net
    oaIter<oaInstTerm> instTermIter(net->getInstTerms());
    while (oaInstTerm *i = instTermIter.getNext()) {
        oaTerm *masterTerm = i->getTerm();
        assert(masterTerm);
        oaInst *inst = i->getInst();
        assert(inst);
        oaTransform instTrans;
        inst->getTransform(instTrans);
        oaIter<oaPin> pinIter(masterTerm->getPins());
        while (oaPin *j = pinIter.getNext()) {
            oaIter<oaPinFig> figIter(j->getFigs());
            oaPinFig *pinFig = figIter.getNext();
            assert(pinFig);
            oaBox pinBox;
            pinFig->getBBox(pinBox);
            pinBox.transform(instTrans);
            box.merge(pinBox);
        }
    }
}

///////////////////////////////////////////////////////////////////////////////
/// Get the half-perimeter bounding box netlength for the given net.
/// Units are database units.
/// 0 is returned for an empty net.
///
/// \param net Net for which to compute the HPWL.

oa::oaUInt4
OaUtil::getHPWL(const oa::oaNet *net)
{
    oaBox box;
    getBBox(net, box);
    if (box.isInverted()) {
        return 0;
    }
    return box.getWidth() + box.getHeight();
}

///////////////////////////////////////////////////////////////////////////////

}
