/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: Philip Chong <pchong@cadence.com>

ChangeLog:
2005-06-27: ChangeLog started
*/

#include "oagUtilOptionsUnitTest.h"
#include "oagUtilOptions.h"

namespace oagUtil {

int OptionsUnitTest::runAllTests(void) {
    Options m;
    bool r;
    Options::OptionMap::iterator p;
    const char *s;

    // add()
    p = m.registry.find("opt1");
    logOneTest(p == m.registry.end(), "add 1.1");
    m.add("opt1", false, false);
    p = m.registry.find("opt1");
    logOneTest(p != m.registry.end(), "add 1.2");
    logOneTest(!(p->second).takesArgument, "add 1.3");
    logOneTest(!(p->second).isMandatory, "add 1.4");

    p = m.registry.find("opt2");
    logOneTest(p == m.registry.end(), "add 2.1");
    m.add("opt2", true, true);
    p = m.registry.find("opt2");
    logOneTest(p != m.registry.end(), "add 2.2");
    logOneTest((p->second).takesArgument, "add 2.3");
    logOneTest((p->second).isMandatory, "add 2.4");
    p = m.registry.find("opt1");
    logOneTest(p != m.registry.end(), "add 2.5");
    logOneTest(!(p->second).takesArgument, "add 2.6");
    logOneTest(!(p->second).isMandatory, "add 2.7");

    // parse()
    const char *argv1[] = {"command_name", "-opt2", "testarg"};
    r = m.parse(3, argv1);
    logOneTest(r, "parse 1.1");
    p = m.registry.find("opt1");
    logOneTest(p != m.registry.end(), "parse 1.2");
    logOneTest(!(p->second).given, "parse 1.3");
    p = m.registry.find("opt2");
    logOneTest(p != m.registry.end(), "parse 1.4");
    logOneTest((p->second).given, "parse 1.5");
    logOneTest((p->second).argument == "testarg", "parse 1.6");

    r = m.parse(2, argv1);
    logOneTest(!r, "parse 1.6");
    r = m.parse(1, argv1);
    logOneTest(!r, "parse 1.7");

    const char *argv2[] = {"command_name", "-opt2", "testarg", "-opt1"};
    r = m.parse(4, argv2);
    logOneTest(r, "parse 2.1");
    p = m.registry.find("opt1");
    logOneTest(p != m.registry.end(), "parse 2.2");
    logOneTest((p->second).given, "parse 2.3");
    p = m.registry.find("opt2");
    logOneTest(p != m.registry.end(), "parse 2.4");
    logOneTest((p->second).given, "parse 2.5");
    logOneTest((p->second).argument == "testarg", "parse 2.6");

    const char *argv3[] = {"command_name", "-bad", "-opt2", "testarg"};
    r = m.parse(4, argv3);
    logOneTest(!r, "parse 3.1");
    r = m.parse(2, argv3);
    logOneTest(!r, "parse 3.2");
    r = m.parse(1, argv3);
    logOneTest(!r, "parse 3.3");

    // isGiven()
    r = m.parse(3, argv1);
    logOneTest(!m.isGiven("opt1"), "isGiven 1.1");
    logOneTest(m.isGiven("opt2"), "isGiven 1.2");
    logOneTest(!m.isGiven("opt3"), "isGiven 1.3");

    // getValue()
    s = m.getValue("opt1");
    logOneTest(!s, "getValue 1.1");
    s = m.getValue("opt2");
    logOneTest(s, "getValue 1.2");
    logOneTest(std::string("testarg") == s, "getValue 1.3");

    return getReturnCode();
}

}
