/************************************************************
* 
* File: oagTimerSensitivity.cpp
* Author: Santiago Mok (smok@ee.ucla.edu)
* Created: 07-06-2009
* Last Modified: Mon 20 Sep 2010 04:20:53 PM PDT
*
************************************************************/

#include "oagTimerSensitivity.h"

namespace oagTimer{

//Constructor
//Sensitivity::Sensitivity(){}
//Sensitivity::~Sensitivity(){}
/*---------------------------------------------------------*/
float
Sensitivity::getSensitivity(const char *inst_old, const char *inst_new) {
    double cellLeak_new = Util::getCellLeakagePower(inst_new);
    double cellLeak_old = Util::getCellLeakagePower(inst_old);
    double s = cellLeak_new - cellLeak_old;
    return s; 
}
/*---------------------------------------------------------*/
sensitivityList
//void
Sensitivity::createSwapList(oaDesign* design, int decrease_only){
    oaNativeNS NS;
    oaString headerName;
    sensitivityList list;

    if(!list.empty()) list.clear();

    assert(design);
    oaModule *mod = design->getTopModule();
    
    assert(mod);
    oaIter<oaModInst> modIter ( mod->getInsts());
    while(oaModInst *modInst = modIter.getNext()){
	oaString masterName;
	vector<oaString> cellList;
	oaModule* master = modInst->getMasterModule();
	master->getName(NS,masterName);
	cellList.push_back(masterName);
	getMatchCells(cellList);
	//cout << cellList.size() << std::endl;
	while(!cellList.empty()){
	    oaString cellName = cellList.back();
	    cellList.pop_back();
	    SenseData d;
	    d.inst = modInst;
	    d.currInst = masterName;
	    d.newInst = cellName;
	    d.delta_power = d.delta = getSensitivity(masterName,cellName);
	    if(decrease_only && d.delta >= 0)
		continue;
	    list.push_back(d);
	}
    }
    return list;
}
/*---------------------------------------------------------*/
void 
Sensitivity::getMatchCells(vector<oaString> &list){
    //offset the '_' for matching cell names
    int offset=0;
    oaNativeNS NS;
  
    vector<oaString>::iterator iter;
    oaString masterName = list.back();
    list.pop_back();
    oaUInt4 _index = masterName.index('_',0);
    _index = masterName.index('_',_index+offset);
    oaUInt4 _masterEnd = masterName.getLength();
    for(iter = libParseData.libCellNames.begin(); 
	    iter != libParseData.libCellNames.end(); ++iter){
	oaString cellName = *iter;
	oaUInt4 _cIndex = cellName.index('_',0);
	_cIndex = masterName.index('_',_cIndex+offset);
	if(_index != _masterEnd){
	    oaString mName = oaString(masterName,_index);
	    oaString cName = oaString(cellName,_cIndex);
	    if(cName.operator==(mName) && cellName.operator != (masterName)){
		list.push_back(cellName);
	    }
	}
    }
}
/*---------------------------------------------------------*/
void 
Sensitivity::find_and_remove(oaModInst* currInst,sensitivityList &list){
    sensitivityList::iterator iter = list.begin();
    while(iter != list.end()){
	if(iter->inst == currInst){
	    iter=list.erase(iter);
	    continue;
	}
	++iter;
    }
}
/*---------------------------------------------------------*/
int
Sensitivity::updateSwapList(oaModInst* inst,sensitivityList &list,int decrease_only){
    //Remove SenseData with the given inst cell
    find_and_remove(inst,list);
    int size = int(list.size());

    //Find possible swaps for given inst cell and update current list
    oaNativeNS NS;
    oaString masterName;
    vector<oaString> cellList;

    oaModule* master = inst->getMasterModule();
    master->getName(NS,masterName);
    cellList.push_back(masterName);
    getMatchCells(cellList);
    //cout << cellList.size() << std::endl;
    while(!cellList.empty()){
	oaString cellName = cellList.back();
	cellList.pop_back();
	SenseData d;
	d.inst = inst;
	d.currInst = masterName;
	d.newInst = cellName;
	d.delta = getSensitivity(masterName,cellName);
	if(decrease_only && d.delta > 0)
	    continue;
	list.push_back(d);
    }
    return size;
}
/*---------------------------------------------------------*/
void
Sensitivity::invalidate_swapCell(oaDesign* design,Timer* t,oaModScalarInst *m){
    oaOccurrence *occ = design->getTopOccurrence();
    oaIter<oaOccInst> occInstIter (m->getOccInsts(occ));
    while(oaOccInst *occInst = occInstIter.getNext() ){
	oaIter<oaOccInstTerm> itIter (occInst->getInstTerms());
	while(oaOccInstTerm *occInstTerm = itIter.getNext()){		
	    oaTermType type(occInstTerm->getTerm()->getTermType());
	    if(type == oacInputTermType){
		oaOccNet *net = occInstTerm->getNet();
		t->invalidateFanout(net);
	    }
	    if(type == oacOutputTermType){
		oaOccNet *net = occInstTerm->getNet();
		t->invalidateFanin(net);
	    }
	}
    }
}
/*---------------------------------------------------------*/
oaOccInstTerm*
Sensitivity::findOccOutputTerm(oaDesign *design, oaModScalarInst *m){
    oaOccurrence *occ = design->getTopOccurrence();
    oaOccInstTerm *outputTerm;
    oaIter<oaOccInst> occInstIter (m->getOccInsts(occ));
    while(oaOccInst *occInst = occInstIter.getNext() ){
	oaIter<oaOccInstTerm> itIter (occInst->getInstTerms());
	while(oaOccInstTerm *occInstTerm = itIter.getNext()){		
	    oaTermType type(occInstTerm->getTerm()->getTermType());
	    if(type == oacOutputTermType){
		//outputTerm = occInstTerm;
		return occInstTerm;
	    }
	}
    }
    //return outputTerm;
}
/*---------------------------------------------------------*/
} //namespace
