/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: Zhong Xiu <zxiu@andrew.cmu.edu>

ChangeLog:
2004-09-15: ChangeLog started
*/

#include <assert.h>
#include <iostream>
#include <string.h>
#include "oaDesignDB.h"

#include "oagTimerTPointMaster.h"
#include "oagTimerTimer.h"
#include "oagTimerSdcData.h"

#undef DEBUG
#define AFSHIN

namespace oagTimer {


int
SdcData::pushMultiCyclePath(std::string pathType, int m) {
  static_cast<void>(pathType);
  while (!ports.empty()) {
    int max_m = m;
    std::string f = ports.back();
    termIntMap::iterator it = multiCycleConstraints.find(f);
    if (it != multiCycleConstraints.end()) {
      if ((*it).second > max_m) {
        max_m = (*it).second;
      }
    } 
    multiCycleConstraints[f] = max_m;
    ports.pop_back();
  }
  return 0;
}


//-----------------------------------------------------------------------------

void
SdcData::clear() {
  extInputDelays.clear();
  extOutputDelays.clear();
}

//-----------------------------------------------------------------------------

/*! All the PIs have the same input delay value. */
int 
SdcData::pushAllInputs() {
#if defined(DEBUG)
  std::cout << "push all inputs" << std::endl;
#endif
  allInputs = true;
  return 0;
}

//-----------------------------------------------------------------------------

/*! All the POs have the same output delay value. */
int 
SdcData::pushAllOutputs() {
#if defined(DEBUG)
  std::cout << "push all outputs" << std::endl;
#endif
  allOutputs = true;
  return 0;
}

//-----------------------------------------------------------------------------

int SdcData::pushPorts(const char *s) {
#if defined(DEBUG)
  std::cout << "push clock ports" << std::endl;
#endif
  currentPort = s;
  ports.push_back(s);
  return 0;
}

//-----------------------------------------------------------------------------

/*! Push the clock period's value. */
int SdcData::pushClock(double c, const char *s) {
#if defined(DEBUG)
  std::cout << "push clock" << std::endl;
#endif
  clockPeriod = c;

/* afshin-begin */
  clock *clk = new clock;
  clk->period = c;
  clk->name = static_cast<std::string> (s);
  propagatedClock *propClk = new propagatedClock;
  propClk->m = 1;
  propClk->phase = false;
  propClk->clk = clk;
  int i = propagatedClocks.size();
  propagatedClocks.push_back(propClk);
  if (allInputs) {
     allInputsClock = i;
     return 0;
  } 
  if (allOutputs) {
     allOutputsClock = i;
     return 0;
  } 
  while (!ports.empty()) {
    termClock[ports.back()] = i;
    isClock[ports.back()] = 1;
#if defined(DEBUG)
    std::cout << "port: " << ports.back() << std::endl;
#endif
    ports.pop_back();
  }
/* afshin-end */

  return 0;
}

//-----------------------------------------------------------------------------

/*! Push the PI's input delay value. */
int 
SdcData::pushInputDelay(double d) {
#if defined(DEBUG)
  std::cout << "push input delay" << std::endl;
#endif
  if (allInputs) allInputsDelay = d;
  else if (currentPort == "") return 1;
  else {
    extInputDelays[std::string(currentPort)] = d;
  }

  currentPort = "";
  return 0;
}
/* afshin-begin */
int 
SdcData::pushInputDelay(double d, std::string s) {
#if defined(DEBUG)
  std::cout << "push input delay" << std::endl;
#endif
  unsigned int i = 0;
  for (i = 0; i<propagatedClocks.size(); i++) {
    clock *clk = propagatedClocks[i]->clk;
    if (s.compare(clk->name) == 0) {
      break;
    }
  }
  assert(i<propagatedClocks.size());
  if (allInputs) {
    allInputsDelay = d;
    allInputsClock = i;
  }
  else if (currentPort == "") return 1;
  else {
    while (!ports.empty()) {
      termClock[ports.back()] = i;
#if defined(DEBUG)
      std::cout << "port: " << ports.back() << std::endl;
#endif
      extInputDelays[std::string(ports.back())] = d;
      ports.pop_back();
    }
  }

  currentPort = "";
  return 0;
}
/* afshin-end */

//-----------------------------------------------------------------------------

/*! Push the PO's output delay value. */
int 
SdcData::pushOutputDelay(double d) {
#if defined(DEBUG)
  std::cout << "push output delay" << std::endl;
#endif
  if (allOutputs) allOutputsDelay = d;
  else if (currentPort == "") return 1;
  else {
    extOutputDelays[std::string(currentPort)] = d;
  }

  currentPort = "";
  return 0;
}

/* afshin-begin */
int 
SdcData::pushOutputDelay(double d, std::string s) {
#if defined(DEBUG)
  std::cout << "push output delay" << std::endl;
#endif
  unsigned int i = 0;
  for (i = 0; i<propagatedClocks.size(); i++) {
    clock *clk = propagatedClocks[i]->clk;
    if (s.compare(clk->name) == 0) {
      break;
    }
  }
  assert(i<propagatedClocks.size());
  if (allOutputs) {
    allOutputsDelay = d;
    allOutputsClock = i;
  }
  else if (currentPort == "") return 1;
  else {
    while (!ports.empty()) {
      termClock[ports.back()] = i;
#if defined(DEBUG)
      std::cout << "port: " << ports.back() << std::endl;
#endif
      extOutputDelays[std::string(ports.back())] = d;
      ports.pop_back();
    }
  }

  currentPort = "";
  return 0;
}
/* afshin-end */

//-----------------------------------------------------------------------------

/*! All the PIs have the same driving cells. */
int 
SdcData::pushAllCells() {
#if defined(DEBUG)
  std::cout << "push all cells" << std::endl;
#endif
  allCells = true;
  return 0;
}

//-----------------------------------------------------------------------------

/*! All the POs have the same load values. */
int 
SdcData::pushAllLoads() {
#if defined(DEBUG)
  std::cout << "push all loads" << std::endl;
#endif
  allLoads = true;
  return 0;
}

//-----------------------------------------------------------------------------

/*! Push the driving cell's name. */
int 
SdcData::pushDrivingCell(const char *s) {
#if defined(DEBUG)
  std::cout << "push driving cell" << std::endl;
#endif
  if (allCells) allDrivingCells = s;
  else if (currentPort == "") return 1;
  else {
    drivingCells[std::string(currentPort)] = s;
  }

  currentPort = "";
  return 0;
}

//-----------------------------------------------------------------------------

/*! Push the fanout load's value. */
int 
SdcData::pushFanoutLoad(double d) {
#if defined(DEBUG)
  std::cout << "push fanout load" << std::endl;
#endif
  if (allLoads) allFanoutLoads = d;
  else if (currentPort == "") return 1;
  else {
    fanoutLoads[std::string(currentPort)] = d;
  }

  currentPort = "";
  return 0;
}

//-----------------------------------------------------------------------------

}
