/************************************************************
* 
* File: oagTimerOpt.cpp
* Author: Santiago Mok (smok@ee.ucla.edu)
* Created: 10-02-2009
* Last Modified: Thu 24 Feb 2011 02:52:55 PM PST
*
************************************************************/

//#include <cmath>
#include "oagTimerPeepHole.h"
#include "oagTimerDesignTool.h"
#include "oagTimerOpt.h"
#include "oagTimerTimer.h"
#include "oagTimerTPoint.h"
#include "oagTimerLibParserInt.h"
#include "oagTimerDuetSensitivity.h"

//#define DEBUG
//#define TYPE1
//#define TYPE2
#define MODE_READ 'r'
namespace oagTimer{
/*---------------------------------------------------------*/
using namespace oa;
using namespace std;
/*---------------------------------------------------------*/
//Constructor
Opt::Opt(oaDesign *d, Timer *t){
    design = d;
    timing = t;
    //ut = new Util();
    level = 0;
    currRankLevel = 1;
    currNotTaken = currFanoutLevel = 0;
    issueReturn = any_move_taken = false; 
    max_fo = 0;
    mode = UPSIZE_ROOT;
}
//Destructor
Opt::~Opt(){
    clearContainers();
    //delete ut;
}
/*---------------------------------------------------------*/
void 
Opt::run(){
#if defined(DEBUG)
    std::cout << "peepHoleOpt()" << std::endl;
#endif
    time_t start, loop_begin, now, end, endRank;
    int bin_size; 
    int totalRoot;
    time (&start);
    std::cout << " Begin Peephole Optimization - Initial Cell Leakage:" << Util::getTotalLeakPower(design) << std::endl;

    int max_size = 10;
    clearContainers();
    initDesign();
    vector<int> bins_counter (max_size);
    float f = 0;
    totalRoot = 0;
    bin_size = 0;
    int max = 3;
    any_move_taken = false;

  for(int fo_lvl=1; fo_lvl<=max; ++fo_lvl){
    currFanoutLevel = fo_lvl;
    takenSwapInstsChecklist.clear();
    std::cout << "Fanout Level Currently Considered:" << fo_lvl << std::endl;

    std::cout << " * TYPE - FANOUT Gain * " << std::endl;
    design_Insts_type2 = DesignTool::getDecreasingFanoutGain(design,timing,fo_lvl);
    //printRootNodeSorting(design_Insts_type2,3);
    for(vector<instTimingData>::iterator it=design_Insts_type2.begin(); it!=design_Insts_type2.end(); ++it){
	rootData root;
	root.inst = it->inst;
	root.score = it->fanoutWeight;
	root.fanoutLevel = fo_lvl;
	multiLevelRootInstances.push_back(root);
    }
  } //fo_lvl
  //return;

    sort(multiLevelRootInstances.begin(), multiLevelRootInstances.end(), rankHigh);
    time(&endRank);
    std::cout << "Total Roots:" << sizedRootNodeCount.size() << std::endl;
    std::cout << "Multi Level Root Ranking Total Size:" << multiLevelRootInstances.size()
	<< std::endl;
    std::cout << "Done Ranking all Root Node:" << difftime(endRank,start) << "(s)" << std::endl;

    time(&loop_begin);
    totalRoot = multiLevelRootInstances.size();
    bin_size = (int)(totalRoot/max_size);
    std::cout << "binsize:" << bin_size << std::endl;
    int rank_size = (int)(totalRoot/max);
    std::cout << "ranksize:" << rank_size << std::endl;

    int pos = 0;
    if(!PeepholeChecklist.empty()) PeepholeChecklist.clear();
    float l = Util::getTotalLeakPower(design);
    for(vector<rootData>::iterator it=multiLevelRootInstances.begin();
	    it!=multiLevelRootInstances.end(); ++it){
	vector<oaModInst*> fo_insts; 
	DesignTool::getFanouts(it->inst,fo_insts,it->fanoutLevel);
	if(!fo_insts.empty()) scanPeepHoles(it->inst,fo_insts,it->fanoutLevel);
	//if(issueReturn) return;
    }
    time(&now);
    cout << "Current Loop Time:" << difftime(now,loop_begin) << endl;
    cout << "Time:" << difftime(now,start) << endl;

    doOneOPT();
    f = Util::getTotalLeakPower(design);

    time(&end);
    cout << "Total Runtime:" << difftime(end,start) << endl;
    std::cout << "End Optimization - Final Leakage:" << f << std::endl;
}
/*---------------------------------------------------------*/
void 
Opt::peepHoleOpt(int lvl, int RS){
#if defined(DEBUG)
    std::cout << "peepHoleOpt()" << std::endl;
#endif
    level = lvl;
    time_t start, loop_begin, now, end, endRank;
    int bin_size; 
    int totalRoot;
    time (&start);
    std::cout << " Begin Peephole Optimization - Initial Cell Leakage:" << Util::getTotalLeakPower(design) << std::endl;

    int max_size = 10;
    clearContainers();
    initDesign();
    numOfTimingInfeasiblePH = numOfTrials = totalNumOfTrials = numOfTaken = totalNumOfTaken = 0;
    numOfZeroOPTMove = numOfOneOPTMove = numOfTwoOPTMove = numOfOneTaken = 0;
    vector<int> bins_counter (max_size);
    float f = 0;
  //for(int i=0; i<4; ++i){

  //for(int m=0;m<2;++m){
    for(int j=0; j<bins_counter.size(); ++j){
	bins_counter[j] = 0;
    }
    //DesignTool::getNetWeight(design,timing);
    totalRoot = 0;
    bin_size = 0;
    /*if(RS==0){ 
	std::cout << " * TYPE - TOPOLOGICAL * " << std::endl;
	design_Insts = DesignTool::getTopological(design);
   }else if(RS==1){ 
	std::cout << " * TYPE - INCREASING SLACK * " << std::endl;
	design_Insts_type2 = DesignTool::getIncreasingSlack(design,timing);
	//break;
    }else if(RS==2){
	std::cout << " * TYPE - SLEW * " << std::endl;
	design_Insts_type2 = DesignTool::getDecreasingSlew(design,timing);
    }else if(RS==3){ 
	std::cout << " * TYPE - FANOUTWEIGHT * " << std::endl;
	//design_Insts_type2 = DesignTool::getDecreasingFanoutWeight(design,timing,1,
	    //downsized_sensitivity_Insts);
    }else if(RS==4){ 
	std::cout << " * TYPE - DECREASING SLACK * " << std::endl;
	design_Insts_type2 = DesignTool::getDecreasingSlack(design,timing);
    }*/
    //printRootNodeSorting(design_Insts_type2,3);
    /*
    if(RS==0) totalRoot = design_Insts.size();
    else totalRoot = design_Insts_type2.size();
    bin_size = (int)(totalRoot/max_size);*/

    int max = 3;
    any_move_taken = false;
    /*for(vector<instTimingData>::iterator it=design_Insts_type2.begin(); 
	    it!=design_Insts_type2.end(); ++it){
		std::cout << "Inst " << Util::getInstName(it->inst) 
		    << " : " << it->out_Slack << std::endl;
    }*/
    numOfPeepholeTrials = 0;
    curr_counter = 0;
    curr_ph_counter = 0;
    total_ph_counter = 0;
    numOfFanoutsTakenTwice = 0;
      /*flag = false;
      */
  for(int fo_lvl=1; fo_lvl<=max; ++fo_lvl){
    currFanoutLevel = fo_lvl;
    takenSwapInstsChecklist.clear();
    std::cout << "Fanout Level Currently Considered:" << fo_lvl << std::endl;

    if(RS==1){ 
	std::cout << " * TYPE - FANOUT DownSizeSum * " << std::endl;
	design_Insts_type2 = DesignTool::getDecreasingFanoutWeight(design,timing,fo_lvl);
    }else if(RS==2){
	std::cout << " * TYPE - FANOUT SlackSum * " << std::endl;
	//design_Insts_type2 = DesignTool::getDecreasingFanoutSlack(design,timing,fo_lvl);
    }else if(RS==3){
	std::cout << " * TYPE - FANOUT Gain * " << std::endl;
	design_Insts_type2 = DesignTool::getDecreasingFanoutGain(design,timing,fo_lvl);
    }
    //printRootNodeSorting(design_Insts_type2,3);
    for(vector<instTimingData>::iterator it=design_Insts_type2.begin(); it!=design_Insts_type2.end(); ++it){
	rootData root;
	root.inst = it->inst;
	root.score = it->fanoutWeight;
	root.fanoutLevel = fo_lvl;
	multiLevelRootInstances.push_back(root);
    }
  }//fo_lvl
  //return;
    sort(multiLevelRootInstances.begin(), multiLevelRootInstances.end(), rankHigh);
    time(&endRank);
    std::cout << "Total Roots:" << sizedRootNodeCount.size() << std::endl;
    std::cout << "Multi Level Root Ranking Total Size:" << multiLevelRootInstances.size()
	<< std::endl;
    std::cout << "Done Ranking all Root Node:" << difftime(endRank,start) << "(s)" << std::endl;

    time(&loop_begin);
    if(RS==0) totalRoot = design_Insts.size();
    //else totalRoot = design_Insts_type2.size();
    else totalRoot = multiLevelRootInstances.size();
    bin_size = (int)(totalRoot/max_size);
    std::cout << "binsize:" << bin_size << std::endl;
    int rank_size = (int)(totalRoot/max);
    std::cout << "ranksize:" << rank_size << std::endl;

    // For exponential curve fitting
    int numOfBuckets = 50;
    numOfTakeninBucket = 0;
    //numOfTrialinBucket = 0;
    double currBucketData[numOfBuckets];
    //int bucket_size = (int) ceil(double(totalRoot)/double(numOfBuckets));
    int bucket_size = totalRoot/numOfBuckets;
    std::cout << "Bucket Size:" << bucket_size << std::endl;
    double xData[numOfBuckets];
    double yData[numOfBuckets];
    double threshold = 0.0;
    double temp_val = 0.0;
    int CheckPoint = (int) ceil(0.3*double(numOfBuckets));
    int midPoint = numOfBuckets/2;

    int count = 0;
    int rootCounter = 0;
    int bucketCounter = 0;
    int bucketPos = 0;
    int pos = 0;
    if(RS == 0){
	/*for(vector<oaModInst*>::iterator it=design_Insts.begin(); it!=design_Insts.end(); ++it){
	    ++count;
	    if(level == 1) scanPeepHoles(*it);
	    else{
		vector<oaModInst*> fo_insts; 
		DesignTool::getFanouts(*it,fo_insts,fo_lvl);
		if(!fo_insts.empty()) scanPeepHoles(*it,fo_insts,level);
	    }
	}*/
    }else{
	if(!PeepholeChecklist.empty()) PeepholeChecklist.clear();
	//for(vector<instTimingData>::iterator it=design_Insts_type2.begin(); it!=design_Insts_type2.end(); ++it){
	float l = Util::getTotalLeakPower(design);
	for(vector<rootData>::iterator it=multiLevelRootInstances.begin();
		it!=multiLevelRootInstances.end(); ++it){
	    ++count;
	    ++rootCounter;
	    ++bucketCounter;
	    if(level == 1) scanPeepHoles(it->inst);
	    else{
		vector<oaModInst*> fo_insts; 
		DesignTool::getFanouts(it->inst,fo_insts,it->fanoutLevel);
		if(!fo_insts.empty()) scanPeepHoles(it->inst,fo_insts,it->fanoutLevel);
		//if(issueReturn) return;
	    }
	    if(count == bin_size){ 
		int temp = bins_counter[pos];
		bins_counter[pos] = temp+curr_counter;
		/*std::cout << "Pos:" << pos 
		    << " Taken:" << bins_counter[pos] 
		    << " TotalTrials:" << numOfPeepholeTrials << std::endl;
		    */
		curr_counter = 0;
		count = 0;
		// Current Iteration stastics information
		f = Util::getTotalLeakPower(design);
		/*if ((l-f) > 0){
		    std::cout << "** Current Iteration Gain:" << (l-f) << std::endl;
		    std::cout << "Current Leakage:" << f << std::endl;
		    l = Util::getTotalLeakPower(design);
		}*/
		numOfPeepholeTrials = 0;
		++pos;
	    }
	    if(rootCounter == rank_size){ 
		++currRankLevel;
		std::cout << "Rank Level:" << currRankLevel << std::endl;
		rootCounter = 0;
	    }
	    /*if(bucketCounter == bucket_size){ 
		double val = double(numOfTakeninBucket)/double((bucketPos+1)*bucket_size);
		//double val = numOfTakeninBucket/numOfTrialinBucket;
		//double val = double(numOfTakeninBucket)/double(bucket_size);
		std::cout << "Bucket:" << bucketPos << " Rate:" << val  
		    << " Taken:" << numOfTakeninBucket << std::endl;
		currBucketData[bucketPos] = val;
		if(bucketPos == 0 || (val > temp_val)){ 
		    threshold = val/5.5;
		    temp_val = val;
		}
		xData[bucketPos] = double(bucketPos);
		//if(val == 0.0) val = 0.00001; 
		yData[bucketPos] = log(val);
		//numOfTrialinBucket = 
		//numOfTakeninBucket = 
		bucketCounter = 0;
		++bucketPos;
		//if((bucketPos%5) == 0){
		if((bucketPos == CheckPoint) || (bucketPos == midPoint)){
		    std::cout << " Checkpoint:" << bucketPos << " Rate:" << val << std::endl;
		    //for(int i=0; i < bucketPos; ++i){
		//	std::cout << "xData:" << xData[i]
		//	    << " yData:" << yData[i] << std::endl;
		    //}
		    if(bucketPos == midPoint){
			if(CheckPoint > numOfBuckets){
			    std::cout << "Checkpoint Out of Bound:" << CheckPoint << std::endl;
			    threshold *= 3.0;
			}
		    }
		    double a = 0.0;
		    double b = 0.0;
		    //fitting log(y) = log(a) + bx to get y=alpha*exp(beta*x);
		    // alpha = exp(b);
		    // beta = a;
		    Util::linear_fit(a,b,xData,yData,bucketPos); 
		    std::cout << "a:" << a << " b:" << b << std::endl;
		    double alpha = exp(b);
		    double beta = a;

		    double nextCheckPoint = log(threshold/alpha)/beta;
		    std::cout << "CheckPoint:" << nextCheckPoint << 
			" Threshold:" << threshold << std::endl;
		    CheckPoint = (int)ceil(nextCheckPoint);
		    if(bucketPos >= CheckPoint){
			std::cout << "Breaking at " << bucketPos << std::endl;
			break;
		    }
		}
	    }*/
	    //if(bucketPos == midPoint){
	    /*if(bucketPos == 100){
		std::cout << "Breaking at " << bucketPos << std::endl;
		break;
	    }*/
	}
    }
    time(&now);
    cout << "Current Loop Time:" << difftime(now,loop_begin) << endl;
    cout << "Time:" << difftime(now,start) << endl;
    currNotTaken = numOfTrials = numOfTaken = 0;

    int numOfRootNodeTakenOnce = 0; 
    int numOfRootNodeTakenTwice = 0; 
    int numOfRootNodeTakenMore = 0; 
    map<oaModInst*,int>::iterator iter;
    for(iter=sizedRootNodeCount.begin(); iter!=sizedRootNodeCount.end(); ++iter){
	if(iter->second == 1) ++numOfRootNodeTakenOnce; 
	else if(iter->second == 2) ++numOfRootNodeTakenTwice; 
	else if(iter->second > 2) ++numOfRootNodeTakenMore; 
    }
    /*int cnt = 0;
    int idx = 0;
    int oneOptMove = 0;
    int twoOptMove = 0;
    int moreOptMove = 0;
    vector<optData> optVec (max_size);
    for(vector<instTimingData>::iterator it=design_Insts_type2.begin(); it!=design_Insts_type2.end(); ++it){
	++cnt;
	map<oaModInst*,int>::iterator s_it;
	s_it = sizedRootNodeCount.find(it->inst);
	if(s_it != sizedRootNodeCount.end()){
	    int n = s_it->second;
	    if(n == 1) ++oneOptMove; 
	    else if(n == 2) ++twoOptMove; 
	    else if(n > 2) ++moreOptMove; 
	}
	if(cnt == bin_size){ 
	    optVec[idx].oneOptData = oneOptMove;
	    optVec[idx].twoOptData = twoOptMove;
	    optVec[idx].moreOptData = moreOptMove;
	    oneOptMove = twoOptMove = moreOptMove = cnt = 0;
	    ++idx;
	}
    }*/
    //std::cout << "Max Fanouts for this design:" << max_fo << std::endl;

    std::cout << "Statistics:" << std::endl;
    //std::cout << "Total # of One Move: " << numOfOneTaken << std::endl;
    //std::cout << "Total # of 0-Opt Move: " << numOfZeroOPTMove << std::endl;
    //std::cout << "Total # of 1-Opt Move: " << numOfOneOPTMove << std::endl;
    //std::cout << "Total # of 2-Opt Move: " << numOfTwoOPTMove << std::endl;
    //std::cout << "Total # of Taken Move: " << totalNumOfTaken << std::endl;
    std::cout << "Total # of Timing Infeasible Move: " << numOfTimingInfeasiblePH << std::endl;
    std::cout << "Total # of Trials:" << totalNumOfTrials << std::endl;
    //std::cout << "Total # of RootNode Taken Once: " << numOfRootNodeTakenOnce << std::endl; 
    //std::cout << "Total # of RootNode Taken Twice: " << numOfRootNodeTakenTwice << std::endl; 
    //std::cout << "Total # of RootNode Taken More than Twice: " << numOfRootNodeTakenMore << std::endl; 
    std::cout << "Total # of RootNode: " << (int)sizedRootNodeCount.size() << std::endl; 
    
    int id = 0;
    int tot = 0;
    /*for(vector<int>::iterator it=bins_counter.begin(); it!=bins_counter.end(); ++it){
	std::cout << "Bin(" << id << ") " << *it 
	    << " " << optVec[id].oneOptData << " " << optVec[id].twoOptData
	    << " " << optVec[id].moreOptData << std::endl;
	tot += *it;
	++id;
    }*/
    std::cout << "# of Peephole FANOUTS TWICE:" << numOfFanoutsTakenTwice << std::endl;
    std::cout << "Total Taken:" << tot << std::endl;
    std::cout << "First 10 FO Acceptance Rate:" << curr_ph_counter << "/" 
	<< total_ph_counter << std::endl;
    std::cout << "End Peephole - Final Leakage:" << f << std::endl;
    /*for(int i=0; i<takenFanoutCounter.size();++i){
	std::cout << " FO(" << i << "): " << 
	    takenFanoutCounter[i] << std::endl;
    }
    std::cout << "# of Buckets:" << numOfBuckets << " Bucket Size:" << bucket_size << std::endl;
    for(int i=0; i<numOfBuckets;++i){
	std::cout << " Bucket(" << i << "): " << 
	    currBucketData[i] << std::endl;
    }*/
    doOneOPT();
    f = Util::getTotalLeakPower(design);
    //std::cout << "After ONE_OPT - Final Leakage:" << f << std::endl;

    time(&end);
    cout << "End Time:" << difftime(end,start) << endl;
    std::cout << "End Optimization - Final Leakage:" << f << std::endl;
    //}
    //}
}
/*---------------------------------------------------------*/
void
Opt::doOneOPT(){
    DuetSensitivity duetOpt(design,timing);
    //duetOpt.flag = true;
    //duetOpt.duetTest(duetType(DUET_POWER_DELAY));
    duetOpt.run();
    /*level = 1;
    oaIter<oaModInst> modIter ( mod->getInsts());
    while(oaModInst *modInst = modIter.getNext()){
	CellData *cell = CellData::get(modInst);
	assert(cell);
	if(cell->getDownSizeCount()){
	    //double s = getDownSizeSensitivities(cell);
	    double s = getDownSizeDelaySensitivity(cell);
	    if(s == DBL_MAX) continue;
	    cellScore c;
	    c.inst = modInst;
	    c.score = s;
	    cells_vector.push_back(c);
	}
    }
    sort(cells_vector.begin(),cells_vector.end(),rank_cell_score);
    for(vector<cellScore>::iterator it=cells_vector.begin();
	    it!=cells_vector.end(); ++it){
	scanPeepHoles(it->inst);
    }*/
}
/*---------------------------------------------------------*/
void
Opt::scanPeepHoles(oaModInst* root){
#if defined(DEBUG)
    std::cout << "scanPeepHole()-1" << std::endl;
#endif
    PeepHole p(design, timing, level);
    int status = p.set(root);
    if(status != 0){
	//No imd fanout
	std::cout << "Error on fanouts" << std::endl; 
	return;
    }
    ph=&p;
    genAllCombinations();
}
/*---------------------------------------------------------*/
void
Opt::scanPeepHoles(oaModInst* root, instVector fo,int foLvl){
#if defined(DEBUG)
    std::cout << "scanPeepHole()-2" << std::endl;
#endif
    instVector processedFanouts = Preprocess_Peepholes(root,fo);
    if(processedFanouts.empty()) return;

    int pos = 0;
    bool PH_SWAPPED = false;
    int cnt = 0;
//for(instVector::iterator iter=processedFanouts.begin();
//iter!=processedFanouts.end(); ++iter){
    currPHMoveTaken = false;
    PeepHole p(design, timing, foLvl);
    int status = p.set(root,processedFanouts);
    if(status != 0){
	++pos;
	return;
	//continue;
    }
    ++total_ph_counter;
    ++numOfPeepholeTrials;
    //++numOfTrialinBucket;
    ph=&p;
    //ph->print();
    doSizing();
    //if(issueReturn) return;
    //genAllCombinations();
    /*if(currPHMoveTaken){
	if(pos >= takenFanoutCounter.size()){
	    takenFanoutCounter.resize(pos+1);
	}
	int n = takenFanoutCounter[pos];
	takenFanoutCounter[pos] = n+1;
	//++curr_ph_counter;
	map<oaModInst*,int>::iterator s_it;
	s_it = sizedRootNodeCount.find(root);
	if(s_it != sizedRootNodeCount.end()){
	    int n = s_it->second;
	    sizedRootNodeCount[root] = ++n; 
	}
	PH_SWAPPED = true;
	cnt = 0;
    }else{
	//if(++cnt == 2) break;
    }
    ++pos;
    if(PH_SWAPPED) ++curr_ph_counter;
    */
}
/*---------------------------------------------------------*/
bool
Opt::scanPeepHoles(sensitivityData s){
#if defined(DEBUG)
    std::cout << "scanPeepHole()-3" << std::endl;
#endif
    PeepHole p(design, timing, level);
    int status = p.set(s.inst->getModInst());
    if(status != 0){
	//No imd fanout
	std::cout << "Error on fanouts" << std::endl; 
	return false;
    }
    ph=&p;
    //ph->print();
    SizingData _optData;
    initDataStruct(_optData);
    _optData.sizes[s.inst->getModInst()] = s.otherLibCellSize;
    _optData.leakage += Util::getCellLeakagePower(s.otherLibCellSize);
    bool swapStatus = doSwap(_optData);
    return swapStatus;
}
/*---------------------------------------------------------*/
void
Opt::doSizing(){
#if defined(DEBUG)
    std::cout << "doSizing()" << std::endl;
#endif
    int counter = 0;
    instVector currPhFanouts = ph->getFanouts(); 
    //bool validFanoutSize = true;
    //if(currPhFanouts.size() < 2) validFanoutSize = false;
    oaModInst *root = ph->getRoot();
    assert(root);
    CellData *rootCell = CellData::get(root);
    assert(rootCell);
    vector<oaString> rootList = rootCell->getGreaterThanCurrentSize();
    int roSize = rootList.size();
    /*std::cout << " ROOT:" << rootCell->instName << " from:"
	<< rootCell->master->name;*/
    for(int i=0; i<roSize; ++i){
	oaString nextUpMaster = rootList[i];
	//std::cout << " to:" << nextUpMaster << std::endl; 
	bool validTiming = setNewMaster(rootCell,nextUpMaster);
	//if(!validTiming) std::cout << "ROOT-TIMING-INFEASIBLE" << std::endl;
	int notTakenCounter = 0;
	bool validFanouts = false;
	int pos = 0;
	for(instVector::iterator it=currPhFanouts.begin(); 
		it!=currPhFanouts.end(); ++it){
	    CellData *foCell = CellData::get(*it);
	    assert(foCell);
	    /*std::cout << " fanout:" << foCell->instName << " from:"
		<< foCell->master->name;*/
	    vector<oaString> foList = foCell->getLessThanCurrentSize();
	    int foSize = foList.size();
	    bool currFanoutTaken = false;
	    for(int j=0; j<foSize; ++j){
		oaString nextDownMaster = foList[j];
		//std::cout << " to:" << nextDownMaster << std::endl; 
		bool isCommit = setNewMaster(foCell,nextDownMaster);
		if(!isCommit){
		    foCell->reverseSwap();
		    ut.invalidateFanIOTiming(design,timing,foCell->inst);
		    timing->updateAll();
		    //std::cout << "   this master NOT-taken" << std::endl;
		    break;
		}else{ 
		    float prevCellLeakage = foCell->master->leakage_power;
		    foCell->commitSwap(); 
		    foCell->isMark = true;
		    //ph->setFeasibleFanout(foCell,prevCellLeakage);
		    validFanouts = true;
		    currFanoutTaken = true;
		    notTakenCounter = 0;
		    //std::cout << "   this master taken" << std::endl;
		}
	    }
	    foCell->resetLibListPtr();
	    if(currFanoutTaken){
		if(pos >= takenFanoutCounter.size()){
		    takenFanoutCounter.resize(pos+1);
		}
		int n = takenFanoutCounter[pos];
		takenFanoutCounter[pos] = n+1;
	    }
	    ++pos;
	    if(!currFanoutTaken && (++notTakenCounter == 2)) break;
	}
	if(!validFanouts){ 
	    rootCell->reverseSwap();
	    ut.invalidateFanIOTiming(design,timing,rootCell->inst);
	    timing->updateAll();
	    //std::cout << "Invalid Peephole TIMING-INFEASIBLE" << std::endl;
	    ++numOfTimingInfeasiblePH;
	    ++currNotTaken;
	}else{
	    float prevCellLeakage = rootCell->master->leakage_power;
	    rootCell->commitSwap();
	    rootCell->isMark = true;
	    //bool phTaken = ph->commitFeasibleCandidates(prevCellLeakage);
	    if(!ph->isPowerImprove()){
		ph->reverseAllSizing();
		++currNotTaken;
		//std::cout << "Peephole REVERSED" << std::endl;
	    }else{
		//std::cout << "Peephole TAKEN" << std::endl;
		++numOfTaken;
		++totalNumOfTaken;
		++curr_counter;
		++curr_ph_counter;
		++numOfTakeninBucket;
		//break;
	    }
	}
    }
    if(ph->bestConfigExist()) ph->reloadBestSizing();
    //rootCell->resetLibListPtr();
    //timing->updateAll();
}
/*---------------------------------------------------------*/
bool
Opt::setNewMaster(CellData *cell, oaString newMaster){
    cell->swap(newMaster);
    ut.invalidateFanIOTiming(design,timing,cell->inst);
    //timing->clearDesignTimingData();
    timing->updateAll();

    /*oaOccInst *occInst = DesignTool::getOccInst(design,cell->inst);
    oaOccInstTerm *term = DesignTool::getOccOutInstTerm(occInst);
    TPoint *p = TPoint::get(term);
    assert(p);
    p->flag = true;*/
    /*vector<oaModInst*> fanouts;
    fanouts.clear();
    DesignTool::getFanouts(cell->inst,fanouts,1);
    for(int i=0; i<fanouts.size(); ++i){
	oaModInst *mi = fanouts[i];
	oaOccInst *occInst = DesignTool::getOccInst(design,mi);
	oaOccInstTerm *k = DesignTool::getOccOutInstTerm(occInst);
	TPoint *fp = TPoint::get(k);
	assert(fp);
	fp->flag = true;
    }*/
    //timing->updateAll();
    //return timing->isValidTiming();
    
    DelayType slack = timing->getWorstSlack();   
    //slack = -1;
    /*std::cout << cell->instName << " " 
	<< newMaster << "Worst Slack:" << slack << std::endl;*/
    //bool check = Util::hasValidArrTime(timing,cell);
    if(slack < 0){
	/*std::cout << "slack value:" << slack << std::endl;
	if(check){ 
	    issueReturn = true;
	    std::cout << "SLACK PROBLEM" << std::endl;
	}*/
	return false;
    }
    return true;
}
/*---------------------------------------------------------*/
/*
vector<combTimingData>
Opt::rankFanoutWeight(vector<instVector> vec){
    vector<instVector>::iterator vec_it;
    instVector::iterator it;
    vector<combTimingData> ranked_vec;
    for(vec_it=vec.begin(); vec_it!=vec.end(); ++vec_it){
	//DelayType netSlackSum = 0.0;
	//DelayType netSlack = 0.0;
	//bool jFlag = false;
	double score = 0.0;
	combTimingData d;
	for(it=vec_it->begin(); it!=vec_it->end(); ++it){	
	    CellData *cell = CellData::get(*it);
	    assert(cell);
	    score += (double)cell->getDownSizeCount();

	    //if(mode == UPSIZE_ROOT) netSlack = getDownSizeSensitivity(*it);
	    //else netSlack = getUpSizeSensitivity(*it);

	    //if(netSlack == DBL_MAX){ 
		//jFlag = true; 
		//break;
	    //}
	    //netSlackSum += netSlack; 
	}
	d.insts = *vec_it;
	d.score = score;
	//if(jFlag) continue;
	ranked_vec.push_back(d);
    }
    sort(ranked_vec.begin(), ranked_vec.end(), rank_high);
    //int fo_size = ranked_vec.size();
    
    */
    /*std::cout << "Ranked Combinations:" << std::endl;
    for(vector<combTimingData>::iterator r_it=ranked_vec.begin();
	    r_it!=ranked_vec.end(); ++r_it){
	for(it=(r_it->insts).begin(); it!=(r_it->insts).end();++it){
	    std::cout << "  " << Util::getInstName(*it);
	}
	std::cout << "   score:" << r_it->score << std::endl;
    }
    */
/*
    return ranked_vec;
}*/
/*---------------------------------------------------------*/
double
Opt::getUpSizeSensitivity(oaModInst* i){
    oaOccInst *inst = DesignTool::getOccInst(design,i);
    vector<sensitivityData>::iterator it;	
    for(it=upsized_sensitivity_Insts.begin(); it!= upsized_sensitivity_Insts.end();++it){
	if(it->inst == inst) return it->sensitivity;
    }
    return ModelType::MAX_DELAY();
}
/*---------------------------------------------------------*/
double
Opt::getDownSizeSensitivity(oaModInst* i){
    oaOccInst *inst = DesignTool::getOccInst(design,i);
    vector<sensitivityData>::iterator it;	
    for(it=downsized_sensitivity_Insts.begin(); it!= downsized_sensitivity_Insts.end();++it){
	if(it->inst == inst) return it->sensitivity;
    }
    return ModelType::MAX_DELAY();
}
/*---------------------------------------------------------*/
instVector
Opt::Preprocess_Peepholes(oaModInst* root, instVector vec){
#if defined(DEBUG)
    std::cout << "Preprocessing/Validating Peepholes" << std::endl;
#endif
    vector<combTimingData> processed_fanouts;
    instVector fanouts;
    if(!fanouts.empty()) fanouts.clear();
    //DelayType criticalSlack = timing->getWorstSlack();
    bool rootIsMinSize = false;
    CellData *root_cell = CellData::get(root);
    assert(root_cell);

    if(root_cell->isMark) return fanouts;
    if(root_cell->isMaxSize()) return fanouts;

    double upDelta = Util::getUpSizeDeltaDelay(design,timing,root_cell);
    double score = 0.0;
    for(instVector::iterator it=vec.begin(); it!=vec.end(); ++it){	
	CellData *fanout_cell = CellData::get(*it);
	assert(fanout_cell);
	if(fanout_cell->isMark) continue;
	if(fanout_cell->isMinSize()) continue;
	double down_sizes = fanout_cell->getDownSizeCount();
	combTimingData d;
	d.score = 0.0;
	if(down_sizes){ 
	    /*oaOccInstTerm *out_iTerm = DesignTool::getOccOutInstTerm(
					    DesignTool::getOccInst(design,*it));
	    DelayType slack = timing->getSlack(out_iTerm);*/
	    double downSense = getDownSizeDelaySensitivity(fanout_cell);
	    if(downSense == DBL_MAX) continue;
	    d.score = (-1.0*upDelta)+downSense; 
	    d.inst = *it;
	    processed_fanouts.push_back(d);
	}
    }
    if(processed_fanouts.empty()) return fanouts;

    //sort(processed_fanouts.begin(), processed_fanouts.end(), rank_low);
    sort(processed_fanouts.begin(), processed_fanouts.end(), rank_high);

    // Check for best fanout sensitivity, if worst than current, skip this PH
    combTimingData d = processed_fanouts.front();
    CellData *foutCell = CellData::get(d.inst);
    assert(foutCell);
    if((processed_fanouts.size() == 1) && (foutCell->getDownSizeCount() == 1)){
	if(root_cell->master->basename == foutCell->master->basename)
	    return fanouts;
    }

    // GOOD At 0.7 0.8 1.1
    double delta = 1.0;
    if(currRankLevel == 1){ 
	delta = 0.6; 
    }else if(currRankLevel == 2){ 
	delta = 0.7; 
    }else if(currRankLevel == 3){ 
	delta = 0.9; 
    }
    /*else if(currRankLevel == 4){
	delta = 1.0; 
    }else if(currRankLevel == 5){ 
	delta = 1.0;
    }*/

    //if(!root_cell->validFanoutSensitivity(d.score,delta)) return fanouts;

    for(vector<combTimingData>::iterator iter=processed_fanouts.begin();
	    iter != processed_fanouts.end(); ++iter){
	//std::cout << Util::getInstName(iter->inst) << " ProcessedFanout Score:" << iter->score << std::endl;
	//if(!root_cell->validFanoutSensitivity(iter->score,delta)) break;
	fanouts.push_back(iter->inst);
    }
    //root_cell->setFanoutSensitivity(d.score);
    return fanouts;
}
/*---------------------------------------------------------*/
/*
vector<combTimingData>
Opt::PreprocessComb_Slack(vector<instVector> vec){
    vector<instVector>::iterator vec_it;
    instVector::iterator it;
    vector<combTimingData> ranked_vec;
    for(vec_it=vec.begin(); vec_it!=vec.end(); ++vec_it){
	DelayType slackSum = 0;
	int minNumOfSizes = 10000;
	combTimingData d;
	for(it=vec_it->begin(); it!=vec_it->end(); ++it){	
	    slackSum += DesignTool::getMinSlack(design,timing,*it);
	    CellData *cell = CellData::get(*it);
	    int sizes = 0;
	    sizes = cell->getDownSizeCount();
	    //if(level == 2){
		//sizes = cell->getNumOfSizes();
	    //}else{
		//sizes = cell->getDownSizeCount();
	    //}
	    if(sizes < minNumOfSizes) minNumOfSizes = sizes;
	}
	d.insts = *vec_it;
	d.score = (DelayType)minNumOfSizes*slackSum;
	//if(d.score == 0) continue;
	ranked_vec.push_back(d);
    }
    sort(ranked_vec.begin(), ranked_vec.end(), rank_high);
    std::cout << "Ranked Combinations:" << std::endl;
    for(vector<combTimingData>::iterator r_it=ranked_vec.begin();
	    r_it!=ranked_vec.end(); ++r_it){
	for(it=(r_it->insts).begin(); it!=(r_it->insts).end();++it){
	    std::cout << "  " << Util::getInstName(*it);
	}
	std::cout << "   score:" << r_it->score << std::endl;
    }
    return ranked_vec;
}*/
/*---------------------------------------------------------*/
/*
vector<combTimingData>
Opt::PreprocessComb_Slew(vector<instVector> vec){
    vector<instVector>::iterator vec_it;
    instVector::iterator it;
    vector<combTimingData> ranked_vec;
    for(vec_it=vec.begin(); vec_it!=vec.end(); ++vec_it){
	DelayType slewSum = 0;
	int minNumOfSizes = 10000;
	combTimingData d;
	for(it=vec_it->begin(); it!=vec_it->end(); ++it){	
	    slewSum += DesignTool::getMaxSlew(design,timing,*it);
	    CellData *cell = CellData::get(*it);
	    int sizes = 0;
	    if(level == 2){
		sizes = cell->getNumOfSizes();
	    }else{
		sizes = cell->getDownSizeCount();
	    }
	    if(sizes < minNumOfSizes) minNumOfSizes = sizes;
	}
	d.insts = *vec_it;
	d.score = (DelayType)minNumOfSizes*slewSum;
	//if(d.score == 0) continue;
	ranked_vec.push_back(d);
    }
    sort(ranked_vec.begin(), ranked_vec.end(), rank_low);
    std::cout << "Ranked Combinations:" << std::endl;
    for(vector<combTimingData>::iterator r_it=ranked_vec.begin();
	    r_it!=ranked_vec.end(); ++r_it){
	for(it=(r_it->insts).begin(); it!=(r_it->insts).end();++it){
	    std::cout << "  " << Util::getInstName(*it);
	}
	std::cout << "   score:" << r_it->score << std::endl;
    }
    return ranked_vec;
}*/
/*---------------------------------------------------------*/
void
Opt::genAllCombinations(){
#if defined(DEBUG)
    std::cout << "generate All Combinations()" << std::endl;
#endif
    //if(!currPH_list.empty()) currPH_list.clear();

    //currPH_list = ph->getFanouts();
    oaModInst *root = ph->getRoot();
    assert(root);
    CellData *cell = CellData::get(root);
    assert(cell);
    //if(level == 1) 
    cell->updateLibSeekPtr();
    do{
	bool isSwapped = false;
	SizingData _optData;
	initDataStruct(_optData);
	oaString newLibCell = cell->getNextSize();
	_optData.sizes[root] = newLibCell;
	_optData.leakage += Util::getCellLeakagePower(newLibCell);
	if(level == 1) isSwapped = doSwap(_optData);
	/*else{
	    vector<oaModInst*>::iterator it = currPH_list.begin();
	    isSwapped = genCombinations(it,_optData);
	}*/
	//Break Once the swap is taken
	/*if(isSwapped){ 
	    break;
	}*/
    }while(cell->hasMoreSize());
    cell->resetLibListPtr();
}
/*---------------------------------------------------------*/
bool
Opt::genCombinations(vector<oaModInst*>::iterator &list_iter,SizingData &data_list){
    CellData *cell = CellData::get(*list_iter);
    assert(cell);
#if defined(DEBUG)
    std::cout << "genCombinations(" <<  cell->instName << ")" << std::endl;
#endif

    bool isSwapped = false;
    if(++list_iter == currPH_list.end()){
	cell->updateLibSeekPtr();
    }
    --list_iter;
    do{
	bool swapTaken = false;
	oaString newLibCell = cell->getNextSize();
	data_list.sizes[cell->inst] = newLibCell;
	double leak_power = Util::getCellLeakagePower(newLibCell);
	data_list.leakage += leak_power;
	//std::cout << " Inst:" << Util::getInstName(cell->inst) 
	    //<< "-" << newLibCell << std::endl;	

	if(++list_iter != currPH_list.end()){
	    swapTaken = genCombinations(list_iter,data_list);
	}
	else{
	    swapTaken = doSwap(data_list);
	}
	if(swapTaken) isSwapped = true;
	--list_iter;
	data_list.leakage -= leak_power;
	//Break Once the swap is taken
	if(swapTaken){ 
	    break;
	}
    } while(cell->hasMoreSize());
    cell->resetLibListPtr();
    return isSwapped;
}
/*---------------------------------------------------------*/
bool
Opt::doSwap(SizingData list){
#if defined(DEBUG)
    std::cout << "swap() List:" << std::endl;
    ph->print();
    printCombinations(list);
#endif
    //Skip invalid moves
    if(!validComb(list.leakage)){ 
	//std::cout << "Current Combinations Leakage Power is not feasible" << std::endl; 
	return false;
    }else{
	//std::cout << "Current Combinations Leakage Power is valid" << std::endl; 
    }
    ++totalNumOfTrials;
    ++numOfTrials;
    CellSizingMap _s = list.sizes;
 
    //Temporary storage for arr and slack value of current peephole trial
    vector<oaModInst*> insts_list;
    for(CellSizingMap::iterator sit=_s.begin();
	    sit!=_s.end(); ++sit){
	insts_list.push_back(sit->first);
    }
    map<oaOccInstTerm*,double> list_timing_before_swap = getTimingInformation(insts_list);
    //Set Master for swap
    for(CellSizingMap::iterator sit=_s.begin();
	    sit!=_s.end(); ++sit){
	CellData *cell = CellData::get(sit->first);
	assert(cell);
	cell->swap(sit->second);
	ut.invalidateFanIOTiming(design,timing,sit->first);
    }
    timing->updateAll();
    //Query timing information after swap is taken
    map<oaOccInstTerm*,double> list_timing_after_swap = getTimingInformation(insts_list);
    
    bool commit = true;
    //BoundingMap eval = ph->getEvalFanout();
    //InstTermMap evalFin = ph->getEvalFanin();
    /*for(BoundingMap::iterator eit=eval.begin();
	    eit!=eval.end(); ++eit){
	TimeType arr =  ut.getIOArr(eit->first,design,timing,OUTPUT);
	if(arr > eit->second){
	    commit = false;
	}
	if(!commit){
	    std::cout << "Move Reversed on EvalFIN(" << Util::getInstName(eit->first->getInst())
		<< ")" << std::endl;
	    std::cout << "New_slack:" << slack << "-CurrSlack:" 
		<< eit->second  << std::endl;
	}
    }*/
    
    //Verify Timing
    TimeType slack = timing->getWorstSlack(); 
    commit = isValidTiming(0,slack,0);
    /*for(BoundingMap::iterator eit=eval.begin();
	    eit!=eval.end(); ++eit){
	//TimeType slack = ut.getIOSlack(eit->first,design,timing,OUTPUT); 
	//if(arr > eit->second){
	    TimeType slack = timing->getWorstSlack(); 
	    commit = isValidTiming(0,slack,eit->second);
	    if(!commit){
		std::cout << "Move Reversed on EvalFO(" << Util::getInstName(eit->first)
		    << ")" << std::endl;
		std::cout << "New_Arr:" << arr << "-CurrArr:" 
		    << eit->second << " - WorstSlack:" << slack << std::endl;
	    }
	//}
    }*/
     
    /*if(commit){ 
	std::cout << "Move TAKEN" << std::endl;
	ph->print();
	//printTimingData(list_timing_before_swap);
	std::cout << "Taken Swap List" << std::endl;
	printCombinations(list);
	std::cout << "SLACK:" << slack << std::endl;
	//printTimingData(list_timing_after_swap);
    }*/
    //instVector currListInstances;
    int NumOfSwapChange = 0;
    for(CellSizingMap::iterator sit=_s.begin();
	    sit!=_s.end(); ++sit){
	CellData *cell = CellData::get(sit->first);
	assert(cell);
	if(!commit){
	    cell->reverseSwap();
	    ut.invalidateFanIOTiming(design,timing,sit->first);
	}else{
	    //Must be check before commiting swap
	    if(cell->isDiffThanCurrSize()){
		NumOfSwapChange++;
		//currListInstances.push_back(sit->first);
		cell->isMark = true;
	    }
	    cell->commitSwap(sit->first);
	}
    }
    //++totalNumOfTrials;
    //++numOfTrials;
    if(!commit){
	//std::cout << "Reversing Swap\n" << std::endl;
	//ph->print();
	timing->updateAll();
	return false;
    }else{
	++numOfTaken;
	++totalNumOfTaken;
	++curr_counter;
	if(NumOfSwapChange == 0) ++numOfZeroOPTMove; 
	else if(NumOfSwapChange == 1) ++numOfOneOPTMove;
	else if(NumOfSwapChange == 2) ++numOfTwoOPTMove;
	any_move_taken = true;
	currPHMoveTaken = true;
	//ph->update();
	//markVisited(currListInstances);
	//std::cout << "Committing Swap\n" << std::endl;
	//flag = true;
	return true;
    }
}
/*---------------------------------------------------------*/
void
Opt::getUpSizeSensitivities(CellData *c){
    vector<oaString> size_vec = c->getGreaterThanCurrentSize();
    for(vector<oaString>::iterator it=size_vec.begin();
	    it!=size_vec.end(); ++it){
	oaOccInst *occInst = DesignTool::getOccInst(design,c->inst);
	oaOccInstTerm *outInstTerm = DesignTool::getOccOutInstTerm(occInst);
	DelayType currSlack = timing->getSlack(outInstTerm);
	//float currLeakage = ut.getCellLeakage(c->inst);
	/* Swap and update timing*/
	c->swap(*it);
	ut.invalidateFanIOTiming(design,timing,c->inst);
	timing->updateAll();

	DelayType newSlack = timing->getSlack(outInstTerm);
	//float newLeakage = ut.getCellLeakage(c->inst);
	/* ReverseSwap and update timing*/
	c->reverseSwap();
	ut.invalidateFanIOTiming(design,timing,c->inst);
	timing->updateAll();

	DelayType deltaSlack = currSlack - newSlack; 
	sensitivityData s;
	s.inst = occInst;
	s.otherLibCellSize = *it;
	s.sensitivity = deltaSlack;
	if(deltaSlack > 0) continue;
	upsized_sensitivity_Insts.push_back(s);
    }
}
/*---------------------------------------------------------*/
double
Opt::getDownSizeDelaySensitivity(CellData *c){
    vector<oaString> size_vec = c->getLessThanCurrentSize();
    if(size_vec.empty()) return DBL_MAX;

    /* Query Output Slack */
    oaOccInst *occInst = DesignTool::getOccInst(design,c->inst);
    oaOccInstTerm *outInstTerm = DesignTool::getOccOutInstTerm(occInst);
    DelayType currSlack = timing->getSlack(outInstTerm);
    vector<oaString>::iterator it=size_vec.begin();
    oaModule* topCell = DesignTool::getCellTopMod(*it);
    assert(topCell);
    oaModTerm *outTerm;
    oaIter<oaModTerm> termIter = topCell->getTerms();
    while(oaModTerm *term = termIter.getNext()){
	oaTermType type(term->getTermType());
	if(type == oacOutputTermType){
	    outTerm = term;
	}
    }
    TPointMaster *new_tm = TPointMaster::get(outTerm);
    assert(new_tm);
    DelayType dDelay = Util::getDeltaDelay(outInstTerm,new_tm,timing);
    double sensitivity = currSlack-dDelay;
    //if(sensitivity < 0) return DBL_MAX;
    /*std::cout << "Inst:" << c->instName << " from:" << c->master->name << " to:" << *it << std::endl;
    std::cout << "Delta Delay:" << dDelay 
	<< " Current SLack:" << currSlack 
	<< " Sensitivity:" << sensitivity << std::endl;*/
    return sensitivity;
}
/*---------------------------------------------------------*/
double
Opt::getDownSizeSensitivities(CellData *c){
    vector<oaString> size_vec = c->getLessThanCurrentSize();
    /* Query Output Slack */
    oaOccInst *occInst = DesignTool::getOccInst(design,c->inst);
    oaOccInstTerm *outInstTerm = DesignTool::getOccOutInstTerm(occInst);
    DelayType currSlack = timing->getSlack(outInstTerm);
    //for(vector<oaString>::iterator it=size_vec.begin();
	    //it!=size_vec.end(); ++it){
    vector<oaString>::iterator it=size_vec.begin();
    /*std::cout << "Inst:" << c->instName << " " 
	<< c->master->name << ":" << *it << std::endl;*/
    oaModule* topCell = DesignTool::getCellTopMod(*it);
    assert(topCell);
    oaModTerm *outTerm;
    oaIter<oaModTerm> termIter = topCell->getTerms();
    while(oaModTerm *term = termIter.getNext()){
	oaTermType type(term->getTermType());
	if(type == oacOutputTermType){
	    outTerm = term;
	}
    }
    TPointMaster *new_tm = TPointMaster::get(outTerm);
    assert(new_tm);
    DelayType s = Util::getDeltaDelay(outInstTerm,new_tm,timing);
    if(s>currSlack) return DBL_MAX;
    double new_leakage = Util::getCellLeakagePower(*it);
    double curr_leakage = c->master->leakage_power;
    double sensitivity = s/fabs(new_leakage-curr_leakage);
    //double sensitivity = fabs(new_leakage-curr_leakage)/s;
    //std::cout << "  Sensitivity:" << sensitivity << std::endl;
    return sensitivity;
    //}
}
/*---------------------------------------------------------*/
double 
Opt::getInInstTermSlack(oaModInst* inst){
    oaOccInst* occInst = DesignTool::getOccInst(design,inst);
    double min_slack = DBL_MAX; 
    oaIter<oaOccInstTerm> iTermIter = occInst->getInstTerms();
    while(oaOccInstTerm *iTerm = iTermIter.getNext()){
	oaTermType type(iTerm->getTerm()->getTermType());
	if(type == oacInputTermType){
	    double currSlack = timing->getSlack(iTerm);
	    if(currSlack < min_slack) min_slack = currSlack;
	}
    }
    return min_slack;
}
/*---------------------------------------------------------*/
bool
Opt::validComb(float val){
    if(val >= ph->getLeakage()) return false;
    return true;
    /*switch (mode){
	case IMPROVING:
	    if(val >= ph->getLeakage()) return false;
	    break;
	case NON_IMPROVING:
	    if(val > ph->getLeakage()) return false;
	    break;
	case TRANSITIVE_CHECK:
	    if(val > ph->getLeakage()) return false;
	    break;
	default:
	    break;
    }*/
}
/*---------------------------------------------------------*/
bool
Opt::isValidTiming(TimeType new_arr, TimeType new_slack, double curr_arr){
    if(new_slack < 0) return false;
    return true;
}
/*---------------------------------------------------------*/
bool
Opt::isVisited(oaModInst* inst){
#if defined(DEBUG)
    std::cout << "isVisited()" << std::endl;
#endif
    instVector::iterator iter;
    iter = find(takenSwapInstsChecklist.begin(), takenSwapInstsChecklist.end(), inst);
    if(iter != takenSwapInstsChecklist.end()){
	return true;
    }
    return false;
}
/*---------------------------------------------------------*/
bool
Opt::isAllVisited(vector<oaModInst*> insts){
#if defined(DEBUG)
    std::cout << "isAllVisited()" << std::endl;
#endif
    instVector::iterator iter;
    for(vector<oaModInst*>::iterator it=insts.begin();
	    it!=insts.end(); ++it){
	iter = find(takenSwapInstsChecklist.begin(), takenSwapInstsChecklist.end(), *it);
	if(iter == takenSwapInstsChecklist.end()){
	    return false;
	}
    }
    return true;
}
/*---------------------------------------------------------*/
bool
Opt::isFanoutMarked(instVector insts){
#if defined(DEBUG)
    std::cout << "isFanoutMarked()" << std::endl;
#endif
    if(insts.empty()){ 
	std::cout << "Empty swap list for check" << std::endl;
    }
    instVector::iterator foListIter;
    for(instVector::iterator it=insts.begin();
	    it!=insts.end(); ++it){
	foListIter = find(PeepholeChecklist.begin(),
		PeepholeChecklist.end(), *it);
	if(foListIter != PeepholeChecklist.end())
	    return true;
    }
    return false;
}
/*---------------------------------------------------------*/
void 
Opt::markSwappedFanouts(instVector insts){
#if defined(DEBUG)
    std::cout << "markVisitedFanout()" << std::endl;
#endif
    if(insts.empty()){ 
	std::cout << "Empty swap list for marking" << std::endl;
	return;
    }
    instVector::iterator foListIter;
    for(instVector::iterator it=insts.begin();
	    it!=insts.end(); ++it){
	foListIter = find(PeepholeChecklist.begin(),
		PeepholeChecklist.end(), *it);
	if(foListIter == PeepholeChecklist.end())
	    PeepholeChecklist.push_back(*it);
    }
}
/*---------------------------------------------------------*/
void 
Opt::markVisited(vector<oaModInst*> insts){
#if defined(DEBUG)
    std::cout << "markVisited()" << std::endl;
#endif
    instVector::iterator iter;
    for(vector<oaModInst*>::iterator it=insts.begin();
	    it!=insts.end(); ++it){
	iter = find(takenSwapInstsChecklist.begin(), takenSwapInstsChecklist.end(), *it);
	if(iter == takenSwapInstsChecklist.end()){
	    takenSwapInstsChecklist.push_back(*it);
	}
    }
}
/*---------------------------------------------------------*/
void
Opt::initDesign(){
#if defined(DEBUG)
    std::cout << "initDesign()" << std::endl;
#endif
    oaModule *mod = design->getTopModule();
    assert(mod);
    oaIter<oaModInst> modIter ( mod->getInsts());
    while(oaModInst *modInst = modIter.getNext()){
	CellData *cell = CellData::get(modInst);
	assert(cell);
	if(cell->master->isSequential) continue;
	sizedRootNodeCount[modInst] = 0; 
    }
    takenFanoutCounter.resize(10);
    //querySensitivities();
}
/*---------------------------------------------------------*/
/* getDownSizeSensitivites function changed
 * */
void
Opt::querySensitivities(){
#if defined(DEBUG)
    std::cout << "querySensitivities()" << std::endl;
#endif
    /*
    if(!sensitivity_sorted_Insts.empty()) 
	sensitivity_sorted_Insts.clear();
    if(!upsized_sensitivity_Insts.empty())
	upsized_sensitivity_Insts.clear();
    if(!downsized_sensitivity_Insts.empty())
	downsized_sensitivity_Insts.clear();
	*/
    oaModule *mod = design->getTopModule();
    assert(mod);
    oaIter<oaModInst> modIter ( mod->getInsts());
    while(oaModInst *modInst = modIter.getNext()){
	CellData *cell = CellData::get(modInst);
	assert(cell);
	cell->initSizing(sizingSignal(ALL_SIZE));
	if(cell->getDownSizeCount()){
	    getDownSizeSensitivities(cell);
	}
	/*
	if(cell->getUpSizeCount()){
	    getUpSizeSensitivities(cell);
	}*/
    }
    /*
    sort(sensitivity_sorted_Insts.begin(), sensitivity_sorted_Insts.end(), incr_slack_func);
    sort(upsized_sensitivity_Insts.begin(), upsized_sensitivity_Insts.end(), incr_slack_func);
    downsized_sensitivity_Insts = sensitivity_sorted_Insts;;
    printSensitivityList();
    */
}
/*---------------------------------------------------------*/
void
Opt::initDataStruct(SizingData &_data){
#if defined(DEBUG)
    std::cout << "initDataStruct()" << std::endl;
#endif
    _data.sizes.clear();
    _data.leakage = 0;
}
/*---------------------------------------------------------*/
void
Opt::clearContainers(){
    design_Insts.clear();
    takenSwapInstsChecklist.clear();
    design_Insts_type2.clear();
    sensitivity_sorted_Insts.clear();
    upsized_sensitivity_Insts.clear();
    downsized_sensitivity_Insts.clear();
    takenFanoutCounter.clear();
    PeepholeChecklist.clear();
    multiLevelRootInstances.clear();
}
/* FOR DEBUG ONLY */
/*---------------------------------------------------------*/
/*
void
Opt::printVisitedCells(){
    oaNativeNS NS;
    oaString s;
    map<oaModInst*,int>::iterator mt;
    std::cout << "Visited Cells: " << std::endl;
    for (mt=visitedCells.begin(); 
	    mt!=visitedCells.end();++mt){
	if(mt->second == 1){
	    oaModInst* modinst = mt->first;
	    std::cout << "  " << (modinst->getName(NS,s),s);
	}
    }
    std::cout << "\n";
}*/
/*---------------------------------------------------------*/
void
Opt::printCombinations(SizingData _s){
    std::cout << "** Combinations for current Peephole Mode:"
	<< mode << " **" << std::endl;

    //ph->print();
    for(CellSizingMap::reverse_iterator it=_s.sizes.rbegin();
	    it!=_s.sizes.rend(); ++it){
	CellData *cell = CellData::get(it->first);
	std::cout << "Inst:" << Util::getInstName(it->first)
	    << " Curr-" << cell->master->name << ":" 
	    << cell->master->leakage_power
	    << " New-" << it->second << ":" << Util::getCellLeakagePower(it->second)
	    << std::endl;
    }
    std::cout << "Leakage Power:" << _s.leakage << std::endl;
//    std::cout << std::endl;
}
/*---------------------------------------------------------*/
void
Opt::printAllFanouts(vector<InstsMap> vm){
    std::cout << "ALL TRANS FANOUTS:" << std::endl;
    int i = 0;
    for(vector<InstsMap>::iterator iter=vm.begin();
	    iter != vm.end(); ++iter){
	std::cout << " Level:" << ++i << std::endl;
	for(InstsMap::iterator im_iter = iter->begin();
		im_iter!=iter->end(); ++im_iter){
	    std::cout << "  " << Util::getInstName(im_iter->first) << std::endl;
	}
    }
    
}
/*---------------------------------------------------------*/
void
Opt::printKOptTable(oaModInst* h, vector<instVector> T){
    std::cout << "ALL k-OPT COMBINATIONS FOR CURRENT LEVEL:" << std::endl;
    int i = 0;
    for(vector<instVector>::iterator iter=T.begin();
	    iter != T.end(); ++iter){
	std::cout << "Head:" << Util::getInstName(h);
	for(instVector::iterator im_iter = iter->begin();
		im_iter!=iter->end(); ++im_iter){
	    std::cout << "  " << Util::getInstName(*im_iter);
	}
	std::cout << "\n";
    }
}
/*---------------------------------------------------------*/
void
Opt::printRootNodeSorting(vector<instTimingData> data_vector, int type){
    std::cout << "Root Node Sorting" << std::endl;
    vector<instTimingData>::iterator it;
    for(it=data_vector.begin(); it!=data_vector.end(); ++it){
	instTimingData data = *it; 
	std::cout << Util::getInstName(data.inst);
	//if(type == 1){
	    std::cout << " input slack:" << data.out_Slack;
	//}else if(type == 2){
	    std::cout << " input slew:" <<  data.out_Slew;
	//}else if(type == 3){
	    std::cout << " fanout weight:" << data.fanoutWeight;
	//}
	    std::cout << " #ofDnSzbleFanout:" << data.downSizeable << std::endl;
    }
}
/*---------------------------------------------------------*/
map<oaOccInstTerm*,double> 
Opt::getTimingInformation(vector<oaModInst*> insts){
    //Query timing information before swap is taken
    map<oaOccInstTerm*,double> timing_data;
    for(vector<oaModInst*>::iterator it=insts.begin();
	    it!=insts.end(); ++it){
	oaOccInst* occInst = DesignTool::getOccInst(design,*it);
	oaIter<oaOccInstTerm> itIter = occInst->getInstTerms();
	while(oaOccInstTerm* iTerm = itIter.getNext()){
	    oaTermType type(iTerm->getTerm()->getTermType());
	    if(type == oacInputTermType){
		timing_data[iTerm] = timing->getSlack(iTerm);
	    }else{
		timing_data[iTerm] = timing->getArr(iTerm);
	    }

	}
    }
    return timing_data;
}
/*---------------------------------------------------------*/
void 
Opt::printTimingData(map<oaOccInstTerm*,double> list){
    map<oaOccInstTerm*,double>::reverse_iterator it;
    for(it=list.rbegin(); it!=list.rend(); ++it){
	std::cout << " " << timing->getBlockName(it->first)
	    << ":" << it->second << std::endl;
    }
}
/*---------------------------------------------------------*/
void
Opt::printSensitivityList(){
    std::cout << "DownSize Sorted Sensitivity" << std::endl;
    vector<sensitivityData>::iterator it;
    for(it=downsized_sensitivity_Insts.begin(); it!=downsized_sensitivity_Insts.end(); ++it){
	std::cout << Util::getInstName(it->inst) << " " << ut.getCellName(it->inst) << " "
	    << it->otherLibCellSize << " " << it->sensitivity << std::endl;
    }
    std::cout << "Upsized Sorted Sensitivity" << std::endl;
    for(it=upsized_sensitivity_Insts.begin(); it!=upsized_sensitivity_Insts.end(); ++it){
	std::cout << Util::getInstName(it->inst) << " " << ut.getCellName(it->inst) << " "
	    << it->otherLibCellSize << " " << it->sensitivity << std::endl;
    }
}
/*---------------------------------------------------------*/
}//namespace
