/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: Zhong Xiu <zxiu@andrew.cmu.edu>

ChangeLog:
2004-09-15: ChangeLog started
*/

#if !defined(oagTimerLibData_P)
#define oagTimerLibData_P

#include <map>
#include <set>
#include <vector>
#include <string.h>
#include <string>
//#include <oaName.h>

#include "oaDesignDB.h"
#include "oagTimerModel.h"

using namespace oa;
using namespace std;
using namespace oagTimer;

namespace oagTimer {
typedef vector<double> Index;
typedef vector<oaString> libDataVector; 
/*! This structure collects all the data from lookup table template */
struct lutData{
    string v1;
    string v2;
    Index index1;
    Index index2;
};

typedef map<string,lutData> luTableMap;

/*! This class collects all the necessary data for the .lib library. */
class LibData {
  public:
    /*! The constructor, initiate all the members. */
    LibData() {
      cellScope = false;
      currentTimingSense = 0;
      isClock = false;
      currentLoadLimit = 0.0;
      currentRiseDelayModel = currentRiseSlewModel = currentRiseConsModel = currentRisePowerModel = 0;
      currentFallDelayModel = currentFallSlewModel = currentFallConsModel = currentFallPowerModel = 0;
      currentCellFootprint = NULL;
      
    }
    /*! The destructor, clear the data. */
    ~LibData() { clear(); }

    /*! This function cleans the data. */
    void clear();

  private:
    /*! This function sets cell scope to be false. */
    void endCellScope();

  public:
    /*! This is the library name. */
    oaString libString;
    /*! Name of view to annotate. */
    oaString viewString;
    /*! Cell Name in the library. */
    libDataVector libCellNames;
    /*! Library specific name convention*/
    std::string libType;

    /*! indicates the pin type: input, output */
    std::string currentPinDir; 
    std::string var1;
    std::string var2;
    /*! indicates the order of the two axes */
    bool order;
    /*! indicates the order of the two axes in DFFs */
    bool ffOrder; 
    /*! indicates the order of the two axes of Power */
    bool powerOrder;
    /*! the current pin's name */
    char *currentPinName; 
    /*! the current related pin's name */
    char *currentRelatedPin; 
    /*! the current timing sense */
    int currentTimingSense; 
    /*! the current timing type */
    int currentTimingType; 
    /*! the current pin's capacitance */
    double currentPinCap; 
    /*! the current pin's load limit */
    double currentLoadLimit; 
    /*! the current timing model */
    TimerModel currentModel; 
    /*! the current rise delay model */
    const TimerModel *currentRiseDelayModel; 
    /*! the current rise slew model */
    const TimerModel *currentRiseSlewModel;  
    /*! the current fall delay model */
    const TimerModel *currentFallDelayModel; 
    /*! the current fall slew model */
    const TimerModel *currentFallSlewModel;  
    /*! the current rise constraint model */
    const TimerModel *currentRiseConsModel;  
    /*! the current fall constraint model */
    const TimerModel *currentFallConsModel;
    /*! the current rise power model */
    const TimerModel *currentRisePowerModel;  
    /*! the current fall power model */
    const TimerModel *currentFallPowerModel;
   
    /*NEW CODE*/
    /*! the current cell area */
    double currentCellArea;
    /*! the current cell leakage power */
    double currentCellLeakPwr;
    /*! the current cell's footprint */
    char *currentCellFootprint;
    /*! the power unit */
    char *powerUnit;
    /*! the time unit */
    char *tUnit;
    /*! the cap unit*/
    char *capUnit;
    /*Slew lower threshold fall*/
    double slew_low_fall;
    /*Slew lower threshold rise*/
    double slew_low_rise;
    /*Slew high threshold fall*/
    double slew_high_fall;
    /*Slew high threshold rise*/
    double slew_high_rise;
    
    int pushPowerUnit(const char *s);
    int pushTimeUnit(const char *s);
    int pushCapUnit(const char *s);
    int pushThresVal(double d, int pct, int slope);
    /*END NEW CODE */

    int pushPin(const char *s);
    int pushCellFootprintName(const char *s);
    int pushCurrentPinName(const char *s);
    int pushPinDir(const char *s);
    int pushTimingSense(const char *s);
    int pushTimingType(const char *s);
    int pushRelatedPin(const char *s);

    int pushCell(const char *s);
    int pushCellFall();
    int pushCellRise();
    int pushFallTran();
    int pushRiseTran();
    int pushFallCons();
    int pushRiseCons();
    int pushPath();
    int pushRisePower();
    int pushFallPower();

    int pushVar1(const char *s);
    int pushVar2(const char *s);
    int pushAxisOrder();
    void pushTempAxis();
    //void pushTempAxis2();
    int pushAxis1(double d);
    int pushAxis2(double d);
    int pushFFAxis1(double d);
    int pushFFAxis2(double d);
    int pushPowerAxis1(double d);
    int pushPowerAxis2(double d);
   
    int pushTable(const char *s);
    int pushTableAxis1(double d);
    int pushTableAxis2(double d);
    void findIndex(const char *s);
    typedef vector<double> axisVector;

  private:
    /*! this flag indicates if it's in the cell scope */
    bool cellScope; 

    /*! masterAppDef : myAppDef for oaTimingPointMaster */
    static oaVoidPointerAppDef<oaTerm> *masterAppDef; 

  public:
    /*! This function sets the cellScope to be true. */
    void beginCellScope() { 
      cellScope = true;
#if defined(DEBUG)
      std::cout<< "begin" << std::endl; 
#endif
    }

  private:
    /*! this flag indicates if the current pin is a clock pin */
    bool isClock; 

  public:
    /*! This function sets the isClock flag to be true. */
    void pushClock() { 
      isClock = true; 
#if defined(DEBUG)
      std::cout<< "push clock" << std::endl; 
#endif
    }

  private:
    /*! the current pins' vector of a cell */
    pinDataVector currentPins; 
    /*! the current paths' vector of a pin */
    pathDataVector currentPaths; 
    /*! lookup table data map */
    luTableMap luTable;
    /*! Temporary container for index_1 and index_2 table */
    axisVector axis1;
    axisVector axis2;
    /*! state indicate where to push the axis */
    int state;

};

}

#endif
