/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: Zhong Xiu <zxiu@andrew.cmu.edu>

ChangeLog:
2004-09-15: ChangeLog started
*/

#include <map>
#include <vector>
#include <assert.h>
#include <iostream>
#include <string.h>
#include "oaDesignDB.h"

#include "oagTimerCellMaster.h"
#include "oagTimerTPointMaster.h"
#include "oagTimerTimer.h"
#include "oagTimerLibData.h"

//#define DEBUG

namespace oagTimer {

//-----------------------------------------------------------------------------

// Static vars

//oaVoidPointerAppDef<oaTerm> *LibData::masterAppDef; 

//-----------------------------------------------------------------------------

void
LibData::clear() {
 #if defined(DEBUG)
  cout << "Destructor" << endl;
#endif
  endCellScope();
  luTable.clear();
  axis1.clear();
  axis2.clear();

  }

//-----------------------------------------------------------------------------

void
LibData::endCellScope() {
#if defined(DEBUG)
  std::cout << "endCellScope()" << std::endl;
#endif
  for(pinDataVector::iterator i = currentPins.begin();
      i != currentPins.end(); ++i) {
    delete[] i->name;
  }
  currentPins.clear();
  for(pathDataVector::iterator i = currentPaths.begin();
      i != currentPaths.end(); ++i) {
    delete[] i->src;
    delete[] i->dst;
  }
  currentPaths.clear();
  cellScope = false;
}

//-----------------------------------------------------------------------------

/*! Store the first Axis' name. */
int
LibData::pushVar1(const char *s) {
#if defined(DEBUG)
  std::cout << "pushVar1" << std::endl;
#endif
  var1 = s;
  return 0;
}

//-----------------------------------------------------------------------------

/*! Store the second Axis' name. */
int
LibData::pushVar2(const char *s) {
#if defined(DEBUG)
  std::cout << "pushVar2" << std::endl;
#endif
  var2 = s;
  return 0;
}

//-----------------------------------------------------------------------------

/*! Set the order of the axes and the order of the DFF's axes order and the
 order of the Power. */
int
LibData::pushAxisOrder() {
#if defined(DEBUG)
  std::cout << "pushAxisOrder" << std::endl;
#endif
state = 0;
  if (var1 == "input_net_transition" && var2 == "total_output_net_capacitance") {
    order = true;
    state = 1;
  }
  if (var1 == "input_net_transition" && var2.empty()) {
    order = true;
    state = 1;
  }
  if (var2 == "input_net_transition" && var1 == "total_output_net_capacitance") {
    order = false;
    state = 1; 
  }
  if (var1 == "constrained_pin_transition" && var2 == "related_pin_transition") {
    ffOrder = true;
    state = 2;
  }
  if (var2 == "constrained_pin_transition" && var1 == "related_pin_transition") {
    ffOrder = false;
    state = 2;
  }
  if (var1 == "input_transition_time" && var2 == "total_output_net_capacitance") {
    powerOrder = true;
    state = 3;
  }
  if (var2 == "input_transition_time" && var1 == "total_output_net_capacitance") {
    powerOrder = false;
    state = 3;
  }

  return 0;
}

//-----------------------------------------------------------------------------
/*! Push the template data into axis1 */
void
LibData::pushTempAxis(){
#if defined(DEBUG)
    std::cout << "pushtTempAxis1 , state:" << state << endl;
#endif
axisVector::iterator iter;
if (state == 1){ 
    for(iter = axis1.begin(); iter != axis1.end(); ++iter){
	    pushAxis1(*iter);
    }  
    for(iter = axis2.begin(); iter != axis2.end(); ++iter){
	    pushAxis2(*iter);
    } 
}
if (state == 2){ 
    for(iter = axis1.begin(); iter != axis1.end(); ++iter){
	    pushFFAxis1(*iter);
    }
    for(iter = axis2.begin(); iter != axis2.end(); ++iter){
	    pushFFAxis2(*iter);
    }
}
if (state == 3){ 
    for(iter = axis1.begin(); iter != axis1.end(); ++iter){
	    pushPowerAxis1(*iter);
    }
    for(iter = axis2.begin(); iter != axis2.end(); ++iter){
	    pushPowerAxis2(*iter);
    } 
}

}

//-----------------------------------------------------------------------------
/*! Push the template data into axis2 */
/*
void
LibData::pushTempAxis2(){
#if defined(DEBUG)
    std::cout << "pushtTempAxis2 , state:" << state << endl;
#endif
axisVector::iterator iter;
if (state == 1){ 
    for(iter = axis2.begin(); iter != axis2.end(); ++iter){
	    pushAxis2(*iter);
    }  
}
if (state == 2){ 
    for(iter = axis2.begin(); iter != axis2.end(); ++iter){
	    pushFFAxis2(*iter);
    }  
}
if (state == 3){ 
    for(iter = axis2.begin(); iter != axis2.end(); ++iter){
	    pushPowerAxis2(*iter);
    }  
}

}
*/
//-----------------------------------------------------------------------------

/*! Push all the data in the first axis. */
int
LibData::pushAxis1(double d) {
#if defined(DEBUG)
    cout << " Push Axis1" << endl;
#endif
  if (order) currentModel.pushSlewAxis(d);
  else currentModel.pushLoadAxis(d);
  return 0;
}

//-----------------------------------------------------------------------------

/*! Push all the data in the second axis. */
int
LibData::pushAxis2(double d) {
#if defined(DEBUG)
    cout << " Push Axis2" << endl;
#endif
  if (order) currentModel.pushLoadAxis(d);
  else currentModel.pushSlewAxis(d);
  return 0;
}

//-----------------------------------------------------------------------------

/*! Push all the data in the first DFF's axis. */
int
LibData::pushFFAxis1(double d) {
  if (ffOrder) currentModel.pushSlewAxis(d);
  else currentModel.pushLoadAxis(d);
  return 0;
}

//-----------------------------------------------------------------------------

/*! Push all the data in the second DFF's axis. */
int
LibData::pushFFAxis2(double d) {
  if (ffOrder) currentModel.pushLoadAxis(d);
  else currentModel.pushSlewAxis(d);
  return 0;
}

//-----------------------------------------------------------------------------

/*! Push all the data in the first Power's axis. */
int
LibData::pushPowerAxis1(double d) {
  if (powerOrder) currentModel.pushSlewAxis(d);
  else currentModel.pushLoadAxis(d);
  return 0;
}

//-----------------------------------------------------------------------------

/*! Push all the data in the second Power's axis. */
int
LibData::pushPowerAxis2(double d) {
  if (powerOrder) currentModel.pushLoadAxis(d);
  else currentModel.pushSlewAxis(d);
  return 0;
}


//-----------------------------------------------------------------------------

/*! Push all the paths of the current pin. */
int
LibData::pushPath() {
#if defined(DEBUG)
  std::cout << "pushPath" << std::endl;
#endif
  // also push paths
  // no paths for input
  // two paths for an output pin
  // be careful with D & clk

  if (currentRiseDelayModel && currentRiseSlewModel) {
#if defined(DEBUG)
    std::cout << "pushRisePath" << std::endl;
#endif
    if (currentTimingSense == 0 && currentTimingType == 0) {
      pathData p1, p2;
      p1.src = new char[strlen(currentRelatedPin)+1];
      strcpy(p1.src, currentRelatedPin);
      p1.dst = new char[strlen(currentPinName)+1];
      strcpy(p1.dst, currentPinName);
      p2.src = new char[strlen(currentRelatedPin)+1];
      strcpy(p2.src, currentRelatedPin);
      p2.dst = new char[strlen(currentPinName)+1];
      strcpy(p2.dst, currentPinName);
      p1.delay = currentRiseDelayModel;
      p1.slew = currentRiseSlewModel;
      p2.delay = currentRiseDelayModel;
      p2.slew = currentRiseSlewModel;
      p1.srcTrans = 1;
      p2.srcTrans = 10;
      p1.dstTrans = 1;
      p2.dstTrans = 1;
      currentPaths.push_back(p1);
      currentPaths.push_back(p2);
    }
    else {
      pathData p;
      p.src = new char[strlen(currentRelatedPin)+1];
      strcpy(p.src, currentRelatedPin);
      p.dst = new char[strlen(currentPinName)+1];
      strcpy(p.dst, currentPinName);
      p.delay = currentRiseDelayModel;
      p.slew = currentRiseSlewModel;

      p.dstTrans = 1;

      if (currentTimingSense ==1) p.srcTrans = 1;
      else if (currentTimingSense ==-1) p.srcTrans = 10;
      if (currentTimingType ==1) p.srcTrans = 1;
      else if (currentTimingType ==-1) p.srcTrans = 10;

      currentPaths.push_back(p);
    }
    currentRiseDelayModel = 0;
    currentRiseSlewModel = 0;
  }

  if (currentFallDelayModel && currentFallSlewModel) {
#if defined(DEBUG)
    std::cout << "pushFallPath" << std::endl;
#endif
    if (currentTimingSense == 0 && currentTimingType == 0) {
      pathData p1, p2;
      p1.src = new char[strlen(currentRelatedPin)+1];
      strcpy(p1.src, currentRelatedPin);
      p1.dst = new char[strlen(currentPinName)+1];
      strcpy(p1.dst, currentPinName);
      p2.src = new char[strlen(currentRelatedPin)+1];
      strcpy(p2.src, currentRelatedPin);
      p2.dst = new char[strlen(currentPinName)+1];
      strcpy(p2.dst, currentPinName);
      p1.delay = currentFallDelayModel;
      p1.slew = currentFallSlewModel;
      p2.delay = currentFallDelayModel;
      p2.slew = currentFallSlewModel;
      p1.srcTrans = 1;
      p2.srcTrans = 10;
      p1.dstTrans = 10;
      p2.dstTrans = 10;
      currentPaths.push_back(p1);
      currentPaths.push_back(p2);
    }
    else {
      pathData p;
      p.src = new char[strlen(currentRelatedPin)+1];
      strcpy(p.src, currentRelatedPin);
      p.dst = new char[strlen(currentPinName)+1];
      strcpy(p.dst, currentPinName);
      p.delay = currentFallDelayModel;
      p.slew = currentFallSlewModel;

      p.dstTrans = 10;

      if (currentTimingSense ==1) p.srcTrans = 10;
      else if (currentTimingSense ==-1) p.srcTrans = 1;
      if (currentTimingType ==1) p.srcTrans = 1;
      else if (currentTimingType ==-1) p.srcTrans = 10;

      currentPaths.push_back(p);
    }
    currentFallDelayModel = 0;
    currentFallSlewModel = 0;
  }

  if (currentFallConsModel&&currentTimingType!=0) {
#if defined(DEBUG)
    std::cout << "pushFallCons" << std::endl;
#endif
    pathData p;
    p.src = new char[strlen(currentPinName)+1];
    strcpy(p.src, currentPinName);
    p.dst = new char[strlen(currentRelatedPin)+1];
    strcpy(p.dst, currentRelatedPin);
    p.delay = currentFallConsModel;
    p.slew = 0;

    p.srcTrans = 10;
    if (currentTimingType == 1) p.dstTrans = 1;
    else if (currentTimingType == -1) p.dstTrans = 10;
    currentPaths.push_back(p);
  }
  currentFallConsModel = 0;

  if (currentRiseConsModel&&currentTimingType!=0) {
#if defined(DEBUG)
    std::cout << "pushRiseCons" << std::endl;
#endif
    pathData p;
    p.src = new char[strlen(currentPinName)+1];
    strcpy(p.src, currentPinName);
    p.dst = new char[strlen(currentRelatedPin)+1];
    strcpy(p.dst, currentRelatedPin);
    p.delay = currentRiseConsModel;
    p.slew = 0;

    p.srcTrans = 1;
    if (currentTimingType == 1) p.dstTrans = 1;
    else if (currentTimingType == -1) p.dstTrans = 10;
    currentPaths.push_back(p);
  }
  currentRiseConsModel = 0;
  currentTimingSense = 0;
  currentTimingType = 0;
  return 0;
}  

//-----------------------------------------------------------------------------

/*! Collect all the information of the current pin. */
int
LibData::pushPin(const char *s) {
#if defined(DEBUG)
  std::cout << "pushPin : " << s << std::endl;
#endif
  pinData t;
  t.name = new char[strlen(s)+1];
  strcpy(t.name, s);
  t.cap = currentPinCap;
  t.isClock = isClock;
  t.loadLimit = currentLoadLimit;
  if (currentPinDir != "INTERNAL" && currentPinDir != "internal")
    currentPins.push_back(t);
  isClock = false;
  currentLoadLimit = 0.0;
  currentPinDir = "";
  return 0;
}

//-----------------------------------------------------------------------------

/*! Push the current pin's direction. */
int
LibData::pushPinDir(const char *s) {
#if defined(DEBUG)
  std::cout << "pushPinDir" << std::endl;
#endif
  currentPinDir = s;
  return 0;
}

//-----------------------------------------------------------------------------

/*! Push the current Footprint's name. */
int
LibData::pushCellFootprintName(const char *s) {
#if defined(DEBUG)
  std::cout << "pushCellFootprintName : " << s << std::endl;
#endif
  currentCellFootprint = new char[strlen(s)+1];
  //cout << "pushed cell footprint " << s << endl;  
  strcpy(currentCellFootprint, s);
  return 0;
}


//-----------------------------------------------------------------------------


/*! Push the current pin's name. */
int
LibData::pushCurrentPinName(const char *s) {
#if defined(DEBUG)
  std::cout << "pushCurrentPinName : " << s << std::endl;
#endif
  currentPinName = new char[strlen(s)+1];
  strcpy(currentPinName, s);
  return 0;
}


//-----------------------------------------------------------------------------

/*! Push the related pin's name. */
int
LibData::pushRelatedPin(const char *s) {
#if defined(DEBUG)
  std::cout << "pushRelatedPin : " << s << std::endl;
#endif
  currentRelatedPin = new char[strlen(s)+1];
  strcpy(currentRelatedPin, s);
  return 0;
}

//-----------------------------------------------------------------------------

/*! Push the current timing model's sense. */
int
LibData::pushTimingSense(const char *s) {
#if defined(DEBUG)
  std::cout << "pushTimingSense" << std::endl;
#endif
  std::string ts = s;
  if (ts == "positive_unate") {
    currentTimingSense = 1;
  } else if (ts == "negative_unate") {
    currentTimingSense = -1;
  }
  return 0;
}

//-----------------------------------------------------------------------------

/*! Push the current timing model's type. */
int
LibData::pushTimingType(const char *s) {
#if defined(DEBUG)
  std::cout << "pushTimingType" << std::endl;
#endif
  std::string ts = s;
  if (ts == "recovery_rising" || ts == "removal_rising" ||
      ts == "recovery_falling" || ts == "removal_falling")
  {
    currentTimingType = 0;
    return 0;
  }
  if (ts == "setup_rising" || ts == "hold_rising" || ts == "rising_edge"
      || ts == "recovery_rising" || ts == "removal_rising") {
    currentTimingType = 1;
  } else if (ts == "setup_falling" || ts == "hold_falling" 
          || ts == "falling_edge" || ts == "recovery_falling" 
          || ts == "removal_rising") {
    currentTimingType = -1;
  }
  return 0;
}

//-----------------------------------------------------------------------------

/*! Collect all the information of the current cell. */
int
LibData::pushCell(const char *s) {
  const oaNativeNS nativeNS;
  const oaScalarName libName(nativeNS, libString);
  const oaScalarName cellName(nativeNS, s);
  const oaScalarName viewName(nativeNS, viewString);

#if defined(DEBUG)
  std::cout << "pushCell()" << s << std::endl;
  oaString f;
  libName.get(nativeNS, f);
  std::cout << "libName:" << f << std::endl;
#endif
  oaDesign *cv = oaDesign::open(libName, cellName, viewName, 'r');
  if (!cv) {
    std::cerr << "Failed to open cellview " << s << std::endl;
    return 1;
  }

  oaModule *top = cv->getTopModule();
  if (!top) {
    std::cerr << "Failed to open top module in design" << s << std::endl;
    return 1;
  }

    if (CellMaster::get(top)) {
      std::cerr << "Cell " << s << " already has AppDef value" << std::endl;
      return 1;
    }
    CellMaster *c = CellMaster::create(top);
    assert(c);
    c->area = currentCellArea;
    c->leakage_power = currentCellLeakPwr;
    c->footprint = currentCellFootprint;
    c->setLibCellName(s);
    libCellNames.push_back(c->name);
  for (pinDataVector::const_iterator i = currentPins.begin();
      i != currentPins.end(); ++i) {
#if defined(DEBUG)
    std::cout << "pin" << std::endl;
#endif
    oaScalarName termName(nativeNS, i->name);
    oaModTerm *term = oaModTerm::find(top, termName);
    if (!term) {
      std::cerr << "Term " << i->name << " not found in cellview "
          << s << std::endl;
      return 1;
    }
    if (TPointMaster::get(term)) {
      std::cerr << "Term " << i->name << " in cellview "
          << s << " already has AppDef value" << std::endl;
      return 1;
    }
    TPointMaster *p = TPointMaster::create(term);
    assert(p);
    p->cap = i->cap;
    p->loadLimit = i->loadLimit;
    assert(TPointMaster::get(term)->cap == i->cap);
    
    if (i->isClock) {
      oaModNet *net = term->getNet();
      assert(net);
      net->setSigType(oacClockSigType);
      c->isSequential = true;
    }
  }

  for (pathDataVector::const_iterator i = currentPaths.begin();
      i != currentPaths.end(); ++i) {
#if defined(DEBUG)
    std::cout << "path" << std::endl;
#endif
    oaScalarName srcName(nativeNS, i->src);
    oaModTerm *srcTerm = oaModTerm::find(top, srcName);
    if (!srcTerm) {
      std::cerr << "Term " << i->src << " not found in cellview "
          << s << std::endl;
      return 1;
    }
    TPointMaster *srcP = TPointMaster::get(srcTerm);
    if (!srcP) {
      std::cerr << "Term " << i->src << " in cellview "
          << s << " has no AppDef value" << std::endl;
      return 1;
    }

    oaScalarName dstName(nativeNS, i->dst);
    oaModTerm *dstTerm = oaModTerm::find(top, dstName);
    if (!dstTerm) {
      std::cerr << "Term " << i->dst << " not found in cellview "
          << s << std::endl;
      return 1;
    }
    TPointMaster *dstP = TPointMaster::get(dstTerm);
    if (!dstP) {
      std::cerr << "Term " << i->dst << " in cellview "
          << s << " has no AppDef value" << std::endl;
      return 1;
    }

    int trans = 0;
    if (i->srcTrans == 1) {
      trans |= TPointMaster::TRANSITION_SRC_RISE;
    }
    else if (i->srcTrans == 10) {
      trans |= TPointMaster::TRANSITION_SRC_FALL;
    }
    if (i->dstTrans == 1) {
      trans |= TPointMaster::TRANSITION_DST_RISE;
    }
    else if (i->dstTrans == 10) {
      trans |= TPointMaster::TRANSITION_DST_FALL;
    }
#if defined(DEBUG)
    std::cout << s << " added path " << i->src << " to " << i->dst << " srcTrans "
      << i->srcTrans << " dstTrans " << i->dstTrans << std::endl;

#endif
    srcP->addOutPath(dstTerm, i->delay, i->slew, trans);
    dstP->addInPath(srcTerm, i->delay, i->slew, trans);
  }

#if defined(DEBUG)
#if 0
  for(oaIter<oaModTerm> i = top->getTerms(); oaModTerm *term = i.getNext(); ) {
    TPointMaster *tpm = TPointMaster::get(term);
    for(TPointMaster::pathDataVector::iterator j = tpm->inPaths.begin();
        j != tpm->inPaths.end(); ++j) {
      std::cout << "one path" << std::endl;
    }
  }
#endif
#endif

  endCellScope();
  return 0;
}

//-----------------------------------------------------------------------------
/*! Push the slew threshold value */
#define LOW 0
#define HIGH 1
#define FALL -1
#define RISE 1
int
LibData::pushThresVal(double d, int pct, int slope){
#if defined(DEBUG)
  std::cout << "pushThres" << std::endl;
#endif
    if(pct == LOW){
	if(slope == FALL)
	    slew_low_fall = d;
	else if(slope == RISE)
	    slew_low_rise = d;
    }else if(pct == HIGH){
	if(slope == FALL)
	    slew_high_fall = d;
	else if(slope == RISE)
	    slew_high_rise = d;
    }
    return 0;
}

//-----------------------------------------------------------------------------

/*! Push the rise delay model. */
int
LibData::pushCellRise() {
#if defined(DEBUG)
  std::cout << "pushCellRise" << std::endl;
#endif
  if (currentRiseDelayModel) {
    std::cerr << "Duplicate rise delay model " << std::endl;
    return 1;
  }
  currentRiseDelayModel = new TimerModel(currentModel);
  currentModel.clear();
  return 0;
}

//-----------------------------------------------------------------------------

/*! Push the rise transition model. */
int
LibData::pushRiseTran() {
#if defined(DEBUG)
  std::cout << "pushRiseTran" << std::endl;
#endif
  if (currentRiseSlewModel) {
    std::cerr << "Duplicate rise slew model " << std::endl;
    return 1;
  }
  currentRiseSlewModel = new TimerModel(currentModel);
  currentModel.clear();
  return 0;
}

//-----------------------------------------------------------------------------

/*! Push the fall delay model. */
int
LibData::pushCellFall() {
#if defined(DEBUG)
  std::cout << "pushCellFall" << std::endl;
#endif
  if (currentFallDelayModel) {
    std::cerr << "Duplicate fall delay model " << std::endl;
    return 1;
  }
  currentFallDelayModel = new TimerModel(currentModel);
  currentModel.clear();
  return 0;
}

//-----------------------------------------------------------------------------

/*! Push the fall transition model. */
int
LibData::pushFallTran() {
#if defined(DEBUG)
  std::cout << "pushFallTran" << std::endl;
#endif
  if (currentFallSlewModel) {
    std::cerr << "Duplicate fall slew model " << std::endl;
    return 1;
  }
  currentFallSlewModel = new TimerModel(currentModel);
  currentModel.clear();
  return 0;
}

//-----------------------------------------------------------------------------

/*! Push the rise constraint model. */
int
LibData::pushRiseCons() {
#if defined(DEBUG)
  std::cout << "pushRiseCons" << std::endl;
#endif
  if (currentRiseConsModel) {
    std::cerr << "Duplicate rise cons model " << std::endl;
    return 1;
  }
  currentRiseConsModel = new TimerModel(currentModel);
  currentModel.clear();
  return 0;
}

//-----------------------------------------------------------------------------

/*! Push the fall constraint model. */
int
LibData::pushFallCons() {
#if defined(DEBUG)
  std::cout << "pushFallCons" << std::endl;
#endif
  if (currentFallConsModel) {
    std::cerr << "Duplicate fall cons model " << std::endl;
    return 1;
  }
  currentFallConsModel = new TimerModel(currentModel);
  currentModel.clear();
  return 0;
}

//-----------------------------------------------------------------------------

/*! Push the rise power model. */
int
LibData::pushRisePower() {
#if defined(DEBUG)
  std::cout << "pushRisePower" << std::endl;
#endif
  if (currentRisePowerModel) {
    std::cerr << "Duplicate rise power model " << std::endl;
    return 1;
  }
  currentRisePowerModel = new TimerModel(currentModel);
  currentModel.clear();
  return 0;
}


//-----------------------------------------------------------------------------

/*! Push the fall power model. */
int
LibData::pushFallPower() {
#if defined(DEBUG)
  std::cout << "pushFallPower" << std::endl;
#endif
  if (currentFallPowerModel) {
    std::cerr << "Duplicate fall power model " << std::endl;
    return 1;
  }
  currentFallPowerModel = new TimerModel(currentModel);
  currentModel.clear();
  return 0;
}

//-----------------------------------------------------------------------------

/*! Push the Time Unit */
int 
LibData::pushTimeUnit(const char *s){
#if defined(DEBUG)
    std::cout << "pushTimeUnit : " << s << std::endl;
#endif
    tUnit = new char[strlen(s)+1];
    strcpy(tUnit,s);
    return 0;
}
//-----------------------------------------------------------------------------

//*! Push the Cap Unit */
int 
LibData::pushCapUnit(const char *s){
#if defined(DEBUG)
    std::cout << "pushCapUnit : " << s << std::endl;
#endif
    capUnit = new char[strlen(s)+1];
    strcpy(capUnit,s);
    return 0;
}
//-----------------------------------------------------------------------------

//*! Push the Power Unit */
int 
LibData::pushPowerUnit(const char *s){
#if defined(DEBUG)
    std::cout << "pushPowerUnit : " << s << std::endl;
#endif
    powerUnit = new char[strlen(s)+1];
    strcpy(powerUnit,s);
    return 0;
}
//-----------------------------------------------------------------------------

/*! Collect all the information of the lookup table. */
int
LibData::pushTable(const char *s) {
#if defined(DEBUG)
  std::cout << "pushTable : " << s << std::endl;
#endif
  lutData t;
  string name = s;
  t.v1 = var1;
  t.v2 = var2;
  t.index1 = axis1;
  t.index2 = axis2;
  luTable.insert( pair<string,lutData>(name, t) );
  var1.clear();
  var2.clear();
  axis1.clear();
  axis2.clear();
  return 0;
}

//-----------------------------------------------------------------------------
int 
LibData::pushTableAxis1(double d){
#if defined(DEBUG)
  std::cout << "pushTableAxis1: " << d << std::endl;
#endif
  axis1.push_back(d);
  return 0;
}

//-----------------------------------------------------------------------------
int 
LibData::pushTableAxis2(double d){
#if defined(DEBUG)
  std::cout << "pushTableAxis2: " << d << std::endl;
#endif
  axis2.push_back(d);
  return 0;
}

//-----------------------------------------------------------------------------
/* Find the indexes in the lookup table and push slew and load axis */
void
LibData::findIndex(const char* s){
#if defined(DEBUG)
  std::cout << "findIndex: " << s << " "; 
#endif
  string ix = s;
  lutData t;
  luTableMap::iterator i;
  /*for(i = luTable.begin(); i != luTable.end(); ++i)
  cout << i->first << (i->second).v1 << endl;
  */
  i = luTable.find(ix);
  if(i != luTable.end()){
  //std::cout << "ITEM FOUND" << std::endl;
  t = i->second;
  }
  axis1.clear();
  axis2.clear();
  axis1 = t.index1;
  axis2 = t.index2;
  
  var1 = t.v1;
  var2 = t.v2;
}
//-----------------------------------------------------------------------------
}

