/************************************************************
* 
* File: oagTimerDesignTool.h
* Author: Santiago Mok (smok@ee.ucla.edu)
* Created: 07-08-2010
* Last Modified: Wed 02 Mar 2011 07:20:39 PM PST
*
************************************************************/
#if !defined(oagTimerDesignTool_P)
#define oagTimerDesignTool_P

#include "oaDesignDB.h"
#include "oagTimerCellData.h"
#include "oagTimerModel.h"
#include "oagTimerUtil.h"
#include "oagTimerLibParserInt.h"

#include <vector>
#include <algorithm>
#include <math.h>

namespace oagTimer{
/*---------------------------------------------------------*/
using namespace oa;
using namespace std;
/*---------------------------------------------------------*/
/* Structure contain:
 * 1) Cell instance
 * 2) Min of all input slack of current inst
 */
struct instTimingData{ 
    oaModInst* inst;
    DelayType out_Slack;
    DelayType out_Slew;
    int downSizeable;
    double fanoutWeight;
};
struct sensitivityData{
    oaOccInst* inst;
    oaString otherLibCellSize;
    double sensitivity;
};
/*---------------------------------------------------------*/
static bool incr_slack_sort (instTimingData a, instTimingData b){
    if(a.out_Slack < b.out_Slack)
	return true;
    else
	return false;
}
/*---------------------------------------------------------*/
static bool decr_slack_sort (instTimingData a, instTimingData b){
    if(a.out_Slack > b.out_Slack)
	return true;
    else
	return false;
}
/*---------------------------------------------------------*/
static bool incr_slew_sort (instTimingData a, instTimingData b){
    if(a.out_Slew < b.out_Slew)
	return true;
    else
	return false;
}
/*---------------------------------------------------------*/
static bool decr_slew_sort (instTimingData a, instTimingData b){
    if(a.out_Slew > b.out_Slew)
	return true;
    else
	return false;
}
/*---------------------------------------------------------*/
static bool incr_fanoutWeight_sort (instTimingData a, instTimingData b){
    if(a.fanoutWeight < b.fanoutWeight)
	return true;
    else
	return false;
}
/*---------------------------------------------------------*/
static bool decr_fanoutWeight_sort (instTimingData a, instTimingData b){
    if(a.fanoutWeight > b.fanoutWeight)
	return true;
    else
	return false;
}
/*---------------------------------------------------------*/
static bool decr_netWeight_sort (netData a, netData b){
    if(a.weight > b.weight)
	return true;
    else
	return false;
}
/*---------------------------------------------------------*/
class DesignTool{
  public: 
    /* Order the mod instance in the 
     * design reverse topologically
     * @param oaDesign*
     * @param Timer*
     * @return vector<oaModInst*>
     */
    static vector<oaModInst*> getReverseTopological(oaDesign* design, Timer *timer);   
    /* Order the mod instance in the 
     * design topologically
     * @param oaDesign*
     * @param Timer*
     * @return vector<oaModInst*>
     */
    static vector<oaModInst*> getTopological(oaDesign* design, Timer *timer);   
    static void buildTopologicalDesign(vector<oaModInst*> &insts, vector<oaModNet*> nets);

    static vector<instTimingData> getIncreasingSlack(oaDesign *design,Timer *timer);
    static vector<instTimingData> getDecreasingSlack(oaDesign *design,Timer *timer);
    static vector<instTimingData> getDecreasingSlew(oaDesign *design,Timer *timer);
    static vector<instTimingData> getDecreasingFanoutWeight(oaDesign *design, Timer *timer, int level);
    static vector<instTimingData> getDecreasingFanoutSlack(oaDesign *design, Timer *timer, int level);

    static vector<instTimingData> getDecreasingFanoutGain(oaDesign *design, Timer *timer, int level);
    /*! Get Instances sorted by net weight*/
    static void getNetWeight(oaDesign *design,Timer *timer);
    static void traverseForwardTopologically(vector<oaOccInst*> &insts,vector<oaOccNet*> nets,
	    Timer* timer);
    static void traverseBackwardTopologically(vector<oaOccInst*> &insts, Timer* timer);
    static double computeWeight(oaOccInstTerm* iTerm, Timer* t);
    static double getPrevTermWeightSum(oaOccInstTerm* iTerm);

    static vector<oaModTerm*> getAllModPI(oaDesign* design);
    static vector<oaOccTerm*> getAllOccPI(oaDesign* design);
    static vector<oaModTerm*> getAllModPO(oaDesign* design);
    static vector<oaOccTerm*> getAllOccPO(oaDesign* design);

    static vector<oaModNet*> getInputNets(oaModInst *inst);
    static vector<oaOccNet*> getInputNets(oaOccInst *inst);
    static oaModNet* getOutputNet(oaModInst *inst);
    static oaOccNet* getOutputNet(oaOccInst *inst);

    static void getFanins(oaModInst* head, vector<oaModInst*> &insts, int lvl);
    static void getFanouts(oaModInst* head, vector<oaModInst*> &insts, int lvl);
    static double getFanoutWeight(instTimingData &data, oaModInst* inst,int level);
    static double getFanoutSlack(oaDesign *top, Timer *timer, oaModInst* inst, int level);
    static double getFanoutGain(oaDesign *top, Timer *timer, oaModInst* inst, double upDelta, int level);
    static int getMaxDepth(oaDesign *design);
    static void getDepth(oaModInst* inst,int curr, int &max);
    static bool isPO(oaModNet* net);
    static oaOccInst* getOccInst(oaDesign* design, oaModInst *inst);
    static oaOccInstTerm* getOccInstTerm(oaDesign *design, oaModInstTerm *instT);
    static vector<oaOccInstTerm*> getOccInInstTerm(oaOccInst *inst);
    static oaOccInstTerm* getOccOutInstTerm(oaOccInst *inst);
    static DelayType getMinSlack(oaDesign* design, Timer* timer, oaModInst* inst);
    static DelayType getMaxSlew(oaDesign* design, Timer* timer, oaModInst* inst);

    /*! This function return the TopModule associated 
     * with the given library cell 
     */
    static oaModule* getCellTopMod(oaString name);
    static int getGateCount(oaDesign *des);
    static void checkFLAGS(oaDesign *d);
    static std::string getBlockName(oaOccObject *oPtr);
  private:
    static void initDesign(oaDesign *design);
    static bool allInPinValid(oaOccNet *net);
    static void printSensitivityList(vector<sensitivityData> vec);
};
}
#endif
