/************************************************************
* 
* File: oagTimerDesignData.h
* Author: Santiago Mok (smok@ee.ucla.edu)
* Created: 05-21-2010
* Last Modified: Sat 10 Jul 2010 06:37:36 PM PDT
*
************************************************************/
#if !defined(oagTimerDesignData_P)
#define oagTimerDesignData_P

#include <map>
#include <iostream>
#include <vector>
#include "oaDesignDB.h"
/*---------------------------------------------------------*/
using namespace std;
using namespace oa;
/*---------------------------------------------------------*/
typedef map<oaModInst*,int> InstsMap;
/*---------------------------------------------------------*/
namespace oagTimer{
/*---------------------------------------------------------*/
class DesignData{ 
  public:
    DesignData();
    ~DesignData();

/*---------------------------------------------------------*/
/*! Class Functions */
  public:
    void add(oaDesign *des);
    void buildTopological(oaDesign *des);
    vector<InstsMap>::iterator getNextIter();
    vector<InstsMap>::iterator getCurrIter();
    void moveNextIter();
    bool hasNext();

    InstsMap getCurrCellInsts();
    InstsMap getAllPI();
    InstsMap getAllP0();
    void getAllFanouts(InstsMap currInsts, vector<InstsMap> &vec);
    oaModInst* getPI();
    oaModInst* getP0();
    vector<InstsMap> getMap(); 
  private:
    void buildDesGraph();
    oaModNet* getOutputNet(oaModInst *inst);
    void getFanouts(InstsMap fanin);
/*---------------------------------------------------------*/
/*! Class Variables */
  private:
    oaDesign *design;

    vector<InstsMap> desGraph;
    vector<InstsMap>::iterator level_iter; 
};//class DesignData
/*---------------------------------------------------------*/
}//namespace
#endif
