/************************************************************
* 
* File: oagTimerDesignData.cpp
* Author: Santiago Mok (smok@ee.ucla.edu)
* Created: 05-21-2010
* Last Modified: Thu 08 Jul 2010 05:07:56 PM PDT
*
************************************************************/
#include "oagTimerDesignData.h"

namespace oagTimer{
/*---------------------------------------------------------*/
using namespace oa;
using namespace std;
/*---------------------------------------------------------*/
DesignData::DesignData(){
}
DesignData::~DesignData(){}
/*---------------------------------------------------------*/
void
DesignData::add(oaDesign *des){
    design = des;
    buildDesGraph();
    level_iter = desGraph.begin();
}
/*---------------------------------------------------------*/
vector<InstsMap>::iterator 
DesignData::getNextIter(){
    vector<InstsMap>::iterator temp_iter = level_iter;
    return temp_iter;
}
/*---------------------------------------------------------*/
void
DesignData::moveNextIter(){
    ++level_iter; 
}
/*---------------------------------------------------------*/
bool
DesignData::hasNext(){
    if(level_iter == desGraph.end()) return false;
    return true;
}
/*---------------------------------------------------------*/
void
DesignData::buildDesGraph(){
    InstsMap PI_insts = getAllPI();
    desGraph.push_back(PI_insts);
    if(!PI_insts.empty()) getFanouts(PI_insts);
    std::cout << "Graph Levels:" << desGraph.size() << std::endl;
}
/*---------------------------------------------------------*/
InstsMap 
DesignData::getCurrCellInsts(){
    if(!level_iter->empty()) return *level_iter;
}
/*---------------------------------------------------------*/
InstsMap 
DesignData::getAllPI(){
    InstsMap insts;
    oaModule *mod = design->getTopModule();
    assert(mod);
    oaIter<oaModTerm> termIter(mod->getTerms());
    while(oaModTerm *i = termIter.getNext()){
	oaTermType type(i->getTermType());
	if(type == oacInputTermType){
	    oaModNet *net = i->getNet();
	    oaIter<oaModInstTerm> instTermIter(net->getInstTerms());
	    while (oaModInstTerm *j = instTermIter.getNext()) {
		oaTermType instTerm_type(j->getTerm()->getTermType());
		if (instTerm_type == oacInputTermType) {
		    oaModInst *inst = j->getInst();
		    insts[inst] = 1;
		}
	    }
	}
    }
    return insts;
}
/*---------------------------------------------------------*/
InstsMap 
DesignData::getAllP0(){
    InstsMap insts;
    oaModule *mod = design->getTopModule();
    assert(mod);
    oaIter<oaModTerm> termIter(mod->getTerms());
    while(oaModTerm *i = termIter.getNext()){
	oaTermType type(i->getTermType());
	if(type == oacOutputTermType){
	    oaModNet *net = i->getNet();
	    oaIter<oaModInstTerm> instTermIter(net->getInstTerms());
	    while (oaModInstTerm *j = instTermIter.getNext()) {
		oaTermType instTerm_type(j->getTerm()->getTermType());
		if (instTerm_type == oacOutputTermType) {
		    oaModInst *inst = j->getInst();
		    insts[inst] = 1;
		}
	    }
	}
    }
    return insts;
}
/*---------------------------------------------------------*/
vector<InstsMap> 
DesignData::getMap(){ 
    return desGraph;
}
/*---------------------------------------------------------*/
oaModNet* 
DesignData::getOutputNet(oaModInst *inst){
    oaIter<oaModInstTerm> instTermIter(inst->getInstTerms());
    while(oaModInstTerm *i = instTermIter.getNext()){
	oaTermType type(i->getTerm()->getTermType());
	if(type == oacOutputTermType){
	    return i->getNet();
	}
    }
}
/*---------------------------------------------------------*/
void
DesignData::getFanouts(InstsMap fanin){
    InstsMap insts;
    for(InstsMap::iterator it=fanin.begin(); 
	    it!=fanin.end(); ++it){
	oaModNet *net = getOutputNet(it->first);
	oaIter<oaModInstTerm> instTermIter(net->getInstTerms());
	while(oaModInstTerm *i = instTermIter.getNext()){
	    oaTermType type(i->getTerm()->getTermType());
	    if(type == oacInputTermType){
		oaModInst *modInst = (i->getInst());
		insts[modInst] = 1;
	    }
	}
    }
    if(!insts.empty()){
	desGraph.push_back(insts);
	getFanouts(insts);
    }
    return;
}
/*---------------------------------------------------------*/
void
DesignData::getAllFanouts(InstsMap currInsts, vector<InstsMap> &vec){
    InstsMap insts;
    for(InstsMap::iterator it=currInsts.begin(); 
	    it!=currInsts.end(); ++it){
	oaModNet *net = getOutputNet(it->first);
	oaIter<oaModInstTerm> instTermIter(net->getInstTerms());
	while(oaModInstTerm *i = instTermIter.getNext()){
	    oaTermType type(i->getTerm()->getTermType());
	    if(type == oacInputTermType){
		oaModInst *modInst = (i->getInst());
		insts[modInst] = 1;
	    }
	}
    }
    if(!insts.empty()){
	vec.push_back(insts);
	getAllFanouts(insts,vec);
    }
    return;
}
/*---------------------------------------------------------*/
}//namespace

