/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: Afshin Abdollahi <afshin@usc.edu>

ChangeLog:
2006-06-27: ChangeLog started
*/

#include "oagTimerTimerUnitTest.h"
#include "oagTimerTimer.h"
#include "oagTimerSdcData.h"
#include "oagTimerSdcParserInt.h"

namespace oagTimer {

int TimerUnitTest::runAllTests(void) {
    const char *argv[] = {"command_name", "-design", "z10_test_bench",
                           "-oaData", "designs", "-lib", "cbl250.lib",
                           "-sdc", "z10_test_01.sdc"};
    oaDesignInit();
    oaLibDefList::openLibs();
    oaNativeNS nativeNS;
    static const oaScalarName physViewName(nativeNS, "physical");
    const oaScalarName cellName(nativeNS, argv[2]);
    const oaScalarName libName(nativeNS, argv[4]);
    oaDesign *cv = oaDesign::open(libName, cellName, physViewName, 'a');
    oaOccurrence *occ = cv->getTopOccurrence();
    
    // setMultiCyclePaths(); 
    Timer *myTiming = new Timer();
    myTiming->readLibrary(argv[6]);
    myTiming->add(cv);
    myTiming->readConstraints(argv[8], cv);
    std::string name = "G5";
    oaOccTerm* term = static_cast<oaOccTerm*>(myTiming->findOccObj(occ, name));
    logOneTest(myTiming->getBlockName(term) == name, "find G5");
    TPoint *p = TPoint::get(term); 
    logOneTest(p, "Timer Point of G5");
    logOneTest(p->multiCycleConstraint == 2, "Multi Cycle Constraint of G5");

    // updateArr();
    name = "G0";
    term = static_cast<oaOccTerm*>(myTiming->findOccObj(occ, name));
    logOneTest(myTiming->getBlockName(term) == name, "find G0");
    p = TPoint::get(term); 
    logOneTest(p, "Timer Point of G0");
    myTiming->updateArr(term); 
    logOneTest(p->atValid, "Updating arrival time of G0");
    logOneTest(p->multiClockData.size()==1, "Multi clock data size of G0");
    logOneTest(p->multiClockData[0]->riseArr == 0.0, "rise arrival of G0");
    logOneTest(p->multiClockData[0]->fallArr == 0.0, "fall arrival of G0");

    // updateNetArr()
    name = "i_12/A";
    term = static_cast<oaOccTerm*>(myTiming->findOccObj(occ, name));
    logOneTest(myTiming->getBlockName(term) == name, "find i_12/A");
    p = TPoint::get(term); 
    logOneTest(p, "Timer Point of i_12/A");
    myTiming->updateArr(term); 
    logOneTest(p->atValid, "Updating arrival time of i_12/A");
    logOneTest(p->multiClockData.size()==1, 
               "Multi clock data size of i_12/A");
    logOneTest(p->multiClockData[0]->riseArr == 0.0, 
               "rise arrival of i_12/A");
    logOneTest(p->multiClockData[0]->fallArr == 0.0, 
               "fall arrival of i_12/A");
    
    // updateCellArr()
    name = "i_12/O";
    term = static_cast<oaOccTerm*>(myTiming->findOccObj(occ, name));
    logOneTest(myTiming->getBlockName(term) == name, "find i_12/O");
    p = TPoint::get(term); 
    logOneTest(p, "Timer Point of i_12/O");
    myTiming->updateArr(term); 
    logOneTest(p->atValid, "Updating arrival time of i_12/O");
    logOneTest(p->multiClockData.size()==1, 
               "Multi clock data size of i_12/O");
    logOneTest(fabs(p->multiClockData[0]->riseArr - 0.0780043) < 0.0000001, 
               "rise arrival of i_12/O");
    logOneTest(fabs(p->multiClockData[0]->fallArr - 0.0780043) < 0.0000001, 
               "fall arrival of i_12/O");
    logOneTest(fabs(p->multiClockData[0]->riseSlew - 0.0072) < 0.0001, 
               "rise slew of i_12/O");
    logOneTest(fabs(p->multiClockData[0]->fallSlew - 0.0072) < 0.0001, 
               "fall slew of i_12/O");
    
    // updateNetArr()
    name = "i_1/D";
    term = static_cast<oaOccTerm*>(myTiming->findOccObj(occ, name));
    logOneTest(myTiming->getBlockName(term) == name, "find i_1/D");
    p = TPoint::get(term); 
    logOneTest(p, "Timer Point of i_1/D");
    myTiming->updateArr(term); 
    logOneTest(p->atValid, "Updating arrival time of i_1/D");
    logOneTest(p->multiClockData.size()==1, 
               "Multi clock data size of i_1/D");
    logOneTest(fabs(p->multiClockData[0]->riseArr - 0.0780043) < 0.0000001, 
               "rise arrival of i_1/D");
    logOneTest(fabs(p->multiClockData[0]->fallArr - 0.0780043) < 0.0000001, 
               "fall arrival of i_1/D");
    logOneTest(fabs(p->multiClockData[0]->riseSlew - 0.0072) < 0.0001, 
               "rise slew of i_1/D");
    logOneTest(fabs(p->multiClockData[0]->fallSlew - 0.0072) < 0.0001, 
               "fall slew of i_1/D");

    // updateCellArr()
    name = "i_1/C";
    term = static_cast<oaOccTerm*>(myTiming->findOccObj(occ, name));
    logOneTest(myTiming->getBlockName(term) == name, "find i_1/C");
    p = TPoint::get(term); 
    logOneTest(p, "Timer Point of i_1/C");
    myTiming->updateArr(term); 
    logOneTest(p->atValid, "Updating arrival time of i_1/C");
    logOneTest(p->multiClockData.size()==1, 
               "Multi clock data size of i_1/C");
    logOneTest(fabs(p->multiClockData[0]->riseArr - 0.0790487) < 0.0000001, 
               "rise arrival of i_1/C");
    logOneTest(fabs(p->multiClockData[0]->riseSlew - 0.0072) < 0.0001, 
               "rise slew of i_1/C");

    // updateClockArr()
    TPoint *p1 = TPoint::getClock(term);
    logOneTest(p1, "Clock Timer Point of i_1/C");
    myTiming->updateClockArr(term); 
    logOneTest(sdcParseData.propagatedClocks[p1->multiClockData[0]->clockIndex]
            ->phase, "clock phase at i_1/C");
    myTiming->initPOReq(term);
    logOneTest(fabs(p->multiClockData[0]->riseReq - 0.499999) < 0.000001, 
               "rise Required of i_1/C");

    // updateCellReq()
    name = "i_1/D";
    term = static_cast<oaOccTerm*>(myTiming->findOccObj(occ, name));
    logOneTest(myTiming->getBlockName(term) == name, "find i_1/D");
    p = TPoint::get(term); 
    logOneTest(p, "Timer Point of i_1/D");
    myTiming->updateReq(term); 
    logOneTest(p->atValid, "Updating arrival time of i_1/D");
    logOneTest(p->multiClockData.size()==1, 
               "Multi clock data size of i_1/D");
    logOneTest(fabs(p->multiClockData[0]->riseReq - 0.498955) < 0.000001, 
               "rise Required of i_1/D");
    logOneTest(fabs(p->multiClockData[0]->fallReq - 0.498955) < 0.000001, 
               "fall Required of i_1/D");
    
    // updateNetReq()
    name = "i_12/O";
    term = static_cast<oaOccTerm*>(myTiming->findOccObj(occ, name));
    logOneTest(myTiming->getBlockName(term) == name, "find i_12/O");
    p = TPoint::get(term); 
    logOneTest(p, "Timer Point of i_12/O");
    myTiming->updateReq(term); 
    logOneTest(p->atValid, "Updating arrival time of i_12/O");
    logOneTest(p->multiClockData.size()==1, 
               "Multi clock data size of i_12/O");
    logOneTest(fabs(p->multiClockData[0]->riseReq - 0.498955) < 0.000001, 
               "rise Required of i_12/O");
    logOneTest(fabs(p->multiClockData[0]->fallReq - 0.498955) < 0.000001, 
               "fall Required of i_12/O");

    myTiming->updateAllArr();

    // updateReq()
    name = "i_1/C";
    term = static_cast<oaOccTerm*>(myTiming->findOccObj(occ, name));
    logOneTest(myTiming->getBlockName(term) == name, "find i_1/C");
    p1 = TPoint::getClock(term);
    myTiming->updateCellReq(term); 
    logOneTest(fabs(p1->multiClockData[0]->riseReq - 0.056169) < 0.000001, 
               "rise required of i_1/C as input");
    logOneTest(fabs(p1->multiClockData[0]->riseSlew - 0.0000) < 0.0001, 
               "rise slew of i_1/C as input");

    return getReturnCode();
}

}
