#!/usr/bin/perl
#
# Converts OAGear Timer's timing report to a file in which each line is in
# the format:
#     <instance>/<pin> <load> <rslew> <fslew> <rslack> <fslack>
# or  
#     <port> <load> <rslew> <fslew> <rslack> <fslack>
#
# Usage: oagt2report.pl < <infile> > <outfile>
#
# Author: Luis Guerra e Silva <lgs@algos.inesc-id.pt>
#

$state = 0;
while(<>) {
    $line = $_;
    chomp($line);
    $line =~ s/ +/ /g;
    $line =~ s/^ //;
    if ($state == 0) {
    	if ($line =~ /Pin/) {
	    $state = 1;
	}
	else {
	    $state = 0;
	}
    }
    elsif ($state == 1) {
        $line =~ s/Infinity/infinity/ig;
    	($name, $cap) = split(/ /, $line);
	$cap = $cap * 1000;
    	$state = 2;
    }
    elsif ($state == 2) {
    	if ($line =~ /Rise/) {
	    $rslack = "infinity";
	    $fslack = "infinity";
	    $state = 3;
	}
	else {
	    $state = 0;
	}
    }
    elsif ($state == 3) {
        $line =~ s/Infinity/infinity/ig;
	if (length $line == 0) {

	    $state = 0;
	}
	else {
            if ($line =~ /As Clock/) {
	        $line =~ s/As Clock//;
                $line =~ s/^ //;
	        $state = 0;
	    }
      	    ($clknet, $mult, $rslew, $fslew, $tmprslack, $tmpfslack, $rat, $fat) = split(/ /, $line);
	    if ($tmprslack !~ /infinity/i) {
	        if ($tmprslack =~ /-infinity/i) {
		    $rslack = "-infinity";
		}
		elsif ($rslack =~ /infinity/i) {
		    $rslack = $tmprslack;
		}
		elsif ($tmprslack < $rslack) {
		    $rslack = $tmprslack;
		}
	    }
	    if ($tmpfslack !~ /infinity/i) {
	        if ($tmpfslack =~ /-infinity/i) {
		    $fslack = "-infinity";
		}
		elsif ($fslack =~ /infinity/i) {
		    $fslack = $tmpfslack;
		}
		elsif ($tmpfslack < $fslack) {
		    $fslack = $tmpfslack;
		}
	    }
	}
        if ($state == 0) {
            print "$name $cap ";
	    if ($rslew !~ /infinity/i) {
  	        $rslew = $rslew * 1000;
                printf "%.1f ", $rslew;
	    }
	    else {
	        print "$rslew ";
	    }
	    if ($fslew !~ /infinity/i) {
                $fslew = $fslew * 1000;
                printf "%.1f ", $fslew;
	    }
	    else {
	        print "$fslew ";
	    }
	    if ($rslack !~ /infinity/i) {
                $rslack = $rslack * 1000;
                printf "%.1f ", $rslack;
	    }
	    else {
	        print "$rslack ";
	    }
	    if ($fslack !~ /infinity/i) {
                $fslack = $fslack * 1000;
                printf "%.1f", $fslack;
	    }
	    else {
	        print "$fslack";
	    }
	    printf "\n";
	}
    }
}
