#!/usr/bin/perl
#
# Converts OAGear Timer's to/from/through timing report to a file containing
# the trace of # a path (e.g. the ports/pins by the right order). Each line
# contains the name of a port/pin.
#
# Usage: oagt2path.pl < <infile> > <outfile>
#
# Author: Luis Guerra e Silva <lgs@algos.inesc-id.pt>
#

$state = 0;
while(<>) {
    $line = $_;
    chomp($line);
    $line =~ s/ +/ /g;
    $line =~ s/^ //;
    if ($state == 0) {
    	if ($line =~ /Pin/) {
	    $state = 1;
	}
	else {
	    $state = 0;
	}
    }
    elsif ($state == 1) {
        $line =~ s/Infinity/infinity/ig;
    	($name, $cap) = split(/ /, $line);
	$cap = $cap * 1000;
    	$state = 2;
    }
    elsif ($state == 2) {
    	if ($line =~ /Rise/) {
	    $state = 3;
	}
	else {
	    $state = 0;
	}
    }
    elsif ($state == 3) {
        $line =~ s/Infinity/infinity/ig;
        if ($line =~ /As Clock/) {
	    $line =~ s/As Clock//;
            $line =~ s/^ //;
	}
      	($clknet, $mult, $rslew, $fslew, $rslack, $fslack, $rat, $fat) = split(/ /, $line);
	print "$name\n";
        $state = 0;
    }
}
