#!/usr/bin/perl
#
# Converts OAGear Timer's endpoint slack report to a file in which each line
# is in the format:
#     <instance>/<pin> 0 0 0 0 <slack>
# or  
#     <port> 0 0 0 0 <slack>
#
# Usage: oagt2endpoint.pl < <infile> > <outfile>
#
# Author: Luis Guerra e Silva <lgs@algos.inesc-id.pt>
#

$state = 0;
while(<>) {
    $line = $_;
    chomp($line);
    $line =~ s/ +/ /g;
    $line =~ s/^ //;
    if ($state == 0 && $line =~ /^\*\*\*\*/) {
       $state = 1
    }
    elsif ($state == 1) {
        ($a, $b, $c) = split(/ /, $line);
	if (length $c == 0) {
	    $name = $a;
	    $slack = $b;
	}
	else {
	    $name = "$a/$b";
	    $slack = $c;
	}
	if ($slack !~ /Infinity/i) {
	    $slack = $slack * 1000;
  	    printf "%s 0 0 0 0 %.0f\n", $name, $slack;
	} else {
            $slack =~ s/Infinity/infinity/ig;
	    printf "%s 0 0 0 0 %s\n", $name, $slack;
	}
    }
}
