/// \file 
///
/// Defines the associative container class \a Map as the most efficient
/// library class available.

#if !defined(oagSswMap_P)
#define oagSswMap_P

#ifdef __GNUC__

#include <ext/hash_map>

template<class Key, class Data>
struct Map {
    typedef typename __gnu_cxx::hash_map<Key, Data>                 Type;
    typedef typename __gnu_cxx::hash_map<Key, Data>::iterator       iterator;
    typedef typename __gnu_cxx::hash_map<Key, Data>::const_iterator const_iterator;
};

#else

#include <map>

template<class Key, class Data>
struct Map {
    typedef typename std::map<Key, Data>                 Type;
    typedef typename std::map<Key, Data>::iterator       iterator;
    typedef typename std::map<Key, Data>::const_iterator const_iterator;
};

#endif

#endif
