#if !defined(oagSswBitVector_P)
#define oagSswBitVector_P

#include <iostream>
#include <vector>
//#include <deque>
#include "oaBase.h"

namespace oagSsw
{

class BitVector {
  public:
                            BitVector();

    oa::oaUInt4             size() const;
    void                    setSize(oa::oaUInt4 numBits);

    bool                    getBit(oa::oaUInt4  i) const;
    void                    setBit(oa::oaUInt4  i,
                                   bool         value);

    bool                    operator<(const BitVector   &other) const;
    bool                    operator==(const BitVector  &other) const;

    void                    clear();

    /// For debugging.
    void                    print(std::ostream &out);

  private:
    typedef oa::oaUInt4     Word;

    oa::oaUInt4             numBits;
    std::vector<Word>       words;
    //std::deque<Word>        words;

    static oa::oaUInt4      getWordIndex(oa::oaUInt4    bitIndex);
    static oa::oaUInt4      getWordOffset(oa::oaUInt4   bitIndex);
    static oa::oaUInt4      getNumWords(oa::oaUInt4     numBits);

    static const oa::oaUInt4    BITS_PER_WORD;

    friend class AiSimEngine;
    friend class OdcSatSweepingEngine;
};

}

#endif
