#include <algorithm>
#include "oagSswAiLevelizer.h"

using namespace std;
using namespace oa;
using namespace oagAi;

namespace oagSsw
{

AiLevelizer::AiLevelizer(oagAi::Graph &graph)
: graph(graph)
{
}

void
AiLevelizer::setLevelListLength(oa::oaUInt4 size)
{
    levels.resize(size);
}

oaUInt4
AiLevelizer::getIndex(oagAi::Ref x)
{
    return x >> 1;
}

void
AiLevelizer::setLevel(oagAi::Ref     x,
                     oa::oaUInt4    level)
{
    levels[getIndex(x)] = level;    
}

oaUInt4
AiLevelizer::levelOf(oagAi::Ref x)
{
    return levels[getIndex(x)];
}

void
AiLevelizer::initialLevels()
{   
    list<Ref> allNodes;
    graph.getAll(allNodes);
    
    oaUInt4 maxRef = 0;
    for (list<Ref>::iterator it = allNodes.begin();
            it != allNodes.end();
            ++it) {
        if ((oaUInt4)(*it) > maxRef)
            maxRef = (oaUInt4)(*it);
    } 
    levels.resize(maxRef / 2 + 1);

    for (oaUInt4 i = 0; i < levels.size(); i++) {
        levels[i] = 0;
    }

    for (list<Ref>::iterator it = allNodes.begin();
            it != allNodes.end();
            ++it) {
        initialLevelRec(*it);
    }
}


oaUInt4
AiLevelizer::initialLevelRec(oagAi::Ref x)
{
    if (levels[getIndex(x)] != 0)
        return levels[getIndex(x)]; 
            
    oaUInt4 level;
    switch (graph.getNodeType(x)) {
      case Node::NONE:          // fall through
      case Node::CONSTANT0:
        return 0;
        break;
    
      case Node::AND:
        {
            oaUInt4 leftLevel  = initialLevelRec(graph.getAndLeft(x));
            oaUInt4 rightLevel = initialLevelRec(graph.getAndRight(x));
            level = max(leftLevel, rightLevel) + 1;
            break;
        }

      case Node::TERMINAL:
        /*
        driver = graph.getTerminalDriver(x);
        if (!graph.isNull(driver)) {
            level = initialLevelRec(driver)+ 1;
        }
        */
        level = initialLevelRec(graph.getTerminalDriver(x)) + 1;
        break;

      case Node::SEQUENTIAL:
        level = 1;
        break;

      default:
        assert(false);
    }
    levels[getIndex(x)] = level;

    return level;
}

void
AiLevelizer::updateLevel(oagAi::Ref x)
{
    oaUInt4 oldLevel = levels[getIndex(x)];
    oaUInt4 newLevel;

    Ref driver;
    switch (graph.getNodeType(x)) {
      case Node::NONE:          // fall through
      case Node::CONSTANT0:
        return;
        break;
    
      case Node::AND:
        {
            oaUInt4 leftLevel  = levels[getIndex(graph.getAndLeft(x))];
            oaUInt4 rightLevel = levels[getIndex(graph.getAndRight(x))];
            newLevel = max(leftLevel, rightLevel) + 1;  
            break;
        }

      case Node::TERMINAL:
        driver = graph.getTerminalDriver(x); 
        if (!graph.isNull(driver)) {
            newLevel = levels[getIndex(driver)] + 1;
        }
        else {
            newLevel = 1;
        }
        break;

      case Node::SEQUENTIAL:
        newLevel = 1;
        break;

      default:
        assert(false);
    }
    
    if (newLevel != oldLevel) {
        levels[getIndex(x)] = newLevel;
        const list<Ref> &fanout = graph.getFanout(x);
        for (list<Ref>::const_iterator it = fanout.begin();
             it != fanout.end();
             it++) {
            updateLevel(*it);
        }
    }
}

}
