
/*
Author: Kai-hui Chang <changkh@eecs.umich.edu>
*/

///
/// \file oagResynUtil.h
/// Utility routines

#if !defined(oagResynUtil_P)
#define oagResynUtil_P

#include "oaDesignDB.h"
#include <vector>
#include "oagResynType.h"

namespace oagResyn {

/// Some utility routines.
class util {
public:
    static void getCogNoDriver(oa::oaNet* iNet, oa::oaCoord& x, oa::oaCoord& y);
    static void getCog(oa::oaNet* iNet, oa::oaCoord& x, oa::oaCoord& y);
    static oa::oaInst* getDriverInst(oa::oaNet* iNet);
    static void getInstCoord(oa::oaInst* iInst, oa::oaCoord& x, oa::oaCoord& y);
    static void getInstSize(oa::oaInst* iInst, oa::oaUInt4& x, oa::oaUInt4& y);
    static oa::oaUInt4 getHPWL(oa::oaNet* iNet);
    static void moveInst(oa::oaInst* iInst, oa::oaCoord x, oa::oaCoord y);
    static void getTermCoord(oa::oaTerm* iTerm, oa::oaCoord& x, oa::oaCoord& y);
    static void getInstTermCoord(oa::oaInstTerm* iTerm, oa::oaCoord& x, oa::oaCoord& y);
    static double getDist(oa::oaCoord x1, oa::oaCoord y1, oa::oaCoord x2, oa::oaCoord y2);
    static void intVecAddVec(std::vector<std::vector<SimulationVector> >& origVec, std::vector<SimulationVector>& newVec, int origSize, int newSize);
    static void vecAddInt(std::vector<SimulationVector>& origVec, SimulationVector newInt, int origSize, int newSize);
    static void vecAddVec(std::vector<SimulationVector>& origVec, std::vector<SimulationVector>& newVec, int origSize, int newSize);
    static void bitVecToIntVec(std::vector<SimulationVector>& intVec, std::vector<bool>& bitVec);
    static void printIntVec(std::vector<SimulationVector>& inVec);
    static bool intVecGetBit(std::vector<SimulationVector>& inVec, int bitNO);
    static int getToken(std::ifstream& ifile2, std::string& token);
    static int getClockTime();
    static oa::oaInstTerm* netGetInstDriver(oa::oaNet* inNet);
};

} // end of namespace

#endif
// vim: ci et sw=4 sts=4
