
/*
Author: Kai-hui Chang <changkh@eecs.umich.edu>
*/

///
/// \file oagResynUserPattern.h
/// Classes for user provided test patterns

#if !defined(oagResynUserPattern_P)
#define oagResynUserPattern_P

#include <fstream>
#include <vector>
#include "oaDesignDB.h"
#include "oagResynType.h"

namespace oagResyn {

/// \brief Reads and handles user specified input patterns.
class userPattern
{
public:
    bool setFile(oa::oaDesign* design, const char* fileName);
    void getNets(std::vector<oa::oaNet*>& nets);
    bool getVector(std::vector<SimulationVector>& vec);
    bool isFinished();
    ~userPattern() {if (iFile.is_open()) iFile.close();}
protected:
    std::vector<oa::oaNet*> myNets;
    std::ifstream iFile;
};

}

#endif

// vim: ci et sw=4 sts=4
