
/* 
Author: Kai-hui Chang <changkh@eecs.umich.edu>
*/

///
/// \file oagResynSim.h
/// Simulatior.

#if !defined(oagResynSim_P)
#define oagResynSim_P

#include "oaDesignDB.h"
#include "oagResynUserIntf.h"
#include "oagFunc.h"
#include "oagResynInternalCkt.h"
#include "oagResynUserPattern.h"
#include "oagResyn.h"
#include <vector>

namespace oagResyn {

/// Caches state net information.
class stateSimWireCache
{
public:
    simWire* dataWire;
    std::vector<simWire*> Q, QN;
};

/// For simulation.
class Sim :public simulatorInterface {

public:
    void doRandomSimulation();
    void incrementalSim(oa::oaNet* net, SimulationVector newVec);
    void runFull();
    void nextCycle();

    void setStateVector(oa::oaInst* inst, SimulationVector vec);
    void setVector(oa::oaNet* net, SimulationVector vec, int isw= 0);

    void getVector(oa::oaNet* net, SimulationVector& vec);
    void getStates(std::vector<oa::oaInst*>& result);
    void getStateNets(std::vector<oa::oaNet*>& result);
    void getInputs(std::vector<oa::oaNet*>& result);
    void getOutputs(std::vector<oa::oaNet*>& result);
    void getClockNets(std::vector<oa::oaNet*>& result);
    void getAllNets(std::vector<oa::oaNet*>& result);
    SimulationVector randomVector();
    bool setUserPatternFile(const char* fileName);
    bool useStateFile(const char* fileName);
    void advanceInputs();
    void step();
    bool isFinished();

    void generateRandomInputVectors();
    void generateRandomStateVectors();
    Sim() {};
    Sim(oa::oaDesign *design);
    ~Sim();
    void setDesign(oa::oaDesign *design);

protected:
    internalCkt* myCkt;
    oa::oaDesign *design;
    oa::oaBlock *block;
    userPattern* myUserPattern;
    std::vector<stateSimWireCache> stateCache;
    std::vector<oa::oaNet*> inputVecNets;
    void simulateInst(oa::oaInst* inInst, int isw);
};

}

#endif

// vim: ci et sw=4 sts=4
