
/* 
Author: Kai-hui Chang <changkh@eecs.umich.edu>
*/

///
/// \file oagResynSATIntf.h
/// SAT interface to MiniSAT.

#include <vector>
#include "mSatSolver.h"


#if !defined(oagResynSATIntf_P)
#define oagResynSATIntf_P

namespace oagResyn {

typedef std::vector< std::vector<int> > clauseType;

/// An interface for MiniSat SAT solver
class oagResynSATIntf {
public:
    bool printCNF;
    oagResynSATIntf();
    void addClause(std::vector<int>& inClause);
    void addCNF(clauseType& inCNF);
    void solve();
    bool isSat();
    int getLitValue(int litNO);

protected:
    miniSat::Solver mSat;
};

}

#endif

// vim: ci et sw=4 sts=4
