
/*
Author: Kai-hui Chang <changkh@eecs.umich.edu>
*/

#include "oagResynSATIntf.h"
#include <iostream>


using namespace std;
using namespace miniSat;

namespace oagResyn {

// *****************************************************************************
// oagResynSATIntf()
//
/// \brief Constructor
//
// *****************************************************************************
oagResynSATIntf::oagResynSATIntf()
{
    printCNF= false;        
}

// *****************************************************************************
// addClause()
//
/// \brief Add a clause to SAT.
//
// *****************************************************************************
void oagResynSATIntf::addClause(vector<int>& inClause)
{
    int lit, var;
    vector<int>::iterator intIter;
    vec<Lit> lits;

    for (intIter= inClause.begin(); intIter != inClause.end(); intIter++)
    {
        if (printCNF)
            cout<<(*intIter)<<" ";
        lit= *intIter;
        var= abs(lit) - 1;
        while (var >= mSat.nVars()) mSat.newVar();
        lits.push((lit > 0) ? Lit(var) : ~Lit(var));
    }
    if (printCNF)
        cout<<"0"<<endl;
    mSat.addClause(lits);
}

// *****************************************************************************
// addCNF()
//
/// \brief Add a whole CNF to SAT.
//
// *****************************************************************************
void oagResynSATIntf::addCNF(clauseType& inCNF)
{
    clauseType::iterator vecIter;

    for (vecIter= inCNF.begin(); vecIter != inCNF.end(); vecIter++)
        addClause(*vecIter);
}

// *****************************************************************************
// solve()
//
/// \brief Call SAT to solve the problem.
//
// *****************************************************************************
void oagResynSATIntf::solve()
{
    mSat.solve();
}

// *****************************************************************************
// isSat()
//
/// \brief Check whether the CNF is satisfiable. 
///
/// \return True: satisfiable
//
// *****************************************************************************
bool oagResynSATIntf::isSat()
{
    return mSat.okay();
}

// *****************************************************************************
// getLitValue()
//
/// \brief Returns the true/false of a literal number
///
/// \param litNO Literal number.
/// \return 0: undefined, 1: true, -1 false. It is only valid after Solve is called and it is satisfiable.
//
// *****************************************************************************
int oagResynSATIntf::getLitValue(int litNO)
{
    if (mSat.model[litNO-1] == l_Undef)
        return 0;
    else if (mSat.model[litNO-1] == l_True)
        return 1;
    else
        return -1;
}

} // end of namespace

// vim: ci et sw=4 sts=4
