
/* 
Author: Kai-hui Chang <changkh@eecs.umich.edu>
*/

///
/// \file oagResynOptSim.h
/// Optimized simulatior.

#if !defined(oagResynOptSim_P)
#define oagResynOptSim_P

#include "oaDesignDB.h"
#include "oagFunc.h"
#include "oagResynUserIntf.h"
#include "oagResynLibMan.h"
#include "oagResynOptInternalCkt.h"
#include "oagResyn.h"
#include "oagResynUserPattern.h"
#include <vector>
#include <map>


namespace oagResyn {

/// Optimized simulator using custom data structure.
class optSim :public simulatorInterface {

public:
    void doRandomSimulation();
    void incrementalSim(oa::oaNet* net, SimulationVector newVec);
    void runFull();
    void nextCycle();
    void propagateState();
    void setStateVector(oa::oaInst* inst, SimulationVector vec);
    void setVector(oa::oaNet* net, SimulationVector vec, int isw= 0);
    void getVector(oa::oaNet* net, SimulationVector& vec);
    void getStateVector(oa::oaInst* inst, SimulationVector& vec);
    void getStateVectorD(oa::oaInst* inst, SimulationVector& vec);
    void getStates(std::vector<oa::oaInst*>& result);
    void getStateNets(std::vector<oa::oaNet*>& result);
    void getInputs(std::vector<oa::oaNet*>& result);
    void getOutputs(std::vector<oa::oaNet*>& result);
    void getClockNets(std::vector<oa::oaNet*>& result);
    void getAllNets(std::vector<oa::oaNet*>& result);
    SimulationVector randomVector();
    bool setUserPatternFile(const char* fileName);
    bool useStateFile(const char* fileName);
    void advanceInputs();
    void step();
    bool isFinished();
    
    optSim(); 
    optSim(oa::oaDesign *design);
    ~optSim();
    void setDesign(oa::oaDesign *design);
    void generateRandomInputVectors();
    void generateRandomStateVectors();
    void cleanUp();

protected:
    optInternalCkt* myCkt;
    oa::oaDesign *design;
    oa::oaBlock *block;
    userPattern* myUserPattern;
    std::vector<oa::oaNet*> inputVecNets;
    void simulateInst(optSimInst* inInst, int isw);
    void incrementalSim(optSimWire* wire, SimulationVector newVec);
};

}

#endif

// vim: ci et sw=4 sts=4
