
/*
Author: Kai-hui Chang <changkh@eecs.umich.edu>
*/

///
/// \file oagResynOptCktOper.h
/// Class for some operations on optimized internal circuit

#if !defined(oagResynOptCktOper_P)
#define oagResynOptCktOper_P

#include "oaDesignDB.h"
#include "oagResyn.h"

namespace oagResyn {

class optCktOper {
public:
    optCktOper(optInternalCkt* inCkt) : ckt1 (inCkt), serialNO (0) {};
    optSimInst* injectRandomBug();
    optSimInst* randomResynthesize();
    void injectRandomSeqBug(std::string dffCellName);
    void injectRandomRegBug();
protected:
    optInternalCkt* ckt1;
    unsigned int serialNO;

};


}

#endif

// vim: ci et sw=4 sts=4
