
/*
Author: Kai-hui Chang <changkh@eecs.umich.edu>
*/

#include "oagResynObserver.h"
#include "oagResyn.h"

using namespace std;
using namespace oa;

namespace oagResyn {

// *****************************************************************************
// onPurge()
//
/// This callback is invoked before an oaDesign is removed from memory.
// *****************************************************************************
void Observer::onPurge(oa::oaDesign *design) 
{
    map<oaDesign*, class internalCkt* >::iterator mapIter1;
    map<oaDesign*, class optInternalCkt* >::iterator mapIter2;

    mapIter1= cktManager.intCktMap.find(design);
    if (mapIter1 != cktManager.intCktMap.end())
    {
        delete((*mapIter1).second);
        cktManager.intCktMap.erase(mapIter1);
    }
    mapIter2= cktManager.optIntCktMap.find(design);
    if (mapIter2 != cktManager.optIntCktMap.end())
    {
        delete((*mapIter2).second);
        cktManager.optIntCktMap.erase(mapIter2);
    }

}

} // End of namespace
// vim: ci et sw=4 sts=4
