
/*
Author: Kai-hui Chang <changkh@eecs.umich.edu>
*/

///
/// \file oagResynCktMan.h
/// Internal circuit manager.

#if !defined(oagResynCktMan_P)
#define oagResynCktMan_P

#include <map>
#include "oaDesignDB.h"
#include "oagResynInternalCkt.h"
#include "oagResynOptInternalCkt.h"
#include "oagResynObserver.h"

namespace oagResyn {

/// Manager for internal data structure. 
class cktMan
{
friend class Observer;
public:
    class internalCkt* designGetInternalCkt(oa::oaDesign *design);
    class optInternalCkt* designGetOptInternalCkt(oa::oaDesign *design);
protected:    
    /// The observer to observe oaDesign
    Observer designObserver;
    std::map<oa::oaDesign*, class internalCkt* > intCktMap;
    std::map<oa::oaDesign*, class optInternalCkt*> optIntCktMap;
};

} // of namespace
#endif

// vim: ci et sw=4 sts=4
