
/*
Author: Kai-hui Chang <changkh@eecs.umich.edu>
*/

#include "oagResynCktMan.h"

using namespace std;
using namespace oa;

namespace oagResyn {

// *****************************************************************************
// designGetOptInternalCkt()
//
/// \brief Get optimized internal circuit from a design. 
//
// *****************************************************************************
optInternalCkt* cktMan::designGetOptInternalCkt(oa::oaDesign *design)
{
    map<oaDesign*, optInternalCkt*>::iterator cktMapIter;
    optInternalCkt* myCkt;
    
    assert(design);
    cktMapIter= optIntCktMap.find(design);
    if (cktMapIter == optIntCktMap.end())
    {
        myCkt= (optInternalCkt*)new(optInternalCkt)(design);
        optIntCktMap[design]= myCkt;
    }
    else
        myCkt= (*cktMapIter).second;
    return myCkt;
}

// *****************************************************************************
// designGetInternalCkt()
//
/// \brief Get internal circuit from a design. 
//
// *****************************************************************************
internalCkt* cktMan::designGetInternalCkt(oa::oaDesign *design)
{
    map<oaDesign*, internalCkt*>::iterator cktMapIter;
    internalCkt* myCkt;
    
    assert(design);
    cktMapIter= intCktMap.find(design);
    if (cktMapIter == intCktMap.end())
    {
        myCkt= (internalCkt*)new(internalCkt)(design);
        intCktMap[design]= myCkt;
    }
    else
        myCkt= (*cktMapIter).second;
    return myCkt;
}

}

// vim: ci et sw=4 sts=4
