/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: Aaron P. Hurst <ahurst@eecs.berkeley.edu>
 
ChangeLog:
2005-05-31: ChangeLog started
*/

#if !defined(oagFuncVerilogParserYystype_P)
#define oagFuncVerilogParserYystype_P

#include "oagFuncVerilogDesign.h"
#include <list>
#include <map>

using namespace oagFunc;

typedef union YYSTYPE {
    struct {
        bool                                negative;       // sign flag
        int                                 bits;           // bit length
        unsigned int                        value;          // integer value
        unsigned int                        zmask;          // mask of bits that were 'z'
        unsigned int                        xmask;          // mask of bits that were 'x'
    } number;
    char                                    *str;       // string

    VerilogDesign::Expression              *expression;
    std::list<VerilogDesign::Expression*>  *expressions;
    VerilogDesign::Primary                 *primary;
    std::list<VerilogDesign::Primary*>     *primaries;
    VerilogDesign::Bundle                  *bundle;
    
    VerilogDesign::Module                     *module;
    std::list<VerilogDesign::Port*>           *ports;
    std::list<VerilogDesign::PortConnection*> *portConnections;
    VerilogDesign::Assignment                 *assignment;
    VerilogDesign::Declaration                *declaration;
    VerilogDesign::PortConnection             *portConnection;
    VerilogDesign::Instantiation              *instantiation;
  
    VerilogDesign::Statement               *statement;
    std::list<VerilogDesign::Statement*>   *statements;
    std::list<VerilogDesign::Case*>        *cases;

    VerilogDesign::Trigger                 *trigger;
    std::list<VerilogDesign::Trigger*>     *triggers;
   
    struct {
        std::list<VerilogDesign::Assignment*>    *assignments;
        std::list<VerilogDesign::AlwaysBlock*>   *alwaysBlocks;
        std::list<VerilogDesign::Statement*>     *initialBlocks; 
        std::list<VerilogDesign::Instantiation*> *instantiations;
        std::list<VerilogDesign::Declaration*>   *declarations;        
        std::list<VerilogDesign::Function*>      *functions;
        std::list<VerilogDesign::Declaration*>   *parameterOverrides;
    } decls;
    
} YYSTYPE;

#define YYSTYPE_IS_DECLARED 1
#define YYSTYPE_IS_TRIVIAL 1

#endif
