/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: Aaron P. Hurst <ahurst@eecs.berkeley.edu>
 
ChangeLog:
2005-05-31: ChangeLog started
*/

#if !defined(oagFuncTimingLibrarySynthesis_P)
#define oagFuncTimingLibrarySynthesis_P

#include "oaDesignDB.h"
#include "oagAiGraph.h"
#include "oagFunc.h"
#include "oagFuncManager.h"
#include "oagFuncMultiRef.h"
#include "oagFuncSynthesis.h"
#include <list>

using namespace std;

namespace oagFunc {

// *****************************************************************************
// TimingLibrarySynthesis
//
/// \brief Creates OpenAccess objects and functional descriptions described in a timing library.
///
/// This class annotates library cells with functional information.  If the 
/// library cells do not exist, it creates them.  This class is invoked primarily
/// from within a timing file parser.
//
// *****************************************************************************

class TimingLibrarySynthesis : public Synthesis {

  public:
    static void                 initialize();
  
    static MultiRef             notOf(MultiRef e) {
        return Synthesis::notOf(e);
    }
    static MultiRef             orOf(MultiRef e1, MultiRef e2) {
        return Synthesis::orOf(e1, e2);
    }
    static MultiRef             andOf(MultiRef e1, MultiRef e2) {
        return Synthesis::andOf(e1, e2);
    }
    static MultiRef             xorOf(MultiRef e1, MultiRef e2) {
        return Synthesis::xorOf(e1, e2);
    }
    static MultiRef             constantZero() {
        return Synthesis::constantZero();
    }
    static MultiRef             constantOne() {
        return Synthesis::constantOne();
    }
    static oa::oaModule*           createModule(const string identifier) { 
        currentModule = Synthesis::createModule(identifier); 
        currentManager = NULL;
        return currentModule;
    }
    static oa::oaModScalarNet*     findScalarNet(const string identifier) {
        return Synthesis::findScalarNet(identifier);    
    }
    static oa::oaModScalarNet*     createScalarNet(const string identifier) {
        return Synthesis::createScalarNet(identifier);    
    }
    static oa::oaModTerm*          createTerm(oa::oaModNet* net, const string identifier, 
                                              oa::oaTermType direction) {
        return Synthesis::createTerm(net, identifier, direction);    
    }
    static void                    assignMultiRef(oa::oaModBitNet *net, const MultiRef e) {
        return Synthesis::assignMultiRef(net, e);    
    }
    static MultiRef                latch(MultiRef enable, MultiRef in, const string name) {
        return Synthesis::latch(enable, in, name);
    }
    static MultiRef                seq(MultiRef in, const string name) {
        return Synthesis::seq(in, name);
    }
    static void                    annotateAsynchronousSignal(oagAi::Ref sequential, 
                                                              const string label, 
                                                              MultiRef signal) {
        Synthesis::annotateAsynchronousSignal(sequential, label, signal);
    }
};

}

#endif
