/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: Aaron P. Hurst <ahurst@eecs.berkeley.edu>
 
ChangeLog:
2005-05-31: ChangeLog started
*/

#if !defined(oagFuncSimMod_P)
#define oagFuncSimMod_P

#include "oaDesignDB.h"
#include "oagFunc.h"
#include "oagFuncModGraph.h"
#include <list>
#include <map>

using namespace std;

namespace oagFunc {

// *****************************************************************************
// Simulator
//
/// \brief An object for simulating input vectors on hierarchical designs.
//
// *****************************************************************************

class SimMod {

  public:
  
                        SimMod(oa::oaDesign *design);
                        
    typedef unsigned int SimVec;

    static const int SIM_USER_DATA_INDEX = 0;

    inline void         setVector(const ModRef &ref, SimVec vec) {
      if (ModGraph::isInverted(ref)) {
        ModGraph::setUserData(ref, SIM_USER_DATA_INDEX, ~vec);
      } else {
        ModGraph::setUserData(ref, SIM_USER_DATA_INDEX, vec);
      }
      toBeSimulated.push_back(ModGraph::getNonInverted(ref));
    }
    void                generateRandomInputVectors();
    void                generateRandomStateVectors();
    void                clear();
    
    void                nextCycle();
    
    void                runFull();
    
    void                initializeIncremental();
    void                runIncremental();
    void                runOne(const ModRef & ref);

    inline void         getVector(const ModRef &ref, SimVec &vec) {
      vec = ModGraph::getUserData(ref, SIM_USER_DATA_INDEX);
    }
    
  protected:
  
    SimVec              randomVector();
    int                 BITS_PER_RAND;
    
    oa::oaDesign       *design;
    list<ModRef>        toBeSimulated;
};

}

#endif
