/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: Aaron P. Hurst <ahurst@eecs.berkeley.edu>
 
ChangeLog:
2005-05-31: ChangeLog started
*/

#if !defined(oagFuncQueryOcc_P)
#define oagFuncQueryOcc_P

#include "oaDesignDB.h"
#include "oagFunc.h"
#include "oagFuncReasoningEngine.h"
#include "oagFuncOccGraph.h"
#include <list>
#include <map>
#include <set>

using namespace std;

namespace oagFunc {

// *****************************************************************************
// QueryOcc
//
/// \brief An object for performing functional queries on OpenAccess designs.
//
// *****************************************************************************

class QueryOcc {

  public:
  
                        QueryOcc(oa::oaDesign *design, 
                                 GenericReasoningEngine *engine);

    GenericFunction     getNextState(oa::oaOccBitNet *net);
    GenericFunction     getNextState(OccRef &ref);
    
    GenericFunction     get(oa::oaOccBitNet *net);
    GenericFunction     get(OccRef &ref);

    void                set(oa::oaOccBitNet *net, GenericFunction f);
    void                set(OccRef &ref, GenericFunction f);

    void                unset(oa::oaOccBitNet *net);
    void                unset(OccRef &ref);    
    
  protected:
  
    oa::oaDesign           *design;
    GenericReasoningEngine *engine;

  private:
    
    GenericFunction                getRecursively(OccRef &g);
    
    map<OccRef,GenericFunction>    precomputedCache;
    map<OccRef,GenericFunction>    setFunctionsOnRefs;
 
    std::set<OccRef>               visitedSet;
    
};

}

#endif
