/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: Aaron P. Hurst <ahurst@eecs.berkeley.edu>
 
ChangeLog:
2005-05-31: ChangeLog started
*/

#if !defined(oagFuncQueryAi_P)
#define oagFuncQueryAi_P

#include "oagFuncReasoningEngine.h"
#include "oagAiGraph.h"

using namespace std;

namespace oagFunc {

// *****************************************************************************
// QueryAi
//
/// \brief An object for performing functional queries on Ai graphs.
//
// *****************************************************************************

class QueryAi {

  public:
  
                        QueryAi(oagAi::Graph *graph, 
                                GenericReasoningEngine *engine);
                                
    GenericFunction     getNextState(oagAi::Ref ref);
    GenericFunction     get(oagAi::Ref ref);
    GenericFunction     get(oagAi::Ref ref, oagAi::Graph::Cut & cut);
    void                set(oagAi::Ref ref, GenericFunction f);
    void                unset(oagAi::Ref ref);
    
  protected:
  
    oagAi::Graph           *graph;
    GenericReasoningEngine *engine;

  private:

    GenericFunction                  getRecursively(oagAi::Ref ref);
    
    map<oagAi::Ref, GenericFunction> precomputedCache;
    map<oagAi::Ref, GenericFunction> setFunctions;
    std::set<oagAi::Ref>             visitedSet;
    
};

}

#endif
