/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: Aaron P. Hurst <ahurst@eecs.berkeley.edu>
 
ChangeLog:
2005-05-31: ChangeLog started
*/

#if !defined(oagFuncObserver_P)
#define oagFuncObserver_P

#include "oaDesignDB.h"
#include "oagAiGraph.h"
#include <iostream>

using namespace std;

namespace oagFunc {

// *****************************************************************************
// Observer
//
/// \brief A observer object to intercept save and open calls. 
///
/// This object's functions are called when the corresponding action is 
/// performed on any design.  When a design is saved, the volatile functional
/// description is serialized and placed into a byte buffer that can then be
/// saved to disk.  When a design is opened, the byte stream of functional
/// information is unserialized and reconstructed into the appropriate
/// data structures.
//
// *****************************************************************************

class Observer : public oa::oaObserver<oa::oaDesign> {

  public:
  
            Observer();

    void    onFirstOpen(oa::oaDesign *design);
    void    onPurge(oa::oaDesign *design);
    void    onPreSave(oa::oaDesign *design);
    void    onPostSave(oa::oaDesign *design);
};

}

#endif
