/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: Aaron P. Hurst <ahurst@eecs.berkeley.edu>
 
ChangeLog:
2005-06-01: ChangeLog started
*/

#if !defined(oagFuncDdReasoningEngine_P)
#define oagFuncDdReasoningEngine_P

#include "oagDdManager.h"
#include "oagFuncReasoningEngine.h"
#include <iostream>

using namespace std;

namespace oagFunc {

/// \brief A reasoning engine using the OAGear Dd package.
/// package.
///
/// This class implements the abstract interface of a ReasoningEngine and
/// can therefore be used as a engine for extracting the functionality of
/// a design.  It also inherits the interface of a oagDd::manager, and
/// uses this parent class to perform the reasoning.

class DdReasoningEngine : public ReasoningEngine<oagDd::Node *>,
                   public oagDd::Manager {

public:

    // required callback functions
    oagDd::Node * getZero( ) {
        return oagDd::Manager::getZero();
    }
    oagDd::Node * andOf( oagDd::Node *a, oagDd::Node *b ) {
        return oagDd::Manager::andOf(a,b);
    }
    oagDd::Node * notOf( oagDd::Node *a ) {
        return oagDd::Manager::notOf(a);
    }
   
};

}

#endif
