/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: Aaron Hurst <ahurst@eecs.berkeley.edu>

ChangeLog:
2005-07-20: ChangeLog started
*/

#if !defined(oagDDAbstractManager_P)
#define oagDDAbstractManager_P

namespace oagDd {

/// \brief An abstract decision diagram manager.

template <class Node>
class AbstractManager {

  public:
    
    /// Computes the conjunction of two functions.
    /// \param x
    /// \param y
    /// \return x * y
    Node andOf(Node x, Node y);

    /// Computes the disjunction of two functions.
    /// \param x
    /// \param y
    /// \return x + y
    Node orOf(Node x, Node y);

    /// Computes the exclusive-OR of two functions.
    /// \param x
    /// \param y
    /// \return x ^ y
    Node xorOf(Node x, Node y);

    /// Computes the complement of a function.
    /// \param x
    /// \return !x
    Node notOf(Node x);
    
    /// Returns a new variable.
    /// \return a new variable
    Node newVariable( );

    /// Returns the function that is always false.
    /// \return false
    Node getZero( );
    
};

}

#endif
