/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: David Papa <iamyou@umich.edu>

ChangeLog:
2004-09-15: ChangeLog started
 */

#include <assert.h>
#include <iostream>

#include "ABKCommon/uofm_alloc.h"

#include "placerInternals.h"
#include "oaIO.h"
#include "capoExposedInterface.h"
#include "oaDesignDB.h"

using std::cout;
using std::endl;

using oa::oaNativeNS;
using oa::oaInst;
using oa::oaBlockObject;
using oa::oaException;
using oa::oaPoint;
using oa::oacPlacedPlacementStatus;

using uofm::vector;


void buildCapoRBPlacementFromOA(RBPlacement*& rb, 
        capoExposedInterface& capo, 
        int argc, const char** argv)
{

    HGraphWDimensions* hgraph = 0;
    capo.buildCapoHGraphWDimensions(hgraph);
    //cerr<<"DPDEBUG: "<<hgraph->getNumNodes()<<endl;
    //cerr<<(*hgraph)<<endl;

    //read locations from OA
    //construct the placement with a vector<Point>
    vector<Point> locations;
    capo.readOAPlLocations(locations);
    //cerr<<"DPDEBUG: "<<locations.size()<<endl;
    PlacementWOrient* pl = new PlacementWOrient(locations);

    vector<RBPCoreRow>* cr=0;
    capo.buildCapoCoreRows(pl, cr);
    //cerr<<"DPDEBUG:  CoreRows: "<<endl<<cr<<endl;
    //   for(size_t i=0;i<cr->size();i++)
    //   cerr<<&((*cr)[i])<<endl;
    //construct the rbplace
    RBPlacement::Parameters params(argc, argv);
    cout<<"RBPlace parameters: "<<endl<<params<<endl<<endl;

    rb = new RBPlacement(hgraph, *pl, cr, params);
    rb->removeSitesBelowFixed();
    rb->removeSitesBelowMacros();
    //rb->saveAsNodesNetsWts("RBPlaceOutput");
    //exit(0);
}


void buildCapoRBPlacementFromOARegionQuery(RBPlacement*& rb,
        capoExposedInterface& capo, 
        const oa::oaBox&  bbox, 
        int argc,
        char** argv)
{

    HGraphWDimensions* hgraph = 0;
    //Note this sets all other nodes to terminals
    capo.buildCapoHGraphWDimensions(hgraph, bbox);
    //cerr<<"DPDEBUG: "<<hgraph->getNumNodes()<<endl;
    //cerr<<(*hgraph)<<endl;

    //read locations from OA
    //construct the placement with a vector<Point>
    vector<Point> locations;
    capo.readOAPlLocations(locations);
    PlacementWOrient* pl=new PlacementWOrient(locations);

    vector<RBPCoreRow>* cr=0;
    capo.buildCapoCoreRows(pl, cr, bbox);
    //cerr<<"DPDEBUG:  CoreRows: "<<endl<<cr<<endl;

    //construct the rbplace
    RBPlacement::Parameters params(argc,const_cast<const char**>(argv));

    cout<<"RBPlace parameters: "<<endl<<params<<endl<<endl;

    rb = new RBPlacement(hgraph, *pl, cr, params);
    rb->removeSitesBelowFixed();
    rb->removeSitesBelowMacros();
}

    void
writeCapoPlacementToOA(const RBPlacement& rb, 
        capoExposedInterface& capo)
{

    oaNativeNS ns;
    oaInst* inst=0;
    HGraphWDimensions hgraph = rb.getHGraph();
    PlacementWOrient pl = rb.getPlacement();
    const vector<oaBlockObject*>& node_idx_to_ptr = capo.getMapping();

    try
    {                                                               
        //printf("Writing pl locations to Cell View\n");
        for(size_t node_idx = 0; node_idx < node_idx_to_ptr.size(); ++node_idx)
        {
          bool isFixed= capo.isTerm(node_idx) || capo.isFixedInst(node_idx);
          if(!isFixed)
          {
            inst = static_cast<oaInst*>(node_idx_to_ptr[node_idx]); 
            assert(inst);
            Point p = pl[node_idx];
            oaPoint oap(static_cast<int>(p.x),static_cast<int>(p.y));
            inst->setOrigin(oap);
            inst->setPlacementStatus(oacPlacedPlacementStatus);
          }
        }//for loop: each capo node idx
    } 
    catch (oaException &excp) 
    {
        printf("\t%s\n", (const char *)excp.getMsg());
        exit(1);
    }
}

