/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: David Papa <iamyou@umich.edu>

ChangeLog:
2004-09-15: ChangeLog started
*/

#ifndef _CAPO_EXPOSED_INTERFACE_H_
#define _CAPO_EXPOSED_INTERFACE_H_

#include "oaDesignDB.h"

#include "ABKCommon/uofm_alloc.h"

#include "HGraphWDims/hgWDims.h"
#include "Placement/placeWOri.h"
#include "RBPlace/RBRows.h"
//#include "RBPlace/slicingTree.h"
//#include "oaSlicingTree.h"

class CapoWrapperException
{
  public:
    std::string msg;
};

class capoExposedInterface
{
  public:
    capoExposedInterface(oa::oaBlock* block, oa::oaDesign* design, oa::oaBox bbox):
      _node_idx_to_ptr( block->getInsts().getCount() + 
                        block->getTerms().getCount() ),
      _is_term( block->getInsts().getCount() + block->getTerms().getCount() ),
      _is_fixed_inst( block->getInsts().getCount() + block->getTerms().getCount() ),
      _block(block), _design(design) //, _slicingTree(bbox)
     {        
     }
    //1. buildCapoHGraphWDimensions
    //2. readOAplLocations
    //3. buildCapoCoreRows 
     
    //manually construct the HGraphWDimensions according
    //to the "exposed interface" see ~/UCLApack/HGraphWDims/hgWDims.h
    //for more information.
    void buildCapoHGraphWDimensions(HGraphWDimensions*& hg);
    void buildCapoHGraphWDimensions(HGraphWDimensions*& hg, const oa::oaBox& bbox);
   
    void readOAPlLocations(uofm::vector<Point>& loc);    
 
    void buildCapoCoreRows(const PlacementWOrient* pl, 
                           uofm::vector<RBPCoreRow>*& cr);
    void buildCapoCoreRows(const PlacementWOrient* pl, 
                           uofm::vector<RBPCoreRow>*& cr,
                           const oa::oaBox& bbox);
    
    uofm::vector<oa::oaBlockObject*> getMapping(void)
        {return _node_idx_to_ptr;}
    bool isTerm(unsigned idx)
        {return _is_term[idx];}
    bool isFixedInst(unsigned idx)
        {return _is_fixed_inst[idx];}
   // void setSlicingTree(const RBPlace::SlicingTree& orig)
   //     { _slicingTree=oaSlicingTree(orig); }
   // oaSlicingTree getSlicingTree(void)
   //     { return _slicingTree; }
  private:
        uofm::vector<oa::oaBlockObject*> _node_idx_to_ptr;
        uofm::vector<bool> _is_term;
        uofm::vector<bool> _is_fixed_inst;
        oa::oaBlock* _block;
        oa::oaDesign* _design;
    //    oaSlicingTree _slicingTree;
};

#endif

