/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: David Papa <iamyou@umich.edu>

ChangeLog:
2004-09-15: ChangeLog started
*/

#include <iostream>
#include <deque>

#include "PlacerInterface.h"
#include "placerInternals.h"
#include "RBPlace/RBPlacement.h"
#include "MetaPlacer/metaPl.h"
#include "Capo/capoPlacer.h"
#include "oaIO.h"
#include "capoExposedInterface.h"
//#include "oaSlicingTree.h"

using std::string;
using std::vector;
using std::deque;
using std::cerr;
using std::endl;
using std::cout;

using oa::oaBlock;
using oa::oaDesign;
using oa::oaBox;
using oa::oaBoolean;

oaDesign* des_global_hack;


void place(const std::string& Lib, 
           const std::string& Cell,
           const std::string& View,
           int argc,
           const char** argv)
{

        for(unsigned i = 0; i < argc; ++i)
        {
            std::cout<<"argv["<<i<<"] : "<<argv[i]<<endl;
        }

        oaDesign* des=0;
        oaBlock* block=0;
        openOADesignBlock(des, block, Lib, Cell, View);
        des_global_hack = des;
        oaBox bbox;
        block->getBBox(bbox);
        capoExposedInterface capo(block, des, bbox);

        RBPlacement* rb = 0;
        buildCapoRBPlacementFromOA(rb, capo, argc, argv);
        MetaPlacer mpl(*rb, argc, const_cast<const char**>(argv)); 
        if(mpl.isRBPlaceUpdated())
            writeCapoPlacementToOA(*rb, capo); 

        //do not save the design, the user must do this 
        //des->save();
}


//void RipUpReplaceRectangle(const std::string& Lib, 
//           const std::string& Cell, 
//           const std::string& View,
//                   const oa::oaBox& bbox,
//           int argc,
//           char** argv)
//{
//
//        
//        deque<oaSlicingTreeIdxT> blockIdxQueue;
//
//
//        oaDesign* des=0;
//        oaBlock* block=0;
//        openOADesignBlock(des, block, Lib, Cell, View);
//        des_global_hack = des;
//        capoExposedInterface capo(block, des, bbox);
//          
//        RBPlacement* rb = 0;
//        
//        
//        //"The Loop"
//        blockIdxQueue.push_back(oaSlicingTreeIdxT(0));
//        while(!blockIdxQueue.empty())
//        {
//                //boxes in layer loop
//                //oaBox bbox = capo.getSlicingTree().getBBoxFromIdx(blockIdxQueue.front());
//                blockIdxQueue.pop_front();
//
//                buildCapoRBPlacementFromOARegionQuery(rb, capo, bbox, argc, argv);
//
//                CapoParameters params(argc, const_cast<const char**>(argv), false);
//                //TUNE CAPO PARAMS HERE IF U WANT
//
//                CapoPlacer capoPlacer(*rb, params); 
//                //capo.setSlicingTree(capoPlacer.getSlicingTree());
//                writeCapoPlacementToOA(*rb, capo); //TODO, make this incremental
//                //push new blocks?
//                
//        }  //end "The Loop"
//        
//        
//}

std::vector< std::pair < std::string, double > >
getNetSlacksFromWrapper(double target_clock)
{
  static_cast<void>(target_clock); //avoid unused parameter warning
  assert(0 && "This function is implemented with a stub and should not be called");
  return std::vector< std::pair< std::string, double> >(); //stub return empty vector
}


