/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: David Papa <iamyou@umich.edu>

ChangeLog:
2004-09-15: ChangeLog started
*/

#include <string>
#include <iostream>

#include "oaDesignDB.h"
#include "PlacerInterface.h"


using std::cout;
using std::endl;
using std::cerr;
using std::string;

using oa::oaDesignInit;
using oa::oaLibDefList;

int main(int argc, const char **argv)
{
    try
    {
        oaDesignInit();
        oaLibDefList::openLibs();
    }
    catch (oa::oaException &excp) {
        printf("Error: %s\n", (const char *)excp.getMsg());
        exit(1);
    }

    // Check number of arguments.
    if ( argc < 2 ) {
        cout<<" Use : "<<endl<<argv[0]<<" libraryName cellName viewName "<<endl;
    }

    // Get the names from the command line
    string Lib;
    if(argc < 2)
    {
        cout<<"Using default value for libraryName : \"designs\""<<endl;
        Lib = "designs";
    }
    else
        Lib = argv[1];

    string Cell;
    if(argc < 3)
    {
        cout<<"Using default value for cellName : \"s386_bench\""<<endl;
        Cell = "s386_bench";
    }
    else
        Cell = argv[2];

    string View;
    if(argc < 4)
    {
        cout<<"Using default value for viewName : \"physical\""<<endl;
        View = "physical";
    }
    else
        View = argv[3];

    place(Lib, Cell, View, argc, argv);

    //save the design
    try 
    {
        oa::oaDesign* _des = 0;
        try
        {
            // Get the oa names 
            oa::oaString        libstr(Lib.c_str());
            oa::oaString        cellstr(Cell.c_str());
            oa::oaString        viewstr(View.c_str());

            // Treat the names  as belonging 
            //to the Native namespace and convert them to oaNames.
            oa::oaNativeNS      ns;
            oa::oaScalarName    libName(ns, libstr);
            oa::oaScalarName    cellName(ns, cellstr);
            oa::oaScalarName    viewName(ns, viewstr);

            _des  = oa::oaDesign::open(libName, cellName, viewName, 'r') ;
        }
        catch (oa::oaException &excp) 
        {
            cerr<<"Can't read Lib/Cell/View "
                <<Lib<<"/"<<Cell<<"/"<<View <<" (check libDefFile)" << endl; 
            cerr<<"OpenAccess exception, Error: \t"<<
                static_cast<const char *>(excp.getMsg()) <<endl;
            exit(1);
        }
        _des->reopen('a');
        _des->save();
    }
    catch (oa::oaException &excp) 
    {
        cerr<<"OpenAcess exception while saving design, Error: "<<
            static_cast<const char *>(excp.getMsg())<<endl;
        exit(1);
    }

    return 0;
}
