/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */


#if !defined(oagLoader_P)
#define oagLoader_P

#include "mainwindow.h"


namespace oagBazaar
{
     class oagBazaarPlugInInterface;

     ///This class designed to load plugins in an encapsulated way
     /**
         This class is designed to shield Bazaar from the plug-in, and
         from the plug-in API to bazaar.  Bazaar will call oagLoader::load(Bazaar*)
         with a pointer to itself.  oagLoader will then create a PlugInAPI object
         and give it the Bazaar*.  oagLoader will then and call PlugIn::load(PlugInAPI*).
         The PlugIn will then have a pointer to the API, the API will have a pointer to Bazaar,
         and Bazaar doesnt know about any of this.  The loader is the only thing Bazaar needs
         to know about.  The PlugIn also does not know about Bazaar except for the API.
      */
     class oagLoader
     {
           public:
               void load(MainWindow* bazaar, oagBazaarPlugInInterface* plugIn);
         
     };

};

#endif

