/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: David Papa <iamyou@umich.edu>

ChangeLog:
2004-09-15: ChangeLog started
 */

#include <iostream>

#include "DebugLog.h"
#include "oagConnect.h"

using std::cerr;
using std::endl;
using oa::oaLibDef;
using oa::oaLib;
using oa::oaDesign;
using oa::oaBlock;
using oa::oaInst;
using oa::oaScalarName;
using oa::oaIter;

namespace oagBazaar
{


    oagConnection::oagConnection(std::string Lib, std::string Cell, std::string View):
        _Lib(Lib),
        _Cell(Cell),
        _View(View),
        _block(0), 
        _des(0), 
        _coreRegionBBox(0)
    {
        // Get the oa names 
        oa::oaString        libstr(_Lib.c_str());
        oa::oaString        cellstr(_Cell.c_str());
        oa::oaString        viewstr(_View.c_str());

        // Treat the names  as belonging 
        //to the Native namespace and convert them to oaNames.
        oa::oaNativeNS      ns;
        oa::oaScalarName    libName(ns, libstr);
        oa::oaScalarName    cellName(ns, cellstr);
        oa::oaScalarName    viewName(ns, viewstr);

        try 
        {
            try
            {
                _des  = oa::oaDesign::open(libName, cellName, viewName, 'r') ;
            }
            catch (oa::oaException &excp) 
            {
                cerr<<"Can't read CellView "<<static_cast<const char *>(libstr)
                    <<static_cast<const char *>(cellstr)
                    <<static_cast<const char *>(viewstr) 
                    <<" (check libDefFile)" << endl; 
                cerr<<"OpenAccess exception, Error: \t"<<
                    static_cast<const char *>(excp.getMsg()) <<endl;
                exit(1);
            }

            _block = _des->getTopBlock() ;
            if(_coreRegionBBox)
            {
                delete _coreRegionBBox;
                _coreRegionBBox = 0;
            }
        }
        catch (oa::oaException &excp) 
        {
            cerr<<"OpenAcess exception opening design, Error: "<<
                static_cast<const char *>(excp.getMsg())<<endl;
            exit(1);
        }

    }

    oagConnection::~oagConnection(void)
    {
        if(_coreRegionBBox)
        {
            delete _coreRegionBBox;
            _coreRegionBBox = 0;
        }
        if(_des)
        {
            _des->close();
        }
    }

    oagDesignBlock oagConnection::getOAGDesignBlock(void)
    {
        oagDesignBlock rval;
        rval.block = _block;
        rval.design = _des;

        return rval;
    }

    void oagConnection::getWriteAccess(void)
    {
        try 
        {
            _des->reopen('a');
        }
        catch (oa::oaException &excp) 
        {
            cerr<<"OpenAcess exception opening design in append mode, Error: "<<
                static_cast<const char *>(excp.getMsg())<<endl;
            exit(1);
        }

        DebugLog::ostream() << "DEBUG: Obtained append access to design "<<_Lib<<"/"<<_Cell<<"/"<<_View<<endl;
    }

    const oa::oaBox& oagConnection::getCoreRegionBBox()
    { 
        if(!_coreRegionBBox)
        {
            _coreRegionBBox = new oa::oaBox();
            _block->getBBox(*_coreRegionBBox);
        }
        return *_coreRegionBBox; 
    }

}
