/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */
#include "oagBazaarPlugInAPI.h"
#include "QoagCommon/QoagCommon.h"

using std::string;

namespace oagBazaar
{
    oagBazaarPlugInAPI::oagBazaarPlugInAPI(MainWindow* bazaar):
        _bazaar(bazaar)
    {

    }

    QPopupMenu* oagBazaarPlugInAPI::addMenu(const string& name)
    {
        QPopupMenu* rval = _bazaar->addMenu(name);
        return rval;
    }

    QPopupMenu* oagBazaarPlugInAPI::addMenu(const string& iconName, const string& name)
    {
        QPopupMenu* rval = _bazaar->addMenu(iconName, name);
        return rval;
    }

    void oagBazaarPlugInAPI::addMenuItem(QPopupMenu* menu, QAction* menuItem)
    {
        menuItem->addTo(menu);
    }

    QToolBar* oagBazaarPlugInAPI::addToolBar(const string& name)
    {
        QToolBar* rval = _bazaar->addToolBar(name);
        return rval;

    }

    QAction* oagBazaarPlugInAPI::createAction(const string& command, const string& caption, const string& statusTip)
    {
        return createAction(command, caption, statusTip, "");
    }

    QAction* oagBazaarPlugInAPI::createAction(const string& command, const string& caption, const string& statusTip, const string& iconFileName)
    {

        Qoag::QoagTCLAction* menuItem = new Qoag::QoagTCLAction(QAction::tr(caption.c_str()), 0, _bazaar);
        menuItem->setStatusTip(QAction::tr(statusTip.c_str()));
        if(!iconFileName.empty())
            menuItem->setIconSet(QPixmap::fromMimeSource(iconFileName.c_str()));
        QObject::connect( menuItem, SIGNAL( execute( QAction* ) ),
                _bazaar, SLOT( runCommand( QAction* ) ) );
        _bazaar->registerAction(command, menuItem);
        return menuItem;
    }

    void oagBazaarPlugInAPI::addToolBarButton(QToolBar* toolBar, QAction* toolBarButton)
    {
        toolBarButton->addTo(toolBar);
    }

    void oagBazaarPlugInAPI::giveWidget(QWidget* widget)
    {
        _bazaar->takeWidget(widget);
    }

    void oagBazaarPlugInAPI::giveDialog(QDialog* dialog)
    {
        _bazaar->takeDialog(dialog);
    }

    void oagBazaarPlugInAPI::giveThread(QoagThread* thread)
    {
        _bazaar->takeThread(thread);
    }


    void oagBazaarPlugInAPI::registerTCLCommand(Tcl_CmdProc* cmd, const string& cmdName, ClientData clientData, Tcl_CmdDeleteProc *deleteProc)
    {
        _bazaar->registerCommand(cmd, cmdName, clientData, deleteProc);
    }

    void oagBazaarPlugInAPI::connectCommand(const QObject* sender, const char * signal)
    {
        QObject::connect( sender, signal, _bazaar, SLOT( runCommand( const std::string& ) ) );
    }

    void oagBazaarPlugInAPI::getActiveDesign(string& library, string& cell, string& view)
    {
        _bazaar->getActiveDesign(library, cell, view); 
    }

    void oagBazaarPlugInAPI::runCommand(const std::string& command)
    {
        _bazaar->runCommand(command);
    }


};


